/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.formatter;

import com.oracle.js.parser.ir.FunctionNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.javascript2.editor.embedding.JsEmbeddingProvider;
import org.netbeans.modules.javascript2.editor.formatter.CodeStyle;
import org.netbeans.modules.javascript2.editor.formatter.Defaults;
import org.netbeans.modules.javascript2.editor.formatter.FormatToken;
import org.netbeans.modules.javascript2.editor.formatter.FormatTokenStream;
import org.netbeans.modules.javascript2.editor.formatter.JsFormatter;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;

public final class FormatContext {
    private static final Logger LOGGER = Logger.getLogger(FormatContext.class.getName());
    private static final Pattern SAFE_DELETE_PATTERN = Pattern.compile("\\s*");
    private static final Comparator<Region> REGION_COMPARATOR = (o1, o2) -> {
        if (o1.getOriginalStart() < o2.getOriginalStart()) {
            return -1;
        }
        if (o1.getOriginalStart() > o2.getOriginalStart()) {
            return 1;
        }
        return 0;
    };
    private final Context context;
    private final Snapshot snapshot;
    private final Language<JsTokenId> languange;
    private final Defaults.Provider provider;
    private final FunctionNode root;
    private final FormatTokenStream stream;
    private final int initialStart;
    private final int initialEnd;
    private final List<Region> regions;
    private final boolean embedded;
    private final Stack<JsxBlock> jsxIndents = new Stack();
    private final Map<FormatToken, JsxBlock> jsxIndentsMap = new HashMap<FormatToken, JsxBlock>();
    private final Deque<JsxElement> jsxPath = new ArrayDeque<JsxElement>();
    private LineWrap lastLineWrap;
    private int indentationLevel;
    private int continuationLevel;
    private int offsetDiff;
    private int currentLineStart;
    private boolean pendingContinuation;
    private int tabCount;

    public FormatContext(Context context, Defaults.Provider provider, Snapshot snapshot, Language<JsTokenId> language, FunctionNode root, FormatTokenStream stream) {
        this.context = context;
        this.snapshot = snapshot;
        this.languange = language;
        this.provider = provider;
        this.root = root;
        this.stream = stream;
        this.initialStart = context.startOffset();
        this.initialEnd = context.endOffset();
        this.regions = new ArrayList<Region>(context.indentRegions().size());
        for (Context.Region region : context.indentRegions()) {
            this.regions.add(new Region(region));
        }
        this.regions.sort(REGION_COMPARATOR);
        this.dumpRegions();
        this.embedded = JsParserResult.isEmbedded(snapshot);
        if (this.embedded) {
            for (Region region : this.regions) {
                int endOffset = region.getOriginalEnd();
                try {
                    Token token;
                    int embeddedOffset;
                    int lineOffset = context.lineStartOffset(endOffset);
                    TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)snapshot, (int)region.getOriginalStart(), language);
                    if (ts == null || (embeddedOffset = snapshot.getEmbeddedOffset(lineOffset)) < 0) continue;
                    ts.move(embeddedOffset);
                    if (!ts.moveNext() || (token = ts.token()).id() != JsTokenId.WHITESPACE || lineOffset + token.length() != endOffset) continue;
                    region.setOriginalEnd(lineOffset);
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            LOGGER.log(Level.FINE, "Tuned regions");
            this.dumpRegions();
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Defaults.Provider getDefaultsProvider() {
        return this.provider;
    }

    public void incJsxIndentation(FormatToken token) {
        int value;
        Integer indent;
        FormatToken next;
        assert (token.getKind() == FormatToken.Kind.BEFORE_JSX_BLOCK_START);
        assert (token.next() != null);
        for (next = token.next(); next != null && next.getId() != JsTokenId.JSX_TEXT; next = next.next()) {
        }
        Integer n = indent = next != null ? this.getSuggestedIndentation(next.getOffset()) : null;
        if (indent == null) {
            indent = next != null ? this.stream.getOriginalIndent(next) : null;
        }
        int current = value = indent != null ? indent : 0;
        try {
            current = this.context.lineIndent(this.context.lineStartOffset(token.next().getOffset() + this.offsetDiff));
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        JsxBlock block = new JsxBlock(value, 0, 0, current);
        this.jsxIndents.push(block);
        this.jsxIndentsMap.put(token, block);
    }

    public void updateJsxIndentation(FormatToken token) {
        assert (token.getKind() == FormatToken.Kind.BEFORE_JSX_BLOCK_START);
        assert (token.next() != null);
        try {
            int indent = this.context.lineIndent(this.context.lineStartOffset(token.next().getOffset() + this.offsetDiff));
            JsxBlock current = this.jsxIndentsMap.get(token);
            if (current != null) {
                current.update(this.indentationLevel, this.continuationLevel, indent);
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    public void decJsxIndentation(FormatToken token) {
        assert (token.getKind() == FormatToken.Kind.AFTER_JSX_BLOCK_END);
        this.jsxIndentsMap.remove(token);
        this.jsxIndents.pop();
    }

    public int getJsxIndentation() {
        if (this.jsxIndents.isEmpty()) {
            return 0;
        }
        return this.jsxIndents.peek().getIndent();
    }

    public int getBaseJsxIndentation() {
        if (this.jsxIndents.isEmpty()) {
            return 0;
        }
        return this.jsxIndents.peek().getBaseIndent();
    }

    public boolean isInsideJsx() {
        return !this.jsxIndents.isEmpty();
    }

    public void updateJsxPath(char first, Character second) {
        assert (this.isInsideJsx());
        switch (first) {
            case '<': {
                this.jsxPath.push(new JsxElement(JsxElement.Type.TAG, null));
                break;
            }
            case '>': {
                JsxElement element;
                JsxElement jsxElement = element = this.jsxPath.isEmpty() ? null : this.jsxPath.peek();
                if (element == null || element.getType() != JsxElement.Type.TAG) break;
                this.jsxPath.pop();
                break;
            }
            case '=': {
                if (this.jsxPath.isEmpty() || this.jsxPath.peek().getType() != JsxElement.Type.TAG || second == null) break;
                if (second.charValue() == '{') {
                    this.jsxPath.push(new JsxElement(JsxElement.Type.ATTRIBUTE, Character.valueOf('}')));
                    break;
                }
                if (second.charValue() != '\"' && second.charValue() != '\'') break;
                this.jsxPath.push(new JsxElement(JsxElement.Type.ATTRIBUTE, second));
                break;
            }
            case '\"': 
            case '\'': 
            case '}': {
                JsxElement element;
                JsxElement jsxElement = element = this.jsxPath.isEmpty() ? null : this.jsxPath.peek();
                if (element == null || element.getType() != JsxElement.Type.ATTRIBUTE || element.getClosingChar().charValue() != first) break;
                this.jsxPath.pop();
                break;
            }
        }
    }

    public Integer getSuggestedIndentation(FormatToken token) {
        if (this.jsxIndents.isEmpty()) {
            return 0;
        }
        if (!this.jsxPath.isEmpty() && this.jsxPath.peek().getType() == JsxElement.Type.ATTRIBUTE) {
            return 0;
        }
        Integer value = this.getSuggestedIndentation(token.getOffset());
        return value == null ? 0 : value;
    }

    public void setLastLineWrap(LineWrap lineWrap) {
        this.lastLineWrap = lineWrap;
    }

    public LineWrap getLastLineWrap() {
        return this.lastLineWrap;
    }

    public int getCurrentLineStart() {
        return this.currentLineStart;
    }

    public void setCurrentLineStart(int currentLineStart) {
        this.currentLineStart = currentLineStart;
    }

    public int getIndentationLevel() {
        if (!this.jsxIndents.isEmpty()) {
            return this.indentationLevel - this.jsxIndents.peek().getIndentationLevel();
        }
        return this.indentationLevel;
    }

    public void incIndentationLevel() {
        ++this.indentationLevel;
    }

    public void decIndentationLevel() {
        --this.indentationLevel;
    }

    public int getContinuationLevel() {
        if (!this.jsxIndents.isEmpty()) {
            return this.continuationLevel - this.jsxIndents.peek().getContinuationLevel();
        }
        return this.continuationLevel;
    }

    public void incContinuationLevel() {
        ++this.continuationLevel;
    }

    public void decContinuationLevel() {
        --this.continuationLevel;
    }

    public boolean isPendingContinuation() {
        return this.pendingContinuation;
    }

    public void setPendingContinuation(boolean pendingContinuation) {
        this.pendingContinuation = pendingContinuation;
    }

    public void incTabCount() {
        ++this.tabCount;
    }

    public void resetTabCount() {
        this.tabCount = 0;
    }

    public int getTabCount() {
        return this.tabCount;
    }

    public int getOffsetDiff() {
        return this.offsetDiff;
    }

    private void setOffsetDiff(int offsetDiff) {
        this.offsetDiff = offsetDiff;
    }

    private void dumpRegions() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        for (Region region : this.regions) {
            try {
                LOGGER.log(Level.FINE, "{0}:{1}:{2}", new Object[]{region.getOriginalStart(), region.getOriginalEnd(), this.getDocument().getText(region.getOriginalStart(), region.getOriginalEnd() - region.getOriginalStart())});
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
    }

    public int getEmbeddedRegionEnd(int offset) {
        if (!this.embedded) {
            return -1;
        }
        int docOffset = this.snapshot.getOriginalOffset(offset);
        if (docOffset < 0) {
            return -1;
        }
        for (Region region : this.regions) {
            if (docOffset < region.getOriginalStart() || docOffset >= region.getOriginalEnd()) continue;
            return this.snapshot.getEmbeddedOffset(region.getOriginalEnd());
        }
        return -1;
    }

    public int getDocumentOffset(int offset) {
        return this.getDocumentOffset(offset, true);
    }

    private int getDocumentOffset(int offset, boolean check) {
        if (!this.embedded) {
            if (!check || offset >= this.initialStart && offset < this.initialEnd) {
                return offset;
            }
            return -1;
        }
        int docOffset = this.snapshot.getOriginalOffset(offset);
        if (docOffset < 0) {
            return -1;
        }
        for (Region region : this.regions) {
            if (docOffset < region.getOriginalStart() || docOffset >= region.getOriginalEnd()) continue;
            return docOffset;
        }
        return -1;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public int getEmbeddingIndent(FormatTokenStream stream, FormatToken token) {
        if (!this.embedded) {
            return 0;
        }
        int docOffset = this.snapshot.getOriginalOffset(token.getOffset());
        if (docOffset < 0) {
            return 0;
        }
        Region start = null;
        int i = 0;
        for (Region region : this.regions) {
            if (docOffset >= region.getOriginalStart() && docOffset < region.getOriginalEnd()) {
                start = region;
                break;
            }
            ++i;
        }
        if (start != null && start.getInitialIndentation() < 0) {
            try {
                boolean nonEmpty = false;
                FormatToken startToken = stream.getCoveringToken(this.snapshot.getEmbeddedOffset(start.getOriginalStart()));
                if (startToken != null) {
                    for (FormatToken previous = startToken.previous(); previous != null; previous = previous.previous()) {
                        if (!previous.isVirtual()) {
                            if (this.getDocumentOffset(previous.getOffset()) >= 0) {
                                nonEmpty = startToken == FormatTokenStream.getNextNonVirtual(previous);
                                break;
                            }
                            nonEmpty = JsEmbeddingProvider.isGeneratedIdentifier(previous.getText().toString());
                        }
                        if (nonEmpty) break;
                    }
                }
                if (nonEmpty && i > 0) {
                    Region regionWithIndentation = null;
                    for (int j = i - 1; j >= 0; --j) {
                        if (this.regions.get(j).getInitialIndentation() < 0) continue;
                        regionWithIndentation = this.regions.get(j);
                        break;
                    }
                    if (regionWithIndentation != null) {
                        start.setInitialIndentation(regionWithIndentation.getInitialIndentation());
                    } else {
                        start.setInitialIndentation(0);
                    }
                } else if (start.getOriginalStart() <= 0) {
                    start.setInitialIndentation(0);
                } else {
                    start.setInitialIndentation(this.context.lineIndent(this.context.lineStartOffset(start.getContextRegion().getStartOffset())) + IndentUtils.indentLevelSize((Document)this.getDocument()));
                }
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return start != null ? start.getInitialIndentation() : 0;
    }

    public boolean isGenerated(FormatToken token) {
        return this.embedded && JsEmbeddingProvider.isGeneratedIdentifier(token.getText().toString());
    }

    public boolean isBrokenSource() {
        return this.embedded && this.root == null;
    }

    public Document getDocument() {
        return this.context.document();
    }

    private LineDocument getLineDocument() {
        return (LineDocument)LineDocumentUtils.as((Document)this.context.document(), LineDocument.class);
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void indentLine(int voffset, int indentationSize, JsFormatter.Indentation indentationCheck, CodeStyle.Holder codeStyle) {
        this.indentLineWithOffsetDiff(voffset, indentationSize, indentationCheck, this.offsetDiff, codeStyle);
    }

    public void indentLineWithOffsetDiff(int voffset, int indentationSize, JsFormatter.Indentation indentationCheck, int realOffsetDiff, CodeStyle.Holder codeStyle) {
        if (!indentationCheck.isAllowed()) {
            return;
        }
        int offset = this.getDocumentOffset(voffset, !indentationCheck.isExceedLimits());
        if (offset < 0) {
            return;
        }
        try {
            int diff = FormatContext.setLineIndentation(this.getLineDocument(), offset + realOffsetDiff, indentationSize, codeStyle);
            this.setOffsetDiff(this.offsetDiff + diff);
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    public void insert(int voffset, String newString) {
        this.insertWithOffsetDiff(voffset, newString, this.offsetDiff);
    }

    public void insertWithOffsetDiff(int voffset, String newString, int realOffsetDiff) {
        int offset = this.getDocumentOffset(voffset);
        if (offset < 0) {
            return;
        }
        Document doc = this.getDocument();
        try {
            doc.insertString(offset + realOffsetDiff, newString, null);
            this.setOffsetDiff(this.offsetDiff + newString.length());
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    public void replace(int voffset, String oldString, String newString) {
        if (oldString.equals(newString)) {
            return;
        }
        this.replace(voffset, oldString.length(), newString);
    }

    public void replace(int voffset, int vlength, String newString) {
        int offset = this.getDocumentOffset(voffset);
        if (offset < 0) {
            return;
        }
        int length = this.computeLength(voffset, vlength);
        if (length <= 0) {
            this.insert(voffset, newString);
            return;
        }
        Document doc = this.getDocument();
        try {
            String oldText = doc.getText(offset + this.offsetDiff, length);
            if (newString.equals(oldText)) {
                return;
            }
            if (SAFE_DELETE_PATTERN.matcher(oldText).matches()) {
                doc.remove(offset + this.offsetDiff, length);
                doc.insertString(offset + this.offsetDiff, newString, null);
                this.setOffsetDiff(this.offsetDiff + (newString.length() - length));
            } else {
                LOGGER.log(Level.WARNING, "Tried to remove non empty text: {0}", doc.getText(offset + this.offsetDiff, length));
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    public void remove(int voffset, int vlength) {
        int offset = this.getDocumentOffset(voffset);
        if (offset < 0) {
            return;
        }
        int length = this.computeLength(voffset, vlength);
        if (length <= 0) {
            return;
        }
        Document doc = this.getDocument();
        try {
            if (doc.getText(offset + this.offsetDiff, length).contains("\n")) {
                LOGGER.log(Level.WARNING, "Tried to remove EOL");
            }
            if (SAFE_DELETE_PATTERN.matcher(doc.getText(offset + this.offsetDiff, length)).matches()) {
                doc.remove(offset + this.offsetDiff, length);
                this.setOffsetDiff(this.offsetDiff - length);
            } else {
                LOGGER.log(Level.WARNING, "Tried to remove non empty text: {0}", doc.getText(offset + this.offsetDiff, length));
            }
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    private Integer getSuggestedIndentation(int offset) {
        LineDocument doc = this.getLineDocument();
        if (doc == null) {
            return null;
        }
        Map suggestedLineIndents = (Map)doc.getProperty((Object)"AbstractIndenter.lineIndents");
        if (suggestedLineIndents != null) {
            try {
                int lineIndex = LineDocumentUtils.getLineIndex((LineDocument)doc, (int)(offset + this.offsetDiff));
                Integer indent = (Integer)suggestedLineIndents.get(lineIndex);
                return indent != null ? indent : null;
            }
            catch (BadLocationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    private int computeLength(int voffset, int length) {
        if (!this.embedded) {
            return length;
        }
        for (int i = 0; i < length; ++i) {
            if (this.getDocumentOffset(voffset + i) >= 0) continue;
            return i;
        }
        return length;
    }

    private static int setLineIndentation(LineDocument doc, int lineOffset, int newIndent, CodeStyle.Holder codeStyle) throws BadLocationException {
        int i;
        char ch;
        int oldIndentEndOffset;
        if (doc == null) {
            return 0;
        }
        int lineStartOffset = LineDocumentUtils.getLineStart((LineDocument)doc, (int)lineOffset);
        int indent = 0;
        int tabSize = -1;
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        for (oldIndentEndOffset = lineStartOffset; oldIndentEndOffset < docText.length() && (ch = docText.charAt(oldIndentEndOffset)) != '\n'; ++oldIndentEndOffset) {
            if (ch == '\t') {
                if (tabSize == -1) {
                    tabSize = codeStyle.tabSize;
                }
                indent = (indent + tabSize) / tabSize * tabSize;
                continue;
            }
            if (!Character.isWhitespace(ch)) break;
            ++indent;
        }
        String newIndentString = IndentUtils.createIndentString((int)newIndent, (boolean)codeStyle.expandTabsToSpaces, (int)codeStyle.tabSize);
        int offset = lineStartOffset;
        boolean different = false;
        for (i = 0; i < newIndentString.length() && lineStartOffset + i < oldIndentEndOffset; ++i) {
            if (newIndentString.charAt(i) == docText.charAt(lineStartOffset + i)) continue;
            offset = lineStartOffset + i;
            newIndentString = newIndentString.substring(i);
            different = true;
            break;
        }
        if (!different) {
            offset = lineStartOffset + i;
            newIndentString = newIndentString.substring(i);
        }
        if (offset < oldIndentEndOffset) {
            doc.remove(offset, oldIndentEndOffset - offset);
        }
        if (newIndentString.length() > 0) {
            doc.insertString(offset, newIndentString, null);
        }
        return newIndentString.length() - (oldIndentEndOffset - offset);
    }

    private static class Region {
        private final Context.Region contextRegion;
        private final int originalStart;
        private int originalEnd;
        private int initialIndentation = -1;

        public Region(Context.Region contextRegion) {
            this.contextRegion = contextRegion;
            this.originalStart = contextRegion.getStartOffset();
            this.originalEnd = contextRegion.getEndOffset();
        }

        public Context.Region getContextRegion() {
            return this.contextRegion;
        }

        public int getOriginalStart() {
            return this.originalStart;
        }

        public int getOriginalEnd() {
            return this.originalEnd;
        }

        public void setOriginalEnd(int originalEnd) {
            this.originalEnd = originalEnd;
        }

        public int getInitialIndentation() {
            return this.initialIndentation;
        }

        public void setInitialIndentation(int initialIndentation) {
            this.initialIndentation = initialIndentation;
        }
    }

    private static class JsxBlock {
        private final int baseIndent;
        private int indentationLevel;
        private int continuationLevel;
        private int indent;

        public JsxBlock(int baseIndent, int indentationLevel, int continuationLevel, int indent) {
            this.baseIndent = baseIndent;
            this.indentationLevel = indentationLevel;
            this.continuationLevel = continuationLevel;
            this.indent = indent;
        }

        public int getBaseIndent() {
            return this.baseIndent;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        public int getContinuationLevel() {
            return this.continuationLevel;
        }

        public int getIndent() {
            return this.indent;
        }

        public void update(int indentationLevel, int continuationLevel, int indent) {
            this.indentationLevel = indentationLevel;
            this.continuationLevel = continuationLevel;
            this.indent = indent;
        }
    }

    public static class JsxElement {
        private final Type type;
        private final Character closingChar;

        public JsxElement(Type type, Character closingChar) {
            assert (type == Type.TAG || closingChar != null);
            this.type = type;
            this.closingChar = closingChar;
        }

        public Type getType() {
            return this.type;
        }

        public Character getClosingChar() {
            return this.closingChar;
        }

        public static enum Type {
            TAG,
            ATTRIBUTE;

        }
    }

    public static class LineWrap {
        private final FormatToken token;
        private final int offsetDiff;
        private final int indentationLevel;
        private final int continuationLevel;

        public LineWrap(FormatToken token, int offsetDiff, int indentationLevel, int continuationLevel) {
            this.token = token;
            this.offsetDiff = offsetDiff;
            this.indentationLevel = indentationLevel;
            this.continuationLevel = continuationLevel;
        }

        public FormatToken getToken() {
            return this.token;
        }

        public int getOffsetDiff() {
            return this.offsetDiff;
        }

        public int getIndentationLevel() {
            return this.indentationLevel;
        }

        public int getContinuationLevel() {
            return this.continuationLevel;
        }
    }

    public static class ContinuationBlock {
        private final Type type;
        private final boolean change;

        public ContinuationBlock(Type type, boolean change) {
            this.type = type;
            this.change = change;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isChange() {
            return this.change;
        }

        public static enum Type {
            CURLY,
            BRACKET,
            PAREN;

        }
    }
}

