/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.typinghooks;

import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.xhtml.XhtmlElTokenId;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.util.Exceptions;

public class HtmlTypedTextInterceptor
implements TypedTextInterceptor {
    static boolean adjust_quote_type_after_eq = true;
    static char default_quote_char_after_eq = (char)34;
    private static DocumentInsertIgnore insertIgnore;

    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        int dotPos = context.getOffset();
        Caret caret = context.getComponent().getCaret();
        char ch = context.getText().charAt(0);
        if (insertIgnore != null) {
            DocumentInsertIgnore local = insertIgnore;
            insertIgnore = null;
            if (local.getOffset() == dotPos && local.getChar() == ch) {
                if (local.getMoveCaretTo() != -1) {
                    caret.setDot(local.moveCaretTo);
                    Completion.get().hideAll();
                }
                return true;
            }
        } else {
            switch (ch) {
                case '\"': 
                case '\'': {
                    boolean result = HtmlTypedTextInterceptor.skipExistingQuote(context);
                    if (!result) {
                        result = HtmlTypedTextInterceptor.changeQuotesType(context);
                    }
                    return result;
                }
            }
        }
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        char ch = context.getText().charAt(0);
        switch (ch) {
            case '=': {
                HtmlTypedTextInterceptor.addPairOfQuotes(context);
                break;
            }
            case '\"': 
            case '\'': {
                HtmlTypedTextInterceptor.addSecondQuote(context);
                break;
            }
            case '{': {
                HtmlTypedTextInterceptor.addClosingELDelimiter(context);
                break;
            }
            case '/': {
                HtmlTypedTextInterceptor.addTagClosingSymbol(context);
                break;
            }
            case '>': {
                HtmlTypedTextInterceptor.indentLineAfterTagClosingSymbol(context);
            }
        }
    }

    public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(TypedTextInterceptor.Context context) {
        insertIgnore = null;
    }

    private static void indentLineAfterTagClosingSymbol(TypedTextInterceptor.MutableContext context) {
        int offset;
        final BaseDocument doc = (BaseDocument)context.getDocument();
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)(offset = context.getOffset()), (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return;
        }
        if (null != LexerUtils.followsToken((TokenSequence)ts, EnumSet.of(HTMLTokenId.TAG_OPEN, HTMLTokenId.TAG_CLOSE), (boolean)true, (boolean)false, (TokenId[])new TokenId[]{HTMLTokenId.ARGUMENT, HTMLTokenId.VALUE, HTMLTokenId.VALUE_CSS, HTMLTokenId.VALUE_JAVASCRIPT, HTMLTokenId.OPERATOR, HTMLTokenId.WS, HTMLTokenId.EL_CLOSE_DELIMITER, HTMLTokenId.EL_CONTENT, HTMLTokenId.EL_OPEN_DELIMITER})) {
            try {
                final Position from = doc.createPosition(LineDocumentUtils.getLineStartOffset((LineDocument)doc, (int)offset));
                final Position to = doc.createPosition(LineDocumentUtils.getLineEndOffset((LineDocument)doc, (int)offset));
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        final Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            doc.runAtomic(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        indent.reindent(from.getOffset(), to.getOffset());
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                }
                            });
                        }
                        finally {
                            indent.unlock();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void addTagClosingSymbol(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        TokenSequence ts = LexerUtils.getTokenSequence((Document)((BaseDocument)context.getDocument()), (int)context.getOffset(), (Language)HTMLTokenId.language(), (boolean)true);
        if (ts == null) {
            return;
        }
        ts.move(context.getOffset());
        if (!ts.moveNext()) {
            return;
        }
        HTMLTokenId tid = (HTMLTokenId)ts.token().id();
        if (tid == HTMLTokenId.WS && null != LexerUtils.followsToken((TokenSequence)ts, (TokenId)HTMLTokenId.TAG_OPEN, (boolean)true, (boolean)false, (TokenId[])new TokenId[]{HTMLTokenId.ARGUMENT, HTMLTokenId.VALUE, HTMLTokenId.VALUE_CSS, HTMLTokenId.VALUE_JAVASCRIPT, HTMLTokenId.OPERATOR, HTMLTokenId.WS, HTMLTokenId.EL_CLOSE_DELIMITER, HTMLTokenId.EL_CONTENT, HTMLTokenId.EL_OPEN_DELIMITER})) {
            context.setText("/>", 2);
            insertIgnore = new DocumentInsertIgnore(context.getOffset() + 2, '>', -1);
        }
    }

    private static boolean skipExistingQuote(final TypedTextInterceptor.Context context) throws BadLocationException {
        if (!HtmlPreferences.autocompleteQuotes()) {
            return false;
        }
        final BaseDocument doc = (BaseDocument)context.getDocument();
        final AtomicBoolean result = new AtomicBoolean();
        doc.render(new Runnable(){

            @Override
            public void run() {
                int dotPos = context.getOffset();
                char qchar = context.getText().charAt(0);
                TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
                if (ts == null) {
                    return;
                }
                int diff = ts.move(dotPos);
                if (diff == 0 ? !ts.movePrevious() : !ts.moveNext()) {
                    return;
                }
                Token token = ts.token();
                if (HtmlTypedTextInterceptor.isHtmlValueToken(token) && diff > 0 && token.text().charAt(diff) == qchar) {
                    context.getComponent().setCaretPosition(dotPos + 1);
                    result.set(true);
                }
            }
        });
        return result.get();
    }

    private static void addSecondQuote(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        if (!HtmlPreferences.autocompleteQuotes()) {
            return;
        }
        int dotPos = context.getOffset();
        char qchar = context.getText().charAt(0);
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)context.getDocument()), (int)dotPos, (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        int diff = ts.move(dotPos);
        if (diff == 0 ? !ts.movePrevious() : !ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        if (token.id() == HTMLTokenId.OPERATOR) {
            Token next;
            if (ts.moveNext() && HtmlTypedTextInterceptor.isHtmlValueToken(next = ts.token())) {
                return;
            }
            StringBuilder insert = new StringBuilder().append(qchar).append(qchar);
            context.setText(insert.toString(), 1);
        }
    }

    private static boolean isHtmlValueToken(Token token) {
        TokenId id = token.id();
        return id == HTMLTokenId.VALUE || id == HTMLTokenId.VALUE_CSS || id == HTMLTokenId.VALUE_JAVASCRIPT;
    }

    private static void addPairOfQuotes(TypedTextInterceptor.MutableContext context) {
        if (!HtmlPreferences.autocompleteQuotesAfterEqualSign()) {
            return;
        }
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)context.getDocument()), (int)context.getOffset(), (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(context.getOffset());
        if (LexerUtils.followsToken((TokenSequence)ts, (TokenId)HTMLTokenId.ARGUMENT, (boolean)true, (boolean)false, (TokenId[])new TokenId[0]) != null) {
            String insert = "" + '=' + default_quote_char_after_eq + default_quote_char_after_eq;
            context.setText(insert, 2);
        }
    }

    private static boolean changeQuotesType(final TypedTextInterceptor.Context context) {
        if (!HtmlPreferences.autocompleteQuotesAfterEqualSign()) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean();
        final BaseDocument doc = (BaseDocument)context.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                String pattern;
                int dotPos = context.getOffset();
                char expected = context.getText().charAt(0);
                TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
                if (ts == null) {
                    return;
                }
                ts.move(dotPos);
                if (!ts.moveNext()) {
                    return;
                }
                Token token = ts.token();
                int dotPosBeforeTypedChar = dotPos - 1;
                String text = token.text().toString();
                String string = pattern = expected == '\'' ? "\"\"" : "''";
                if (text.contentEquals(pattern)) {
                    try {
                        doc.remove(dotPosBeforeTypedChar, 2);
                        doc.insertString(dotPosBeforeTypedChar, "" + expected + expected, null);
                        context.getComponent().setCaretPosition(dotPosBeforeTypedChar + 1);
                        result.set(true);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (adjust_quote_type_after_eq) {
                    default_quote_char_after_eq = expected;
                }
            }
        });
        return result.get();
    }

    private static void addClosingELDelimiter(TypedTextInterceptor.MutableContext context) {
        char charBefore;
        TokenHierarchy th = TokenHierarchy.get((Document)context.getDocument());
        TokenSequence ts = th.tokenSequence(XhtmlElTokenId.language());
        if (ts == null) {
            return;
        }
        int diff = ts.move(context.getOffset());
        if (diff == 0) {
            return;
        }
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        int dotPosAfterTypedChar = context.getOffset() + 1;
        if (token.id() == XhtmlElTokenId.HTML && ((charBefore = token.text().charAt(diff - 1)) == '$' || charBefore == '#')) {
            char charAfter = token.text().charAt(diff);
            if (charAfter == '}') {
                return;
            }
            context.setText("{}", 1);
            Completion.get().showCompletion();
            insertIgnore = new DocumentInsertIgnore(dotPosAfterTypedChar, '}', dotPosAfterTypedChar + 1);
        }
    }

    private static class DocumentInsertIgnore {
        private final int offset;
        private final char ch;
        private final int moveCaretTo;

        public DocumentInsertIgnore(int offset, char ch, int moveCaretTo) {
            this.offset = offset;
            this.ch = ch;
            this.moveCaretTo = moveCaretTo;
        }

        public char getChar() {
            return this.ch;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getMoveCaretTo() {
            return this.moveCaretTo;
        }
    }

    public static final class InsertIgnoreFactory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new InsertIgnoreSupportTypedTextInterceptor();
        }
    }

    public static final class CssFactory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new CssTypedTextInterceptor();
        }
    }

    public static final class HtmlFactory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new HtmlTypedTextInterceptor();
        }
    }

    private static class TypedTextInterceptorAdapter
    implements TypedTextInterceptor {
        private TypedTextInterceptorAdapter() {
        }

        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            return false;
        }

        public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        }

        public void afterInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        }

        public void cancelled(TypedTextInterceptor.Context context) {
        }
    }

    private static class CssTypedTextInterceptor
    extends TypedTextInterceptorAdapter {
        private CssTypedTextInterceptor() {
        }

        @Override
        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            char ch = context.getText().charAt(0);
            switch (ch) {
                case '\"': 
                case '\'': {
                    boolean result = HtmlTypedTextInterceptor.skipExistingQuote(context);
                    if (!result) {
                        result = HtmlTypedTextInterceptor.changeQuotesType(context);
                    }
                    return result;
                }
            }
            return false;
        }
    }

    private static class InsertIgnoreSupportTypedTextInterceptor
    extends TypedTextInterceptorAdapter {
        private InsertIgnoreSupportTypedTextInterceptor() {
        }

        @Override
        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            if (insertIgnore != null) {
                DocumentInsertIgnore local = insertIgnore;
                insertIgnore = null;
                if (local.getOffset() == context.getOffset() && local.getChar() == context.getText().charAt(0)) {
                    if (local.getMoveCaretTo() != -1) {
                        context.getComponent().setCaretPosition(local.moveCaretTo);
                        Completion.get().hideAll();
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

