/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.ExportDiffPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ExportDiffSupport {
    private AbstractExportDiffPanel panel;
    private DialogDescriptor dd;
    private Preferences preferences;
    private Dialog dialog;
    private ExportDiffProvider exportDiffProvider;
    private File[] files;

    public ExportDiffSupport(File[] files, Preferences preferences) {
        this.preferences = preferences;
        this.files = files;
    }

    protected void createComplexDialog(AbstractExportDiffPanel insidePanel) {
        this.dd = new DialogDescriptor((Object)insidePanel, NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
    }

    protected AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        this.dd = new DialogDescriptor((Object)this.createFileChooser(new File(currentFilePath)), NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        this.dd.setOptions(new Object[0]);
        this.panel = new ExportDiffPanel(new JPanel());
        this.panel.setOutputFileText("");
        return this.panel;
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dd;
    }

    private void initializePanels() {
        this.exportDiffProvider = (ExportDiffProvider)Lookup.getDefault().lookup(ExportDiffProvider.class);
        String currentFilePath = this.preferences.get("ExportDiff.saveFolder", System.getProperty("user.home"));
        if (this.exportDiffProvider == null) {
            this.panel = this.createSimpleDialog(currentFilePath);
            this.dd = this.getDialogDescriptor();
        } else {
            this.exportDiffProvider.setContext(this.files);
            ExportDiffPanel edPanel = new ExportDiffPanel(this.exportDiffProvider.createComponent());
            edPanel.setOutputFileText(currentFilePath);
            this.exportDiffProvider.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("ExportDiff.data.changed")) {
                        ExportDiffSupport.this.validate();
                    }
                }
            });
            edPanel.asFileRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDiffSupport.this.validate();
                }
            });
            edPanel.attachRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDiffSupport.this.validate();
                }
            });
            this.panel = edPanel;
            this.createComplexDialog(this.panel);
            this.dd = this.getDialogDescriptor();
        }
        this.panel.addOutputFileTextDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }
        });
        this.panel.addBrowseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDiffSupport.this.onChooseFile(new File(ExportDiffSupport.this.panel.getOutputFileText()));
            }
        });
    }

    private void validate() {
        assert (this.panel != null);
        if (this.exportDiffProvider == null || this.panel.isFileOutputSelected()) {
            String path = this.panel.getOutputFileText().trim();
            File f = new File(this.panel.getOutputFileText().trim());
            this.dd.setValid(!path.equals("") && !f.isDirectory());
        } else {
            this.dd.setValid(this.exportDiffProvider.isValid());
        }
    }

    public void export() {
        this.initializePanels();
        this.validate();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dd);
        this.dialog.setVisible(true);
        if (this.dd.getValue() == DialogDescriptor.OK_OPTION) {
            if (this.exportDiffProvider == null || ((ExportDiffPanel)this.panel).asFileRadioButton.isSelected()) {
                final File toFile = new File(this.panel.getOutputFileText());
                Utils.createTask(new Runnable(){

                    @Override
                    public void run() {
                        ExportDiffSupport.this.writeDiffFile(FileUtil.normalizeFile((File)toFile));
                    }
                }).schedule(0);
            } else {
                final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
                Cancellable c = new Cancellable(){

                    public boolean cancel() {
                        if (t[0] != null) {
                            return t[0].cancel();
                        }
                        return true;
                    }
                };
                final ProgressHandle handle = ProgressHandle.createHandle((String)this.getMessage("CTL_Attaching"), (Cancellable)c);
                handle.start();
                t[0] = Utils.createTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            File toFile;
                            try {
                                toFile = ExportDiffSupport.this.createTempFile();
                            }
                            catch (IOException ex) {
                                handle.finish();
                                return;
                            }
                            toFile.deleteOnExit();
                            ExportDiffSupport.this.writeDiffFile(toFile);
                            if (toFile.exists()) {
                                ExportDiffSupport.this.exportDiffProvider.handleDiffFile(toFile);
                            }
                        }
                        finally {
                            handle.finish();
                        }
                    }
                });
                t[0].schedule(0);
            }
        }
    }

    protected File createTempFile() throws IOException {
        return Files.createTempFile("vcs-diff", ".patch", new FileAttribute[0]).toFile();
    }

    protected String getMessage(String resourceName) {
        return NbBundle.getMessage(ExportDiffSupport.class, (String)resourceName);
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("diff") || f.getName().endsWith("patch") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3002");
            }
        };
    }

    protected File getTargetFile(File target) {
        String name = target.getName();
        boolean requiredExt = false;
        requiredExt |= name.endsWith(".diff");
        requiredExt |= name.endsWith(".dif");
        if (!(requiredExt |= name.endsWith(".patch"))) {
            File parent = target.getParentFile();
            target = new File(parent, name + ".patch");
        }
        return target;
    }

    public abstract void writeDiffFile(File var1);

    private void onChooseFile(File currentDir) {
        JFileChooser chooser = this.createFileChooser(currentDir);
        DialogDescriptor chooseFileDescriptor = new DialogDescriptor((Object)chooser, this.getMessage("CTL_Export_Title"));
        chooseFileDescriptor.setOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(chooseFileDescriptor);
        this.dialog.setVisible(true);
    }

    private JFileChooser createFileChooser(File curentDir) {
        final AccessibleJFileChooser chooser = new AccessibleJFileChooser(NbBundle.getMessage(ExportDiffSupport.class, (String)"ACSD_Export"));
        chooser.setDialogTitle(NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] old = chooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.setCurrentDirectory(curentDir);
        chooser.addChoosableFileFilter(this.getFileFilter());
        chooser.setDialogType(1);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffSupport.class, (String)"MNE_Export_ExportAction").charAt(0));
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    File destination = chooser.getSelectedFile();
                    if ((destination = ExportDiffSupport.this.getTargetFile(destination)).exists()) {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3005", (Object)destination.getAbsolutePath()));
                        nd.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (!nd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    ExportDiffSupport.this.preferences.put("ExportDiff.saveFolder", destination.getParent());
                    ExportDiffSupport.this.panel.setOutputFileText(destination.getAbsolutePath());
                } else {
                    ExportDiffSupport.this.dd.setValue(null);
                }
                if (ExportDiffSupport.this.dialog != null) {
                    ExportDiffSupport.this.dialog.dispose();
                }
            }
        });
        return chooser;
    }

    public static abstract class AbstractExportDiffPanel
    extends JPanel {
        public abstract String getOutputFileText();

        public abstract void setOutputFileText(String var1);

        public abstract void addOutputFileTextDocumentListener(DocumentListener var1);

        public abstract void addBrowseActionListener(ActionListener var1);

        public boolean isFileOutputSelected() {
            return true;
        }
    }

    public static abstract class ExportDiffProvider {
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private static final String EVENT_DATA_CHANGED = "ExportDiff.data.changed";

        protected abstract void setContext(File[] var1);

        public abstract void handleDiffFile(File var1);

        public abstract JComponent createComponent();

        public abstract boolean isValid();

        protected void fireDataChanged() {
            this.support.firePropertyChange(EVENT_DATA_CHANGED, null, null);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }
    }
}

