/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.tasklist.impl.TaskIndexer;
import org.netbeans.modules.tasklist.impl.TaskManagerImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class TaskIndexerFactory
extends CustomIndexerFactory {
    static final String INDEXER_NAME = "TaskListIndexer";
    static final int INDEXER_VERSION = 2;

    public String getIndexerName() {
        return INDEXER_NAME;
    }

    public int getIndexVersion() {
        return 2;
    }

    public CustomIndexer createIndexer() {
        return new TaskIndexer(TaskManagerImpl.getInstance().getTasks());
    }

    public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        try {
            IndexingSupport is = IndexingSupport.getInstance((Context)context);
            for (Indexable indexable : deleted) {
                is.removeDocuments(indexable);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        TaskManagerImpl tm = TaskManagerImpl.getInstance();
        tm.getTasks().clearDeletedFiles();
    }

    public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        TaskManagerImpl manager = TaskManagerImpl.getInstance();
        boolean refresh = false;
        for (URL uRL : removedRoots) {
            FileObject root = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(uRL.getFile())));
            if (!manager.getScope().isInScope(root)) continue;
            refresh = true;
            break;
        }
        if (refresh) {
            manager.refresh(manager.getScope());
        }
    }

    public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        try {
            IndexingSupport is = IndexingSupport.getInstance((Context)context);
            for (Indexable indexable : dirty) {
                is.markDirtyDocuments(indexable);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean supportsEmbeddedIndexers() {
        return true;
    }

    public boolean scanStarted(Context context) {
        try {
            return IndexingSupport.getInstance((Context)context).isValid();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }
}

