/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;

public class SwingLayoutUtils {
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_NON_RESIZABLE = 0;
    public static final int STATUS_RESIZABLE = 1;
    private static Set<String> nonResizableComponents = new HashSet<String>();
    private static Set<String> resizableComponents;

    public static int getResizableStatus(Component component) {
        int status = SwingLayoutUtils.getSpecialStatus(component);
        if (status == -1) {
            String className = component.getClass().getName();
            if (resizableComponents.contains(className)) {
                status = 1;
            } else if (nonResizableComponents.contains(className)) {
                status = 0;
            }
        }
        return status;
    }

    private static int getSpecialStatus(Component component) {
        String htmlText = null;
        if (component instanceof JLabel) {
            htmlText = ((JLabel)component).getText();
        } else if (component instanceof AbstractButton) {
            htmlText = ((AbstractButton)component).getText();
        }
        if (htmlText != null && htmlText.length() >= 6 && htmlText.trim().toLowerCase().startsWith("<html>")) {
            return 1;
        }
        return -1;
    }

    public static Map<Integer, List<String>> createLinkSizeGroups(LayoutComponent layoutComponent, int dimension) {
        TreeMap<Integer, List<String>> linkSizeGroup = new TreeMap<Integer, List<String>>();
        if (layoutComponent.isLayoutContainer()) {
            for (LayoutComponent lc : layoutComponent.getSubcomponents()) {
                if (lc == null || !lc.isLinkSized(dimension)) continue;
                String cid = lc.getId();
                Integer id = lc.getLinkSizeId(dimension);
                ArrayList<String> l = (ArrayList<String>)linkSizeGroup.get(id);
                if (l == null) {
                    l = new ArrayList<String>();
                    l.add(cid);
                    linkSizeGroup.put(id, l);
                    continue;
                }
                l.add(cid);
            }
        }
        return linkSizeGroup;
    }

    public static LayoutInterval getUnsupportedResizingContainerGap(LayoutInterval seq) {
        int count = seq.getSubIntervalCount();
        if (!seq.isSequential() || count <= 1 || seq.getParent() == null) {
            return null;
        }
        LayoutInterval gap = seq.getSubInterval(count - 1);
        if (gap.getPreferredSize() != -1 || gap.getMaximumSize() != Short.MAX_VALUE || LayoutInterval.getNeighbor(seq, 1, false, true, false) != null) {
            return null;
        }
        LayoutInterval otherGap = seq.getSubInterval(0);
        if (otherGap.isEmptySpace() && LayoutInterval.wantResize(otherGap)) {
            return null;
        }
        boolean parallelSibling = false;
        Iterator<LayoutInterval> it = seq.getParent().getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sub = it.next();
            if (sub == seq || !LayoutInterval.isAlignedAtBorder(sub, 1) || sub.isSequential() && (sub.getSubIntervalCount() <= 0 || sub.getSubInterval(sub.getSubIntervalCount() - 1).isEmptySpace())) continue;
            parallelSibling = true;
            break;
        }
        if (!parallelSibling) {
            return null;
        }
        LayoutInterval neighbor = LayoutInterval.getNeighbor(seq.getParent(), 0, false, true, false);
        if (neighbor == null || neighbor.isEmptySpace() && !LayoutInterval.canResize(neighbor) && neighbor.getPreferredSize() == -1 && LayoutInterval.getNeighbor(neighbor, 0, false, true, false) == null) {
            return null;
        }
        return gap;
    }

    static {
        nonResizableComponents.addAll(Arrays.asList("javax.swing.JLabel", "javax.swing.JButton", "javax.swing.JToggleButton", "javax.swing.JCheckBox", "javax.swing.JRadioButton", "javax.swing.JList"));
        resizableComponents = new HashSet<String>();
        resizableComponents.addAll(Arrays.asList("javax.swing.JComboBox", "javax.swing.JTextField", "javax.swing.JTextArea", "javax.swing.JTabbedPane", "javax.swing.JScrollPane", "javax.swing.JSplitPane", "javax.swing.JFormattedTextField", "javax.swing.JPasswordField", "javax.swing.JSpinner", "javax.swing.JSeparator", "javax.swing.JTextPane", "javax.swing.JEditorPane", "javax.swing.JInternalFrame", "javax.swing.JLayeredPane", "javax.swing.JDesktopPane"));
    }
}

