/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpinnerModelEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor,
FormAwareEditor {
    private boolean initialized;
    private boolean fireChanges;
    private FormProperty property;
    private JComboBox calendarFieldCombo;
    private JLabel calendarFieldLabel;
    private JPanel customizerPanel;
    private JPanel datePanel;
    private JPanel defaultPanel;
    private JLabel initialDateLabel;
    private JSpinner initialDateSpinner;
    private JComboBox initialListCombo;
    private JLabel initialListLabel;
    private JCheckBox initialNowCheckBox;
    private JLabel initialNumberLabel;
    private JSpinner initialNumberSpinner;
    private JTextArea listItemsArea;
    private JLabel listItemsLabel;
    private JPanel listPanel;
    private JCheckBox maximumDateCheckBox;
    private JSpinner maximumDateSpinner;
    private JCheckBox maximumNowCheckBox;
    private JCheckBox maximumNumberCheckBox;
    private JSpinner maximumNumberSpinner;
    private JCheckBox minimumDateCheckBox;
    private JSpinner minimumDateSpinner;
    private JCheckBox minimumNowCheckBox;
    private JCheckBox minimumNumberCheckBox;
    private JSpinner minimumNumberSpinner;
    private JLabel modelPropertiesLabel;
    private JComboBox modelTypeCombo;
    private JLabel modelTypeLabel;
    private JPanel modelTypePanel;
    private JPanel numberPanel;
    private JComboBox numberTypeCombo;
    private JLabel numberTypeLabel;
    private JScrollPane scrollPane;
    private JSeparator separator;
    private JLabel stepSizeLabel;
    private JSpinner stepSizeSpinner;
    private static final String XML_SPINNER_MODEL = "SpinnerModel";
    private static final String XML_LIST_ITEM = "ListItem";
    private static final String ATTR_INITIAL = "initial";
    private static final String ATTR_MINIMUM = "minimum";
    private static final String ATTR_MAXIMUM = "maximum";
    private static final String ATTR_STEP_SIZE = "stepSize";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_NUMBER_TYPE = "numberType";
    private static final String ATTR_VALUE = "value";
    private static final String VALUE_TYPE_DEFAULT = "default";
    private static final String VALUE_TYPE_NUMBER = "number";
    private static final String VALUE_TYPE_DATE = "date";
    private static final String VALUE_TYPE_LIST = "list";
    private static final String VALUE_NOW = "now";

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        Object value;
        this.fireChanges = false;
        if (!this.initialized) {
            this.initGUI();
        }
        if ((value = this.getValue()) instanceof FormSpinnerModel) {
            this.updateUI((FormSpinnerModel)value);
        } else {
            this.modelTypeCombo.setSelectedIndex(0);
        }
        this.fireChanges = true;
        return this.customizerPanel;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        String msg = NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_SpinnerModel");
        FontMetrics fm = g.getFontMetrics();
        g.drawString(msg, rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    private void initGUI() {
        this.fireChanges = false;
        this.initComponents();
        this.initModelTypeCombo();
        this.initCalendarFieldCombo();
        this.initNumberTypeCombo();
        this.initListItems();
        this.initialDateSpinner.setModel(new SpinnerDateModel());
        this.initialDateSpinner.setValue(new Date());
        this.minimumDateSpinner.setModel(new SpinnerDateModel());
        this.maximumDateSpinner.setModel(new SpinnerDateModel());
        this.stepSizeSpinner.setValue(1);
        this.initialListLabel.setVisible(false);
        this.initialListCombo.setVisible(false);
        this.fireChanges = true;
        this.initialized = true;
    }

    private void initListItems() {
        String format = NbBundle.getMessage(this.getClass(), (String)"SpinnerModelEditor_Item");
        String[] items = new String[4];
        for (int i = 0; i < items.length; ++i) {
            items[i] = MessageFormat.format(format, i);
        }
        StringBuilder sb = new StringBuilder();
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
        for (String item : items) {
            sb.append((Object)item).append('\n');
            comboModel.addElement(item);
        }
        this.listItemsArea.setText(sb.toString());
        this.initialListCombo.setModel(comboModel);
        this.initialListCombo.setSelectedIndex(0);
    }

    private void initModelTypeCombo() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ResourceBundle bundle = NbBundle.getBundle(this.getClass());
        model.addElement(bundle.getString("SpinnerModelEditor_Default"));
        model.addElement(bundle.getString("SpinnerModelEditor_Date"));
        model.addElement(bundle.getString("SpinnerModelEditor_List"));
        model.addElement(bundle.getString("SpinnerModelEditor_Number"));
        this.modelTypeCombo.setModel(model);
    }

    private void initCalendarFieldCombo() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ResourceBundle bundle = NbBundle.getBundle(this.getClass());
        model.addElement(bundle.getString("SpinnerModelEditor_Era"));
        model.addElement(bundle.getString("SpinnerModelEditor_Year"));
        model.addElement(bundle.getString("SpinnerModelEditor_Month"));
        model.addElement(bundle.getString("SpinnerModelEditor_WeekOfYear"));
        model.addElement(bundle.getString("SpinnerModelEditor_WeekOfMonth"));
        model.addElement(bundle.getString("SpinnerModelEditor_DayOfMonth"));
        model.addElement(bundle.getString("SpinnerModelEditor_DayOfYear"));
        model.addElement(bundle.getString("SpinnerModelEditor_DayOfWeek"));
        model.addElement(bundle.getString("SpinnerModelEditor_DayOfWeekInMonth"));
        model.addElement(bundle.getString("SpinnerModelEditor_AMPM"));
        model.addElement(bundle.getString("SpinnerModelEditor_Hour"));
        model.addElement(bundle.getString("SpinnerModelEditor_HourOfDay"));
        model.addElement(bundle.getString("SpinnerModelEditor_Minute"));
        model.addElement(bundle.getString("SpinnerModelEditor_Second"));
        model.addElement(bundle.getString("SpinnerModelEditor_Millisecond"));
        this.calendarFieldCombo.setModel(model);
        this.calendarFieldCombo.setSelectedIndex(5);
    }

    private void initNumberTypeCombo() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        ResourceBundle bundle = NbBundle.getBundle(this.getClass());
        model.addElement(bundle.getString("SpinnerModelEditor_Byte"));
        model.addElement(bundle.getString("SpinnerModelEditor_Double"));
        model.addElement(bundle.getString("SpinnerModelEditor_Float"));
        model.addElement(bundle.getString("SpinnerModelEditor_Integer"));
        model.addElement(bundle.getString("SpinnerModelEditor_Long"));
        model.addElement(bundle.getString("SpinnerModelEditor_Short"));
        this.numberTypeCombo.setModel(model);
        this.numberTypeCombo.setSelectedIndex(3);
    }

    private void updateUI(FormSpinnerModel model) {
        SpinnerModel spinnerModel = model.getModel();
        if (spinnerModel instanceof SpinnerDateModel) {
            this.modelTypeCombo.setSelectedIndex(1);
            this.updateDateUI(model);
        } else if (spinnerModel instanceof SpinnerListModel) {
            this.modelTypeCombo.setSelectedIndex(2);
            this.updateListUI(model);
        } else if (spinnerModel instanceof SpinnerNumberModel) {
            this.modelTypeCombo.setSelectedIndex(3);
            this.updateNumberUI(model);
        } else assert (false);
        this.updateVisibilityOfModelProperties();
    }

    private void updateDateUI(FormSpinnerModel model) {
        Date now = new Date();
        SpinnerDateModel dateModel = (SpinnerDateModel)model.getModel();
        this.initialNowCheckBox.setSelected(model.isInitialNow());
        this.initialDateSpinner.setValue(model.isInitialNow() ? now : model.getInitialValue());
        this.initialDateSpinner.setEnabled(!model.isInitialNow());
        Comparable<Date> minimum = dateModel.getStart();
        this.minimumDateCheckBox.setSelected(minimum != null);
        this.minimumNowCheckBox.setEnabled(minimum != null);
        this.minimumNowCheckBox.setSelected(model.isMinimumNow());
        this.minimumDateSpinner.setEnabled(minimum != null && !model.isMinimumNow());
        minimum = model.isMinimumNow() ? now : minimum;
        this.minimumDateSpinner.setValue(minimum == null ? now : minimum);
        Comparable<Date> maximum = dateModel.getEnd();
        this.maximumDateCheckBox.setSelected(maximum != null);
        this.maximumNowCheckBox.setEnabled(maximum != null);
        this.maximumNowCheckBox.setSelected(model.isMaximumNow());
        this.maximumDateSpinner.setEnabled(maximum != null && !model.isMaximumNow());
        maximum = model.isMaximumNow() ? now : maximum;
        this.maximumDateSpinner.setValue(maximum == null ? now : maximum);
        int index = 0;
        switch (dateModel.getCalendarField()) {
            case 0: {
                index = 0;
                break;
            }
            case 1: {
                index = 1;
                break;
            }
            case 2: {
                index = 2;
                break;
            }
            case 3: {
                index = 3;
                break;
            }
            case 4: {
                index = 4;
                break;
            }
            case 5: {
                index = 5;
                break;
            }
            case 6: {
                index = 6;
                break;
            }
            case 7: {
                index = 7;
                break;
            }
            case 8: {
                index = 8;
                break;
            }
            case 9: {
                index = 9;
                break;
            }
            case 10: {
                index = 10;
                break;
            }
            case 11: {
                index = 11;
                break;
            }
            case 12: {
                index = 12;
                break;
            }
            case 13: {
                index = 13;
                break;
            }
            case 14: {
                index = 14;
            }
        }
        this.calendarFieldCombo.setSelectedIndex(index);
    }

    private void updateListUI(FormSpinnerModel model) {
        SpinnerListModel listModel = (SpinnerListModel)model.getModel();
        List<?> items = listModel.getList();
        StringBuilder sb = new StringBuilder();
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        for (Object item : items) {
            sb.append(item).append('\n');
            comboModel.addElement(item);
        }
        this.listItemsArea.setText(sb.toString());
        this.initialListCombo.setModel(comboModel);
        this.initialListCombo.setSelectedItem(model.getInitialValue());
    }

    private void updateNumberUI(FormSpinnerModel model) {
        Comparable<?> maximum;
        SpinnerNumberModel numberModel = (SpinnerNumberModel)model.getModel();
        Class<?> clazz = model.getInitialValue().getClass();
        int typeIndex = 0;
        if (clazz == Byte.class) {
            typeIndex = 0;
        } else if (clazz == Double.class) {
            typeIndex = 1;
        } else if (clazz == Float.class) {
            typeIndex = 2;
        } else if (clazz == Integer.class) {
            typeIndex = 3;
        } else if (clazz == Long.class) {
            typeIndex = 4;
        } else if (clazz == Short.class) {
            typeIndex = 5;
        } else assert (false);
        this.numberTypeCombo.setSelectedIndex(typeIndex);
        this.minimumNumberSpinner.setValue(0);
        this.maximumNumberSpinner.setValue(0);
        this.updateNumberEditors();
        this.initialNumberSpinner.setValue(model.getInitialValue());
        Comparable<?> minimum = numberModel.getMinimum();
        this.minimumNumberCheckBox.setSelected(minimum != null);
        this.minimumNumberSpinner.setEnabled(minimum != null);
        if (minimum != null) {
            this.minimumNumberSpinner.setValue(minimum);
        }
        this.maximumNumberCheckBox.setSelected((maximum = numberModel.getMaximum()) != null);
        this.maximumNumberSpinner.setEnabled(maximum != null);
        if (maximum != null) {
            this.maximumNumberSpinner.setValue(maximum);
        }
        this.stepSizeSpinner.setValue(numberModel.getStepSize());
    }

    private void updateFromUI() {
        if (!this.fireChanges) {
            return;
        }
        Object value = this.valueFromUI();
        if (value == null) {
            value = this.property.getDefaultValue();
        }
        this.setValue(value);
    }

    private FormSpinnerModel valueFromUI() {
        FormSpinnerModel value = null;
        int modelType = this.modelTypeCombo.getSelectedIndex();
        if (modelType == 0) {
            value = null;
        } else if (modelType == 1) {
            value = this.dateFromUI();
        } else if (modelType == 2) {
            value = this.listFromUI();
        } else if (modelType == 3) {
            value = this.numberFromUI();
        } else assert (false);
        return value;
    }

    private FormSpinnerModel dateFromUI() {
        Date initial;
        Date now = new Date();
        boolean minimumNow = false;
        Date minimum = null;
        if (this.minimumDateCheckBox.isSelected()) {
            if (this.minimumNowCheckBox.isSelected()) {
                minimumNow = true;
                minimum = now;
            } else {
                minimum = (Date)this.minimumDateSpinner.getValue();
            }
        }
        boolean initialNow = false;
        if (this.initialNowCheckBox.isSelected()) {
            initialNow = true;
            initial = now;
        } else {
            initial = (Date)this.initialDateSpinner.getValue();
            if (minimumNow && initial.getTime() - minimum.getTime() < 0L) {
                initial = minimum;
            }
        }
        boolean maximumNow = false;
        Date maximum = null;
        if (this.maximumDateCheckBox.isSelected()) {
            if (this.maximumNowCheckBox.isSelected()) {
                maximumNow = true;
                maximum = now;
            } else {
                maximum = (Date)this.maximumDateSpinner.getValue();
                if (initialNow && maximum.getTime() - initial.getTime() < 0L) {
                    maximum = initial;
                }
                if (minimumNow && maximum.getTime() - minimum.getTime() < 0L) {
                    maximum = minimum;
                }
            }
        }
        int field = 0;
        switch (this.calendarFieldCombo.getSelectedIndex()) {
            case 0: {
                field = 0;
                break;
            }
            case 1: {
                field = 1;
                break;
            }
            case 2: {
                field = 2;
                break;
            }
            case 3: {
                field = 3;
                break;
            }
            case 4: {
                field = 4;
                break;
            }
            case 5: {
                field = 5;
                break;
            }
            case 6: {
                field = 6;
                break;
            }
            case 7: {
                field = 7;
                break;
            }
            case 8: {
                field = 8;
                break;
            }
            case 9: {
                field = 9;
                break;
            }
            case 10: {
                field = 10;
                break;
            }
            case 11: {
                field = 11;
                break;
            }
            case 12: {
                field = 12;
                break;
            }
            case 13: {
                field = 13;
                break;
            }
            case 14: {
                field = 14;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        SpinnerDateModel model = new SpinnerDateModel(initial, minimum, maximum, field);
        return new FormSpinnerModel(model, initial, initialNow, minimumNow, maximumNow);
    }

    private FormSpinnerModel listFromUI() {
        String initial = (String)this.initialListCombo.getSelectedItem();
        List<String> listItems = this.listItemsFromUI();
        SpinnerListModel model = new SpinnerListModel(listItems);
        return new FormSpinnerModel(model, (Object)initial);
    }

    private List<String> listItemsFromUI() {
        String itemsText = this.listItemsArea.getText();
        StringTokenizer st = new StringTokenizer(itemsText, "\n");
        LinkedList<String> items = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            items.add(st.nextToken());
        }
        if (items.isEmpty()) {
            items.add("");
        }
        return items;
    }

    private Class selectedNumberType() {
        Class clazz = null;
        switch (this.numberTypeCombo.getSelectedIndex()) {
            case 0: {
                clazz = Byte.class;
                break;
            }
            case 1: {
                clazz = Double.class;
                break;
            }
            case 2: {
                clazz = Float.class;
                break;
            }
            case 3: {
                clazz = Integer.class;
                break;
            }
            case 4: {
                clazz = Long.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return clazz;
    }

    private FormSpinnerModel numberFromUI() {
        Number initial = (Number)this.initialNumberSpinner.getValue();
        Number minimum = null;
        if (this.minimumNumberCheckBox.isSelected()) {
            minimum = (Number)this.minimumNumberSpinner.getValue();
        }
        Number maximum = null;
        if (this.maximumNumberCheckBox.isSelected()) {
            maximum = (Number)this.maximumNumberSpinner.getValue();
        }
        Number stepSize = (Number)this.stepSizeSpinner.getValue();
        Number[] n = SpinnerModelEditor.cast(this.selectedNumberType(), initial, minimum, maximum, stepSize);
        SpinnerNumberModel model = new SpinnerNumberModel(n[0], (Comparable)((Object)n[1]), (Comparable)((Object)n[2]), n[3]);
        return new FormSpinnerModel(model, (Object)n[0]);
    }

    private static Number[] cast(Class clazz, Number ... number) {
        Number[] result = new Number[number.length];
        for (int i = 0; i < number.length; ++i) {
            Number n = number[i];
            if (n == null) {
                result[i] = null;
                continue;
            }
            if (Integer.class == clazz) {
                result[i] = n.intValue();
                continue;
            }
            if (Long.class == clazz) {
                result[i] = n.longValue();
                continue;
            }
            if (Float.class == clazz) {
                result[i] = Float.valueOf(n.floatValue());
                continue;
            }
            if (Double.class == clazz) {
                result[i] = n.doubleValue();
                continue;
            }
            if (Byte.class == clazz) {
                result[i] = n.byteValue();
                continue;
            }
            if (Short.class == clazz) {
                result[i] = n.shortValue();
                continue;
            }
            assert (false);
        }
        return result;
    }

    private void initComponents() {
        this.customizerPanel = new JPanel();
        this.modelTypeLabel = new JLabel();
        this.modelTypeCombo = new JComboBox();
        this.modelPropertiesLabel = new JLabel();
        this.separator = new JSeparator();
        this.modelTypePanel = new JPanel();
        this.datePanel = new JPanel();
        this.initialDateLabel = new JLabel();
        this.initialDateSpinner = new JSpinner();
        this.initialNowCheckBox = new JCheckBox();
        this.minimumDateCheckBox = new JCheckBox();
        this.minimumDateSpinner = new JSpinner();
        this.minimumNowCheckBox = new JCheckBox();
        this.maximumDateCheckBox = new JCheckBox();
        this.maximumDateSpinner = new JSpinner();
        this.maximumNowCheckBox = new JCheckBox();
        this.calendarFieldLabel = new JLabel();
        this.calendarFieldCombo = new JComboBox();
        this.listPanel = new JPanel();
        this.listItemsLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.listItemsArea = new JTextArea();
        this.initialListLabel = new JLabel();
        this.initialListCombo = new JComboBox();
        this.numberPanel = new JPanel();
        this.numberTypeLabel = new JLabel();
        this.numberTypeCombo = new JComboBox();
        this.initialNumberLabel = new JLabel();
        this.initialNumberSpinner = new JSpinner();
        this.minimumNumberCheckBox = new JCheckBox();
        this.minimumNumberSpinner = new JSpinner();
        this.maximumNumberCheckBox = new JCheckBox();
        this.maximumNumberSpinner = new JSpinner();
        this.stepSizeLabel = new JLabel();
        this.stepSizeSpinner = new JSpinner();
        this.defaultPanel = new JPanel();
        FormListener formListener = new FormListener();
        this.modelTypeLabel.setLabelFor(this.modelTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.modelTypeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelType"));
        this.modelTypeCombo.addActionListener(formListener);
        this.modelPropertiesLabel.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelProperties"));
        this.modelTypePanel.setLayout(new CardLayout());
        this.initialDateLabel.setLabelFor(this.initialDateSpinner);
        Mnemonics.setLocalizedText((JLabel)this.initialDateLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialDate"));
        this.initialDateSpinner.setEnabled(false);
        this.initialDateSpinner.addChangeListener(formListener);
        this.initialNowCheckBox.setSelected(true);
        this.initialNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNow"));
        this.initialNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initialNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.initialNowCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.minimumDateCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate"));
        this.minimumDateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumDateCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumDateCheckBox.addActionListener(formListener);
        this.minimumDateSpinner.setEnabled(false);
        this.minimumDateSpinner.addChangeListener(formListener);
        this.minimumNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNow"));
        this.minimumNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumNowCheckBox.setEnabled(false);
        this.minimumNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumNowCheckBox.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.maximumDateCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate"));
        this.maximumDateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumDateCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumDateCheckBox.addActionListener(formListener);
        this.maximumDateSpinner.setEnabled(false);
        this.maximumDateSpinner.addChangeListener(formListener);
        this.maximumNowCheckBox.setText(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNow"));
        this.maximumNowCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumNowCheckBox.setEnabled(false);
        this.maximumNowCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumNowCheckBox.addActionListener(formListener);
        this.calendarFieldLabel.setLabelFor(this.calendarFieldCombo);
        Mnemonics.setLocalizedText((JLabel)this.calendarFieldLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_CalendarField"));
        this.calendarFieldCombo.addActionListener(formListener);
        GroupLayout datePanelLayout = new GroupLayout(this.datePanel);
        this.datePanel.setLayout(datePanelLayout);
        datePanelLayout.setHorizontalGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createSequentialGroup().addContainerGap().addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.initialDateLabel).addComponent(this.minimumDateCheckBox).addComponent(this.maximumDateCheckBox).addComponent(this.calendarFieldLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.initialDateSpinner, GroupLayout.Alignment.TRAILING).addComponent(this.minimumDateSpinner, GroupLayout.Alignment.TRAILING).addComponent(this.maximumDateSpinner, GroupLayout.Alignment.TRAILING).addComponent(this.calendarFieldCombo, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE)).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maximumNowCheckBox)).addGroup(GroupLayout.Alignment.TRAILING, datePanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minimumNowCheckBox))).addGroup(GroupLayout.Alignment.TRAILING, datePanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initialNowCheckBox))).addContainerGap(14, Short.MAX_VALUE)));
        datePanelLayout.setVerticalGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(datePanelLayout.createSequentialGroup().addContainerGap().addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDateLabel).addComponent(this.initialNowCheckBox).addComponent(this.initialDateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minimumDateCheckBox).addComponent(this.minimumNowCheckBox).addComponent(this.minimumDateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maximumDateCheckBox).addComponent(this.maximumNowCheckBox).addComponent(this.maximumDateSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(datePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.calendarFieldLabel).addComponent(this.calendarFieldCombo, -2, -1, -2)).addContainerGap(45, Short.MAX_VALUE)));
        this.initialDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialDate_ACSD"));
        this.initialNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNow_ACSD"));
        this.minimumDateCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSD"));
        this.minimumDateSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSN"));
        this.minimumDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumDate_ACSD"));
        this.minimumNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNow_ACSD"));
        this.maximumDateCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSD"));
        this.maximumDateSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSN"));
        this.maximumDateSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumDate_ACSD"));
        this.maximumNowCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNow_ACSD"));
        this.calendarFieldCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize_ACSD"));
        this.modelTypePanel.add((Component)this.datePanel, VALUE_TYPE_DATE);
        this.listItemsLabel.setLabelFor(this.listItemsArea);
        Mnemonics.setLocalizedText((JLabel)this.listItemsLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ListItems"));
        this.listItemsArea.setRows(4);
        this.listItemsArea.addFocusListener(formListener);
        this.scrollPane.setViewportView(this.listItemsArea);
        this.listItemsArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ListItems"));
        this.initialListLabel.setLabelFor(this.initialListCombo);
        Mnemonics.setLocalizedText((JLabel)this.initialListLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialList"));
        this.initialListCombo.addActionListener(formListener);
        GroupLayout listPanelLayout = new GroupLayout(this.listPanel);
        this.listPanel.setLayout(listPanelLayout);
        listPanelLayout.setHorizontalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listPanelLayout.createSequentialGroup().addContainerGap().addGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 147, Short.MAX_VALUE).addComponent(this.listItemsLabel).addGroup(listPanelLayout.createSequentialGroup().addComponent(this.initialListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initialListCombo, 0, 84, Short.MAX_VALUE))).addContainerGap()));
        listPanelLayout.setVerticalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.listItemsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialListLabel).addComponent(this.initialListCombo, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.initialListCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialList_ACSD"));
        this.modelTypePanel.add((Component)this.listPanel, VALUE_TYPE_LIST);
        this.numberTypeLabel.setLabelFor(this.numberTypeCombo);
        Mnemonics.setLocalizedText((JLabel)this.numberTypeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_NumberType"));
        this.numberTypeCombo.addActionListener(formListener);
        this.initialNumberLabel.setLabelFor(this.initialNumberSpinner);
        Mnemonics.setLocalizedText((JLabel)this.initialNumberLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNumber"));
        this.initialNumberSpinner.addChangeListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.minimumNumberCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber"));
        this.minimumNumberCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.minimumNumberCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.minimumNumberCheckBox.addActionListener(formListener);
        this.minimumNumberSpinner.setEnabled(false);
        this.minimumNumberSpinner.addChangeListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.maximumNumberCheckBox, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber"));
        this.maximumNumberCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.maximumNumberCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.maximumNumberCheckBox.addActionListener(formListener);
        this.maximumNumberSpinner.setEnabled(false);
        this.maximumNumberSpinner.addChangeListener(formListener);
        this.stepSizeLabel.setLabelFor(this.stepSizeSpinner);
        Mnemonics.setLocalizedText((JLabel)this.stepSizeLabel, (String)NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize"));
        this.stepSizeSpinner.addChangeListener(formListener);
        GroupLayout numberPanelLayout = new GroupLayout(this.numberPanel);
        this.numberPanel.setLayout(numberPanelLayout);
        numberPanelLayout.setHorizontalGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(numberPanelLayout.createSequentialGroup().addContainerGap().addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numberTypeLabel).addComponent(this.initialNumberLabel).addComponent(this.minimumNumberCheckBox).addComponent(this.maximumNumberCheckBox).addComponent(this.stepSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.numberTypeCombo, 0, -1, Short.MAX_VALUE).addComponent(this.initialNumberSpinner).addComponent(this.minimumNumberSpinner).addComponent(this.maximumNumberSpinner).addComponent(this.stepSizeSpinner)).addContainerGap(56, Short.MAX_VALUE)));
        numberPanelLayout.setVerticalGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(numberPanelLayout.createSequentialGroup().addContainerGap().addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberTypeLabel).addComponent(this.numberTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialNumberLabel).addComponent(this.initialNumberSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.minimumNumberCheckBox).addComponent(this.minimumNumberSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maximumNumberCheckBox).addComponent(this.maximumNumberSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(numberPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stepSizeLabel).addComponent(this.stepSizeSpinner, -2, -1, -2)).addContainerGap(21, Short.MAX_VALUE)));
        this.numberTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_NumberType_ACSD"));
        this.initialNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_InitialNumber_ACSD"));
        this.minimumNumberCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSD"));
        this.minimumNumberSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSN"));
        this.minimumNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MinimumNumber_ACSD"));
        this.maximumNumberCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSD"));
        this.maximumNumberSpinner.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSN"));
        this.maximumNumberSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_MaximumNumber_ACSD"));
        this.stepSizeSpinner.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_StepSize_ACSD"));
        this.modelTypePanel.add((Component)this.numberPanel, VALUE_TYPE_NUMBER);
        GroupLayout defaultPanelLayout = new GroupLayout(this.defaultPanel);
        this.defaultPanel.setLayout(defaultPanelLayout);
        defaultPanelLayout.setHorizontalGroup(defaultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 167, Short.MAX_VALUE));
        defaultPanelLayout.setVerticalGroup(defaultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 150, Short.MAX_VALUE));
        this.modelTypePanel.add((Component)this.defaultPanel, VALUE_TYPE_DEFAULT);
        GroupLayout customizerPanelLayout = new GroupLayout(this.customizerPanel);
        this.customizerPanel.setLayout(customizerPanelLayout);
        customizerPanelLayout.setHorizontalGroup(customizerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, customizerPanelLayout.createSequentialGroup().addContainerGap().addGroup(customizerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.modelTypePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, customizerPanelLayout.createSequentialGroup().addComponent(this.modelTypeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelTypeCombo, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, customizerPanelLayout.createSequentialGroup().addComponent(this.modelPropertiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -1, 83, Short.MAX_VALUE))).addContainerGap()));
        customizerPanelLayout.setVerticalGroup(customizerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customizerPanelLayout.createSequentialGroup().addContainerGap().addGroup(customizerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelTypeLabel).addComponent(this.modelTypeCombo, -2, -1, -2)).addGap(11, 11, 11).addGroup(customizerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.modelPropertiesLabel).addComponent(this.separator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelTypePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.modelTypeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SpinnerModelEditor.class, (String)"SpinnerModelEditor_ModelType_ACSD"));
    }

    private void listItemsAreaFocusLost(FocusEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        int selectedIndex = this.initialListCombo.getSelectedIndex();
        Object selected = this.initialListCombo.getSelectedItem();
        DefaultComboBoxModel<String> comboModel = new DefaultComboBoxModel<String>();
        for (String item : this.listItemsFromUI()) {
            comboModel.addElement(item);
        }
        this.initialListCombo.setModel(comboModel);
        if (selected != null) {
            this.initialListCombo.setSelectedItem(selected);
            if (!selected.equals(this.initialListCombo.getSelectedItem()) && this.initialListCombo.getModel().getSize() > selectedIndex) {
                this.initialListCombo.setSelectedIndex(selectedIndex);
            }
        }
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void initialListComboActionPerformed(ActionEvent evt) {
        this.updateFromUI();
    }

    private void maximumNumberCheckBoxActionPerformed(ActionEvent evt) {
        Comparable initial;
        Comparable maximum;
        if (!this.fireChanges) {
            return;
        }
        this.maximumNumberSpinner.setEnabled(this.maximumNumberCheckBox.isSelected());
        if (this.maximumNumberCheckBox.isSelected() && (maximum = (Comparable)this.maximumNumberSpinner.getValue()).compareTo(initial = (Comparable)this.initialNumberSpinner.getValue()) < 0) {
            this.fireChanges = false;
            this.maximumNumberSpinner.setValue(initial);
            this.fireChanges = true;
        }
        this.updateFromUI();
    }

    private void minimumNumberCheckBoxActionPerformed(ActionEvent evt) {
        Comparable initial;
        Comparable minimum;
        if (!this.fireChanges) {
            return;
        }
        this.minimumNumberSpinner.setEnabled(this.minimumNumberCheckBox.isSelected());
        if (this.minimumNumberCheckBox.isSelected() && (minimum = (Comparable)this.minimumNumberSpinner.getValue()).compareTo(initial = (Comparable)this.initialNumberSpinner.getValue()) > 0) {
            this.fireChanges = false;
            this.minimumNumberSpinner.setValue(initial);
            this.fireChanges = true;
        }
        this.updateFromUI();
    }

    private void maximumNumberSpinnerStateChanged(ChangeEvent evt) {
        this.maximumNumberUpdated();
        this.updateFromUI();
    }

    private void minimumNumberSpinnerStateChanged(ChangeEvent evt) {
        this.minimumNumberUpdated();
        this.updateFromUI();
    }

    private void initialNumberSpinnerStateChanged(ChangeEvent evt) {
        Comparable maximum;
        Comparable minimum;
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        Comparable initial = (Comparable)this.initialNumberSpinner.getValue();
        if (this.minimumNumberCheckBox.isSelected() && initial.compareTo(minimum = (Comparable)this.minimumNumberSpinner.getValue()) < 0) {
            this.minimumNumberSpinner.setValue(initial);
        }
        if (this.maximumNumberCheckBox.isSelected() && initial.compareTo(maximum = (Comparable)this.maximumNumberSpinner.getValue()) > 0) {
            this.maximumNumberSpinner.setValue(initial);
        }
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void stepSizeSpinnerStateChanged(ChangeEvent evt) {
        this.updateFromUI();
    }

    private void numberTypeComboActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        this.updateNumberEditors();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void updateNumberEditors() {
        Number[] n = SpinnerModelEditor.cast(this.selectedNumberType(), (Number)this.initialNumberSpinner.getValue(), (Number)this.minimumNumberSpinner.getValue(), (Number)this.maximumNumberSpinner.getValue(), (Number)this.stepSizeSpinner.getValue());
        this.initialNumberSpinner.setValue(n[0]);
        this.initialNumberSpinner.setEditor(new JSpinner.NumberEditor(this.initialNumberSpinner));
        this.minimumNumberSpinner.setValue(n[1]);
        this.minimumNumberSpinner.setEditor(new JSpinner.NumberEditor(this.minimumNumberSpinner));
        this.maximumNumberSpinner.setValue(n[2]);
        this.maximumNumberSpinner.setEditor(new JSpinner.NumberEditor(this.maximumNumberSpinner));
        this.stepSizeSpinner.setValue(n[3]);
        this.stepSizeSpinner.setEditor(new JSpinner.NumberEditor(this.stepSizeSpinner));
    }

    private void calendarFieldComboActionPerformed(ActionEvent evt) {
        this.updateFromUI();
    }

    private void maximumDateSpinnerStateChanged(ChangeEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.maximumDateUpdated();
        this.updateFromUI();
    }

    private void minimumDateSpinnerStateChanged(ChangeEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.minimumDateUpdated();
        this.updateFromUI();
    }

    private void initialDateSpinnerStateChanged(ChangeEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.initialDateUpdated();
        this.updateFromUI();
    }

    private void maximumDateCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean enabled = this.maximumDateCheckBox.isSelected();
        this.maximumNowCheckBox.setEnabled(enabled);
        if (enabled) {
            Date maximum = (Date)this.maximumDateSpinner.getValue();
            Date initial = (Date)this.initialDateSpinner.getValue();
            if (maximum.getTime() - initial.getTime() < 0L) {
                if (this.maximumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.maximumNowCheckBox.setSelected(false);
                        this.maximumDateSpinner.setValue(initial);
                    }
                } else {
                    this.maximumDateSpinner.setValue(initial);
                }
            }
        }
        this.maximumDateSpinner.setEnabled(enabled && !this.maximumNowCheckBox.isSelected());
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void minimumDateCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean enabled = this.minimumDateCheckBox.isSelected();
        this.minimumNowCheckBox.setEnabled(enabled);
        if (enabled) {
            Date minimum = (Date)this.minimumDateSpinner.getValue();
            Date initial = (Date)this.initialDateSpinner.getValue();
            if (initial.getTime() - minimum.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setValue(initial);
                    }
                } else {
                    this.minimumDateSpinner.setValue(initial);
                }
            }
        }
        this.minimumDateSpinner.setEnabled(enabled && !this.minimumNowCheckBox.isSelected());
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void maximumNowCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean enabled = !this.maximumNowCheckBox.isSelected();
        this.maximumDateSpinner.setEnabled(enabled);
        if (!enabled) {
            this.maximumDateSpinner.setValue(new Date());
        }
        this.maximumDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void minimumNowCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean enabled = !this.minimumNowCheckBox.isSelected();
        this.minimumDateSpinner.setEnabled(enabled);
        if (!enabled) {
            this.minimumDateSpinner.setValue(new Date());
        }
        this.minimumDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void initialNowCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        boolean enabled = !this.initialNowCheckBox.isSelected();
        this.initialDateSpinner.setEnabled(enabled);
        if (!enabled) {
            this.initialDateSpinner.setValue(new Date());
        }
        this.initialDateUpdated();
        this.fireChanges = true;
        this.updateFromUI();
    }

    private void modelTypeComboActionPerformed(ActionEvent evt) {
        CardLayout layout = (CardLayout)this.modelTypePanel.getLayout();
        String name = null;
        switch (this.modelTypeCombo.getSelectedIndex()) {
            case 0: {
                name = VALUE_TYPE_DEFAULT;
                break;
            }
            case 1: {
                name = VALUE_TYPE_DATE;
                break;
            }
            case 2: {
                name = VALUE_TYPE_LIST;
                break;
            }
            case 3: {
                name = VALUE_TYPE_NUMBER;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.updateVisibilityOfModelProperties();
        layout.show(this.modelTypePanel, name);
        this.updateFromUI();
    }

    private void updateVisibilityOfModelProperties() {
        boolean visible = this.modelTypeCombo.getSelectedIndex() != 0;
        this.modelPropertiesLabel.setVisible(visible);
        this.separator.setVisible(visible);
    }

    private void minimumNumberUpdated() {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        if (this.minimumNumberCheckBox.isSelected()) {
            Comparable maximum;
            Comparable minimum = (Comparable)this.minimumNumberSpinner.getValue();
            Comparable initial = (Comparable)this.initialNumberSpinner.getValue();
            if (initial.compareTo(minimum) < 0) {
                this.initialNumberSpinner.setValue(minimum);
            }
            if (this.maximumNumberCheckBox.isSelected() && (maximum = (Comparable)this.maximumNumberSpinner.getValue()).compareTo(minimum) < 0) {
                this.maximumNumberSpinner.setValue(minimum);
            }
        }
        this.fireChanges = true;
    }

    private void maximumNumberUpdated() {
        if (!this.fireChanges) {
            return;
        }
        this.fireChanges = false;
        if (this.maximumNumberCheckBox.isSelected()) {
            Comparable minimum;
            Comparable maximum = (Comparable)this.maximumNumberSpinner.getValue();
            Comparable initial = (Comparable)this.initialNumberSpinner.getValue();
            if (initial.compareTo(maximum) > 0) {
                this.initialNumberSpinner.setValue(maximum);
            }
            if (this.minimumNumberCheckBox.isSelected() && maximum.compareTo(minimum = (Comparable)this.minimumNumberSpinner.getValue()) < 0) {
                this.minimumNumberSpinner.setValue(maximum);
            }
        }
        this.fireChanges = true;
    }

    private void initialDateUpdated() {
        Date maximum;
        this.fireChanges = false;
        Date initial = (Date)this.initialDateSpinner.getValue();
        if (this.minimumDateCheckBox.isSelected()) {
            Date minimum = (Date)this.minimumDateSpinner.getValue();
            if (initial.getTime() - minimum.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.initialNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setEnabled(true);
                        this.minimumDateSpinner.setValue(initial);
                    }
                } else {
                    this.minimumDateSpinner.setValue(initial);
                }
            }
        }
        if (this.maximumDateCheckBox.isSelected() && (maximum = (Date)this.maximumDateSpinner.getValue()).getTime() - initial.getTime() < 0L) {
            if (this.maximumNowCheckBox.isSelected()) {
                if (!this.initialNowCheckBox.isSelected()) {
                    this.maximumNowCheckBox.setSelected(false);
                    this.maximumDateSpinner.setEnabled(true);
                    this.maximumDateSpinner.setValue(initial);
                }
            } else {
                this.maximumDateSpinner.setValue(initial);
            }
        }
        this.fireChanges = true;
    }

    private void minimumDateUpdated() {
        Date maximum;
        this.fireChanges = false;
        if (!this.minimumDateCheckBox.isSelected()) {
            return;
        }
        Date minimum = (Date)this.minimumDateSpinner.getValue();
        Date initial = (Date)this.initialDateSpinner.getValue();
        if (initial.getTime() - minimum.getTime() < 0L) {
            if (this.initialNowCheckBox.isSelected()) {
                if (!this.minimumNowCheckBox.isSelected()) {
                    this.initialNowCheckBox.setSelected(false);
                    this.initialDateSpinner.setEnabled(true);
                    this.initialDateSpinner.setValue(minimum);
                }
            } else {
                this.initialDateSpinner.setValue(minimum);
            }
        }
        if (this.maximumDateCheckBox.isSelected() && (maximum = (Date)this.maximumDateSpinner.getValue()).getTime() - minimum.getTime() < 0L) {
            if (this.maximumNowCheckBox.isSelected()) {
                if (!this.minimumNowCheckBox.isSelected()) {
                    this.maximumNowCheckBox.setSelected(false);
                    this.maximumDateSpinner.setEnabled(true);
                    this.maximumDateSpinner.setValue(minimum);
                }
            } else {
                this.maximumDateSpinner.setValue(minimum);
            }
        }
        this.fireChanges = true;
    }

    private void maximumDateUpdated() {
        if (!this.maximumDateCheckBox.isSelected()) {
            return;
        }
        this.fireChanges = false;
        Date maximum = (Date)this.maximumDateSpinner.getValue();
        Date initial = (Date)this.initialDateSpinner.getValue();
        if (maximum.getTime() - initial.getTime() < 0L) {
            if (this.initialNowCheckBox.isSelected()) {
                if (!this.maximumNowCheckBox.isSelected()) {
                    this.initialNowCheckBox.setSelected(false);
                    this.initialDateSpinner.setEnabled(true);
                    this.initialDateSpinner.setValue(maximum);
                }
            } else {
                this.initialDateSpinner.setValue(maximum);
            }
        }
        if (this.minimumDateCheckBox.isSelected()) {
            Date minimum = (Date)this.minimumDateSpinner.getValue();
            if (maximum.getTime() - minimum.getTime() < 0L) {
                if (this.minimumNowCheckBox.isSelected()) {
                    if (!this.maximumNowCheckBox.isSelected()) {
                        this.minimumNowCheckBox.setSelected(false);
                        this.minimumDateSpinner.setEnabled(true);
                        this.minimumDateSpinner.setValue(maximum);
                    }
                } else {
                    this.minimumDateSpinner.setValue(maximum);
                }
            }
        }
        this.fireChanges = true;
    }

    @Override
    public String getJavaInitializationString() {
        Object value = this.getValue();
        if (!(value instanceof FormSpinnerModel)) {
            return super.getJavaInitializationString();
        }
        FormSpinnerModel model = (FormSpinnerModel)value;
        SpinnerModel spinnerModel = model.getModel();
        String code = null;
        if (spinnerModel instanceof SpinnerDateModel) {
            code = this.dateInitializationString(model);
        } else if (spinnerModel instanceof SpinnerNumberModel) {
            code = this.numberInitializationString(model);
        } else if (spinnerModel instanceof SpinnerListModel) {
            code = SpinnerModelEditor.listInitializationString(model);
        } else assert (false);
        return code;
    }

    private static String listInitializationString(FormSpinnerModel model) {
        StringBuilder code = new StringBuilder("new javax.swing.SpinnerListModel(new String[] {");
        SpinnerListModel listModel = (SpinnerListModel)model.getModel();
        List<?> items = listModel.getList();
        for (Object item : items) {
            String text = item.toString();
            text = text.replace("\"", "\\\"");
            code.append('\"').append(text).append("\", ");
        }
        code.delete(code.length() - 2, code.length());
        code.append("})");
        return code.toString();
    }

    private String numberInitializationString(FormSpinnerModel model) {
        StringBuilder code = new StringBuilder();
        SpinnerNumberModel numberModel = (SpinnerNumberModel)model.getModel();
        code.append("new javax.swing.SpinnerNumberModel(");
        Object initial = model.getInitialValue();
        Comparable<?> minimum = numberModel.getMinimum();
        Comparable<?> maximum = numberModel.getMaximum();
        Number stepSize = numberModel.getStepSize();
        Class<?> clazz = initial.getClass();
        if (clazz == Integer.class && Integer.valueOf(0).equals(initial) && minimum == null && maximum == null && Integer.valueOf(1).equals(stepSize)) {
            code.append(')');
        } else {
            Object prefix = "";
            Object suffix = "";
            if (clazz == Long.class) {
                suffix = "L";
                if (minimum != null && maximum != null) {
                    prefix = "Long.valueOf(";
                    suffix = (String)suffix + ")";
                }
            } else if (clazz == Float.class) {
                suffix = "f";
                if (minimum != null && maximum != null) {
                    prefix = "Float.valueOf(";
                    suffix = (String)suffix + ")";
                }
            } else if (clazz == Double.class) {
                suffix = "d";
            } else if (clazz == Byte.class) {
                prefix = "(byte)";
                if (minimum != null && maximum != null) {
                    prefix = "Byte.valueOf(" + (String)prefix;
                    suffix = (String)suffix + ")";
                }
            } else if (clazz == Short.class) {
                prefix = "(short)";
                if (minimum != null && maximum != null) {
                    prefix = "Short.valueOf(" + (String)prefix;
                    suffix = (String)suffix + ")";
                }
            }
            code.append((String)prefix).append(initial).append((String)suffix).append(", ");
            if (minimum == null) {
                code.append("null, ");
            } else {
                code.append((String)prefix).append(minimum).append((String)suffix).append(", ");
            }
            if (maximum == null) {
                code.append("null, ");
            } else {
                code.append((String)prefix).append(maximum).append((String)suffix).append(", ");
            }
            code.append((String)prefix).append(stepSize).append((String)suffix).append(")");
        }
        return code.toString();
    }

    private String dateInitializationString(FormSpinnerModel model) {
        StringBuilder code = new StringBuilder();
        SpinnerDateModel dateModel = (SpinnerDateModel)model.getModel();
        code.append("new javax.swing.SpinnerDateModel(");
        if (model.isInitialNow() && dateModel.getCalendarField() == 5 && dateModel.getStart() == null && dateModel.getEnd() == null) {
            code.append(')');
        } else {
            code.append("new java.util.Date(");
            if (!model.isInitialNow()) {
                code.append(((Date)model.getInitialValue()).getTime());
                code.append('L');
            }
            code.append("), ");
            Date minimum = (Date)dateModel.getStart();
            if (minimum == null) {
                code.append("null");
            } else {
                code.append("new java.util.Date(");
                if (!model.isMinimumNow()) {
                    code.append(minimum.getTime());
                    code.append('L');
                }
                code.append(')');
            }
            code.append(", ");
            Date maximum = (Date)dateModel.getEnd();
            if (maximum == null) {
                code.append("null");
            } else {
                code.append("new java.util.Date(");
                if (!model.isMaximumNow()) {
                    code.append(maximum.getTime());
                    code.append('L');
                }
                code.append(')');
            }
            code.append(", ");
            int field = dateModel.getCalendarField();
            String fieldText = null;
            switch (field) {
                case 0: {
                    fieldText = "ERA";
                    break;
                }
                case 1: {
                    fieldText = "YEAR";
                    break;
                }
                case 2: {
                    fieldText = "MONTH";
                    break;
                }
                case 3: {
                    fieldText = "WEEK_OF_YEAR";
                    break;
                }
                case 4: {
                    fieldText = "WEEK_OF_MONTH";
                    break;
                }
                case 5: {
                    fieldText = "DAY_OF_MONTH";
                    break;
                }
                case 6: {
                    fieldText = "DAY_OF_YEAR";
                    break;
                }
                case 7: {
                    fieldText = "DAY_OF_WEEK";
                    break;
                }
                case 8: {
                    fieldText = "DAY_OF_WEEK_IN_MONTH";
                    break;
                }
                case 9: {
                    fieldText = "AM_PM";
                    break;
                }
                case 10: {
                    fieldText = "HOUR";
                    break;
                }
                case 11: {
                    fieldText = "HOUR_OF_DAY";
                    break;
                }
                case 12: {
                    fieldText = "MINUTE";
                    break;
                }
                case 13: {
                    fieldText = "SECOND";
                    break;
                }
                case 14: {
                    fieldText = "MILLISECOND";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            code.append("java.util.Calendar.").append(fieldText).append(')');
        }
        return code.toString();
    }

    public void readFromXML(Node element) throws IOException {
        NamedNodeMap attributes = element.getAttributes();
        String type = attributes.getNamedItem(ATTR_TYPE).getNodeValue();
        Object value = null;
        if (VALUE_TYPE_DEFAULT.equals(type)) {
            value = this.property.getDefaultValue();
        } else if (VALUE_TYPE_DATE.equals(type)) {
            value = SpinnerModelEditor.readDateFromXML(element);
        } else if (VALUE_TYPE_NUMBER.equals(type)) {
            value = SpinnerModelEditor.readNumberFromXML(element);
        } else if (VALUE_TYPE_LIST.equals(type)) {
            value = SpinnerModelEditor.readListFromXML(element);
        }
        this.setValue(value);
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_SPINNER_MODEL);
        Object value = this.getValue();
        if (!(value instanceof FormSpinnerModel)) {
            el.setAttribute(ATTR_TYPE, VALUE_TYPE_DEFAULT);
        } else {
            FormSpinnerModel model = (FormSpinnerModel)value;
            SpinnerModel spinnerModel = model.getModel();
            if (spinnerModel instanceof SpinnerNumberModel) {
                SpinnerModelEditor.storeNumberToXML(el, model);
            } else if (spinnerModel instanceof SpinnerDateModel) {
                SpinnerModelEditor.storeDateToXML(el, model);
            } else if (spinnerModel instanceof SpinnerListModel) {
                SpinnerModelEditor.storeListToXML(doc, el, model);
            }
        }
        return el;
    }

    private static void storeNumberToXML(Element el, FormSpinnerModel model) {
        Comparable<?> maximum;
        el.setAttribute(ATTR_TYPE, VALUE_TYPE_NUMBER);
        SpinnerNumberModel numberModel = (SpinnerNumberModel)model.getModel();
        el.setAttribute(ATTR_NUMBER_TYPE, model.getInitialValue().getClass().getName());
        el.setAttribute(ATTR_INITIAL, model.getInitialValue().toString());
        Comparable<?> minimum = numberModel.getMinimum();
        if (minimum != null) {
            el.setAttribute(ATTR_MINIMUM, minimum.toString());
        }
        if ((maximum = numberModel.getMaximum()) != null) {
            el.setAttribute(ATTR_MAXIMUM, maximum.toString());
        }
        el.setAttribute(ATTR_STEP_SIZE, numberModel.getStepSize().toString());
    }

    private static Object readNumberFromXML(Node el) {
        NamedNodeMap attributes = el.getAttributes();
        String numberType = attributes.getNamedItem(ATTR_NUMBER_TYPE).getNodeValue();
        String initialTxt = attributes.getNamedItem(ATTR_INITIAL).getNodeValue();
        Node node = attributes.getNamedItem(ATTR_MINIMUM);
        String minimumTxt = null;
        if (node != null) {
            minimumTxt = node.getNodeValue();
        }
        node = attributes.getNamedItem(ATTR_MAXIMUM);
        String maximumTxt = null;
        if (node != null) {
            maximumTxt = node.getNodeValue();
        }
        String stepSizeTxt = attributes.getNamedItem(ATTR_STEP_SIZE).getNodeValue();
        Number stepSize = null;
        Integer minimum = null;
        Integer maximum = null;
        Number initial = null;
        if (numberType.equals("java.lang.Integer")) {
            initial = Integer.parseInt(initialTxt);
            minimum = minimumTxt == null ? null : Integer.valueOf(Integer.parseInt(minimumTxt));
            maximum = maximumTxt == null ? null : Integer.valueOf(Integer.parseInt(maximumTxt));
            stepSize = Integer.parseInt(stepSizeTxt);
        } else if (numberType.equals("java.lang.Long")) {
            initial = Long.parseLong(initialTxt);
            minimum = minimumTxt == null ? null : Long.valueOf(Long.parseLong(minimumTxt));
            maximum = maximumTxt == null ? null : Long.valueOf(Long.parseLong(maximumTxt));
            stepSize = Long.parseLong(stepSizeTxt);
        } else if (numberType.equals("java.lang.Float")) {
            initial = Float.valueOf(Float.parseFloat(initialTxt));
            minimum = minimumTxt == null ? null : Float.valueOf(Float.parseFloat(minimumTxt));
            maximum = maximumTxt == null ? null : Float.valueOf(Float.parseFloat(maximumTxt));
            stepSize = Float.valueOf(Float.parseFloat(stepSizeTxt));
        } else if (numberType.equals("java.lang.Double")) {
            initial = Double.parseDouble(initialTxt);
            minimum = minimumTxt == null ? null : Double.valueOf(Double.parseDouble(minimumTxt));
            maximum = maximumTxt == null ? null : Double.valueOf(Double.parseDouble(maximumTxt));
            stepSize = Double.parseDouble(stepSizeTxt);
        } else if (numberType.equals("java.lang.Short")) {
            initial = Short.parseShort(initialTxt);
            minimum = minimumTxt == null ? null : Short.valueOf(Short.parseShort(minimumTxt));
            maximum = maximumTxt == null ? null : Short.valueOf(Short.parseShort(maximumTxt));
            stepSize = Short.parseShort(stepSizeTxt);
        } else if (numberType.equals("java.lang.Byte")) {
            initial = Byte.parseByte(initialTxt);
            minimum = minimumTxt == null ? null : Byte.valueOf(Byte.parseByte(minimumTxt));
            maximum = maximumTxt == null ? null : Byte.valueOf(Byte.parseByte(maximumTxt));
            stepSize = Byte.parseByte(stepSizeTxt);
        }
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(initial, minimum, maximum, stepSize);
        return new FormSpinnerModel(spinnerModel, (Object)initial);
    }

    private static void storeDateToXML(Element el, FormSpinnerModel model) {
        Date maximum;
        Object initialText;
        el.setAttribute(ATTR_TYPE, VALUE_TYPE_DATE);
        SpinnerDateModel dateModel = (SpinnerDateModel)model.getModel();
        if (model.isInitialNow()) {
            initialText = VALUE_NOW;
        } else {
            Date initial = (Date)model.getInitialValue();
            initialText = "" + initial.getTime();
        }
        el.setAttribute(ATTR_INITIAL, (String)initialText);
        Date minimum = (Date)dateModel.getStart();
        if (minimum != null) {
            Object minimumText = model.isMinimumNow() ? VALUE_NOW : "" + minimum.getTime();
            el.setAttribute(ATTR_MINIMUM, (String)minimumText);
        }
        if ((maximum = (Date)dateModel.getEnd()) != null) {
            Object maximumText = model.isMaximumNow() ? VALUE_NOW : "" + maximum.getTime();
            el.setAttribute(ATTR_MAXIMUM, (String)maximumText);
        }
        el.setAttribute(ATTR_STEP_SIZE, "" + dateModel.getCalendarField());
    }

    private static Object readDateFromXML(Node el) {
        Date initial;
        NamedNodeMap attributes = el.getAttributes();
        String initialTxt = attributes.getNamedItem(ATTR_INITIAL).getNodeValue();
        Date now = new Date();
        boolean initialNow = false;
        if (VALUE_NOW.equals(initialTxt)) {
            initialNow = true;
            initial = now;
        } else {
            initial = new Date(Long.parseLong(initialTxt));
        }
        Node node = attributes.getNamedItem(ATTR_MINIMUM);
        String minimumTxt = node == null ? null : node.getNodeValue();
        boolean minimumNow = false;
        Date minimum = null;
        if (minimumTxt != null) {
            if (VALUE_NOW.equals(minimumTxt)) {
                minimumNow = true;
                minimum = now;
            } else {
                minimum = new Date(Long.parseLong(minimumTxt));
            }
        }
        String maximumTxt = (node = attributes.getNamedItem(ATTR_MAXIMUM)) == null ? null : node.getNodeValue();
        boolean maximumNow = false;
        Date maximum = null;
        if (maximumTxt != null) {
            if (VALUE_NOW.equals(maximumTxt)) {
                maximumNow = true;
                maximum = now;
            } else {
                maximum = new Date(Long.parseLong(maximumTxt));
            }
        }
        String stepSizeTxt = attributes.getNamedItem(ATTR_STEP_SIZE).getNodeValue();
        int calendarField = Integer.parseInt(stepSizeTxt);
        SpinnerDateModel spinnerModel = new SpinnerDateModel(initial, minimum, maximum, calendarField);
        return new FormSpinnerModel(spinnerModel, initial, initialNow, minimumNow, maximumNow);
    }

    private static void storeListToXML(Document doc, Element el, FormSpinnerModel model) {
        el.setAttribute(ATTR_TYPE, VALUE_TYPE_LIST);
        SpinnerListModel listModel = (SpinnerListModel)model.getModel();
        List<?> items = listModel.getList();
        for (Object item : items) {
            Element elItem = doc.createElement(XML_LIST_ITEM);
            elItem.setAttribute(ATTR_VALUE, item.toString());
            el.appendChild(elItem);
        }
    }

    private static Object readListFromXML(Node el) {
        NodeList nodes = el.getChildNodes();
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!XML_LIST_ITEM.equals(node.getNodeName())) continue;
            list.add(node.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue());
        }
        SpinnerListModel spinnerModel = new SpinnerListModel(list);
        return new FormSpinnerModel(spinnerModel, list.get(0));
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"SpinnerModelEditor");
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    public static class FormSpinnerModel
    extends FormDesignValueAdapter {
        private SpinnerModel model;
        private Object initialValue;
        private boolean initialNow;
        private boolean minimumNow;
        private boolean maximumNow;

        public FormSpinnerModel(SpinnerListModel model, Object initialValue) {
            this.model = model;
            this.initialValue = initialValue;
        }

        public FormSpinnerModel(SpinnerNumberModel model, Object initialValue) {
            this.model = model;
            this.initialValue = initialValue;
        }

        public FormSpinnerModel(SpinnerDateModel model, Object initialValue, boolean initialNow, boolean minimumNow, boolean maximumNow) {
            this.model = model;
            this.initialValue = initialValue;
            this.initialNow = initialNow;
            this.minimumNow = minimumNow;
            this.maximumNow = maximumNow;
        }

        private FormSpinnerModel(FormSpinnerModel original) {
            this.model = original.model;
            this.initialValue = original.initialValue;
            this.initialNow = original.initialNow;
            this.minimumNow = original.minimumNow;
            this.maximumNow = original.maximumNow;
        }

        public SpinnerModel getModel() {
            return this.model;
        }

        public Object getInitialValue() {
            return this.initialValue;
        }

        public boolean isInitialNow() {
            return this.initialNow;
        }

        public boolean isMinimumNow() {
            return this.minimumNow;
        }

        public boolean isMaximumNow() {
            return this.maximumNow;
        }

        @Override
        public SpinnerModel getDesignValue() {
            return this.model;
        }

        @Override
        public Object copy(FormProperty targetFormProperty) {
            return new FormSpinnerModel(this);
        }
    }

    private class FormListener
    implements ActionListener,
    FocusListener,
    ChangeListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SpinnerModelEditor.this.modelTypeCombo) {
                SpinnerModelEditor.this.modelTypeComboActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.initialNowCheckBox) {
                SpinnerModelEditor.this.initialNowCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.minimumDateCheckBox) {
                SpinnerModelEditor.this.minimumDateCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.minimumNowCheckBox) {
                SpinnerModelEditor.this.minimumNowCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.maximumDateCheckBox) {
                SpinnerModelEditor.this.maximumDateCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.maximumNowCheckBox) {
                SpinnerModelEditor.this.maximumNowCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.calendarFieldCombo) {
                SpinnerModelEditor.this.calendarFieldComboActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.initialListCombo) {
                SpinnerModelEditor.this.initialListComboActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.numberTypeCombo) {
                SpinnerModelEditor.this.numberTypeComboActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.minimumNumberCheckBox) {
                SpinnerModelEditor.this.minimumNumberCheckBoxActionPerformed(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.maximumNumberCheckBox) {
                SpinnerModelEditor.this.maximumNumberCheckBoxActionPerformed(evt);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (evt.getSource() == SpinnerModelEditor.this.listItemsArea) {
                SpinnerModelEditor.this.listItemsAreaFocusLost(evt);
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == SpinnerModelEditor.this.initialDateSpinner) {
                SpinnerModelEditor.this.initialDateSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.minimumDateSpinner) {
                SpinnerModelEditor.this.minimumDateSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.maximumDateSpinner) {
                SpinnerModelEditor.this.maximumDateSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.initialNumberSpinner) {
                SpinnerModelEditor.this.initialNumberSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.minimumNumberSpinner) {
                SpinnerModelEditor.this.minimumNumberSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.maximumNumberSpinner) {
                SpinnerModelEditor.this.maximumNumberSpinnerStateChanged(evt);
            } else if (evt.getSource() == SpinnerModelEditor.this.stepSizeSpinner) {
                SpinnerModelEditor.this.stepSizeSpinnerStateChanged(evt);
            }
        }
    }
}

