/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import org.netbeans.modules.form.CodeCustomEditor;
import org.netbeans.modules.form.ConnectionCustomEditor;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RADConnectionPropertyEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    private Type editorType;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Class propertyType;
    private FormModel formModel = null;
    private FormProperty property;
    private RADConnectionDesignValue designValue = null;
    private Object realValue = null;
    public static final String XML_CONNECTION = "Connection";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_COMPONENT = "component";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CODE = "code";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_REQUIRED_TYPE = "valueType";
    public static final String VALUE_VALUE = "value";
    public static final String VALUE_PROPERTY = "property";
    public static final String VALUE_METHOD = "method";
    public static final String VALUE_BEAN = "bean";
    public static final String VALUE_CODE = "code";

    public RADConnectionPropertyEditor(Class propertyType) {
        this.propertyType = propertyType;
        this.editorType = Type.FormConnection;
    }

    public RADConnectionPropertyEditor(Class propertyType, Type editorType) {
        this.propertyType = propertyType;
        this.editorType = editorType;
    }

    public Type getEditorType() {
        return this.editorType;
    }

    @Override
    public void setContext(FormModel model, FormProperty prop) {
        this.formModel = model;
        this.property = prop;
    }

    @Override
    public void updateFormVersionLevel() {
    }

    @Override
    public Object getValue() {
        return this.designValue != null ? this.designValue : this.realValue;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof RADConnectionDesignValue) {
            String code;
            this.designValue = (RADConnectionDesignValue)value;
            Type type = this.editorType = this.designValue.getType() == 2 ? Type.CustomCode : Type.FormConnection;
            if (this.editorType == Type.CustomCode && ((code = this.designValue.getCode()) == null || code.trim().length() == 0)) {
                this.setValue(this.property.getDefaultValue());
            }
        } else {
            this.designValue = null;
            this.realValue = value;
        }
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rectangle) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.getValueString(), rectangle.x, rectangle.y + (rectangle.height - fm.getHeight()) / 2 + fm.getAscent());
    }

    @Override
    public boolean supportsCustomEditor() {
        if (this.formModel.isReadOnly()) {
            return false;
        }
        if (this.editorType == Type.CustomCode) {
            FormEditor formEditor = FormEditor.getFormEditor(this.formModel);
            if (formEditor == null) {
                return false;
            }
            if (formEditor.getGuardedSectionManager() == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.editorType == Type.FormConnection) {
            ConnectionCustomEditor cust = new ConnectionCustomEditor(this, this.formModel, this.propertyType);
            cust.setValue(this.designValue);
            return cust;
        }
        CodeCustomEditor cust = new CodeCustomEditor(this, this.formModel, this.property);
        cust.setValue(this.designValue);
        return cust;
    }

    @Override
    public String getJavaInitializationString() {
        if (this.designValue != null) {
            if (this.designValue.needsInit) {
                this.designValue.initialize();
            }
            if (this.designValue.type == 3) {
                if ("java.lang.String".equals(this.designValue.requiredTypeName)) {
                    return "\"" + this.designValue.value + "\"";
                }
                if ("long".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "L";
                }
                if ("float".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "F";
                }
                if ("double".equals(this.designValue.requiredTypeName)) {
                    return this.designValue.value + "D";
                }
                if ("char".equals(this.designValue.requiredTypeName)) {
                    return "'" + this.designValue.value + "'";
                }
                return this.designValue.value;
            }
            if (this.designValue.type == 2) {
                return this.designValue.userCode;
            }
            if (this.designValue.radComponent == null || this.designValue.radComponent.getCodeExpression() == null) {
                return null;
            }
            if (this.designValue.type == 0) {
                PropertyDescriptor pd = this.designValue.getProperty();
                if (pd == null) {
                    return null;
                }
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return pd.getReadMethod().getName() + "()";
                }
                return this.designValue.radComponent.getName() + "." + pd.getReadMethod().getName() + "()";
            }
            if (this.designValue.type == 1) {
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return this.designValue.methodName + "()";
                }
                return this.designValue.radComponent.getName() + "." + this.designValue.methodName + "()";
            }
            if (this.designValue.type == 4) {
                if (this.designValue.radComponent == this.formModel.getTopRADComponent()) {
                    return "this";
                }
                return this.designValue.radComponent.getName();
            }
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public String getDisplayName() {
        return FormUtils.getBundleString(this.editorType == Type.FormConnection ? "CTL_FormConnection_DisplayName" : "CTL_CustomCode_DisplayName");
    }

    private String getValueString() {
        Object str = this.designValue != null ? this.designValue.getName() : (this.realValue != null ? (this.realValue instanceof Number || this.realValue instanceof Boolean || this.realValue instanceof String || this.realValue instanceof Character ? this.realValue.toString() : (this.realValue.getClass().isArray() ? "[" + FormUtils.getBundleString("CTL_ArrayOf") + " " + this.realValue.getClass().getComponentType().getName() + "]" : "[" + Utilities.getShortClassName(this.realValue.getClass()) + "]")) : "null");
        return str;
    }

    private static Object parseValue(String typeName, String value) {
        try {
            if ("java.lang.String".equals(typeName)) {
                return value;
            }
            if ("int".equals(typeName)) {
                return Integer.valueOf(value);
            }
            if ("short".equals(typeName)) {
                return Short.valueOf(value);
            }
            if ("long".equals(typeName)) {
                return Long.valueOf(value);
            }
            if ("byte".equals(typeName)) {
                return Byte.valueOf(value);
            }
            if ("float".equals(typeName)) {
                return Float.valueOf(value);
            }
            if ("double".equals(typeName)) {
                return Double.valueOf(value);
            }
            if ("boolean".equals(typeName)) {
                return Boolean.valueOf(value);
            }
            if ("char".equals(typeName) && value.length() > 0) {
                return Character.valueOf(value.charAt(0));
            }
            return FormDesignValue.IGNORED_VALUE;
        }
        catch (Exception e) {
            return FormDesignValue.IGNORED_VALUE;
        }
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_CONNECTION.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            String typeString = attributes.getNamedItem(ATTR_TYPE).getNodeValue();
            if ("value".equals(typeString)) {
                String value = attributes.getNamedItem("value").getNodeValue();
                String valueType = attributes.getNamedItem(ATTR_REQUIRED_TYPE).getNodeValue();
                this.setValue(new RADConnectionDesignValue(valueType, value));
            } else if (VALUE_PROPERTY.equals(typeString)) {
                String component = attributes.getNamedItem(ATTR_COMPONENT).getNodeValue();
                String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
                this.setValue(new RADConnectionDesignValue(component, 0, name, this.formModel));
            } else if (VALUE_METHOD.equals(typeString)) {
                String component = attributes.getNamedItem(ATTR_COMPONENT).getNodeValue();
                String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
                this.setValue(new RADConnectionDesignValue(component, 1, name, this.formModel));
            } else if (VALUE_BEAN.equals(typeString)) {
                String component = attributes.getNamedItem(ATTR_COMPONENT).getNodeValue();
                this.setValue(new RADConnectionDesignValue(component, 4, null, this.formModel));
            } else {
                String code = attributes.getNamedItem("code").getNodeValue();
                this.setValue(new RADConnectionDesignValue(code));
            }
        }
        catch (NullPointerException e) {
            IOException ioex = new IOException();
            ioex.initCause(e);
            throw ioex;
        }
    }

    public Node storeToXML(Document doc) {
        String componentName;
        if (this.designValue == null) {
            return null;
        }
        String string = componentName = this.designValue.radComponent != null ? this.designValue.radComponent.getName() : this.designValue.radComponentName;
        if (componentName == null && this.designValue.radComponent != null) {
            return null;
        }
        Element el = doc.createElement(XML_CONNECTION);
        el.setAttribute(ATTR_TYPE, switch (this.designValue.type) {
            case 3 -> "value";
            case 0 -> VALUE_PROPERTY;
            case 1 -> VALUE_METHOD;
            case 4 -> VALUE_BEAN;
            default -> "code";
        });
        switch (this.designValue.type) {
            case 3: {
                el.setAttribute("value", this.designValue.value);
                el.setAttribute(ATTR_REQUIRED_TYPE, this.designValue.requiredTypeName);
                break;
            }
            case 0: {
                el.setAttribute(ATTR_COMPONENT, componentName);
                el.setAttribute(ATTR_NAME, this.designValue.propertyName);
                break;
            }
            case 1: {
                el.setAttribute(ATTR_COMPONENT, componentName);
                el.setAttribute(ATTR_NAME, this.designValue.methodName);
                break;
            }
            case 4: {
                el.setAttribute(ATTR_COMPONENT, componentName);
                break;
            }
            case 2: {
                el.setAttribute("code", this.designValue.userCode);
            }
        }
        return el;
    }

    public static class RADConnectionDesignValue
    implements FormDesignValue {
        public static final int TYPE_PROPERTY = 0;
        public static final int TYPE_METHOD = 1;
        public static final int TYPE_CODE = 2;
        public static final int TYPE_VALUE = 3;
        public static final int TYPE_BEAN = 4;
        int type;
        private transient RADComponent radComponent = null;
        String radComponentName = null;
        private transient MethodDescriptor method = null;
        String methodName = null;
        private transient PropertyDescriptor property = null;
        String propertyName = null;
        String userCode = null;
        String value = null;
        String requiredTypeName = null;
        private transient boolean needsInit = false;
        private transient FormModel formModel;
        static final long serialVersionUID = 147134837271021412L;

        RADConnectionDesignValue(RADComponent comp) {
            this.radComponent = comp;
            this.radComponentName = this.radComponent.getName();
            this.type = 4;
        }

        RADConnectionDesignValue(RADComponent comp, MethodDescriptor md) {
            this.radComponent = comp;
            this.radComponentName = this.radComponent.getName();
            this.method = md;
            this.methodName = md.getName();
            this.type = 1;
        }

        RADConnectionDesignValue(RADComponent comp, PropertyDescriptor pd) {
            this.radComponent = comp;
            this.radComponentName = this.radComponent.getName();
            this.property = pd;
            this.propertyName = pd.getName();
            this.type = 0;
        }

        RADConnectionDesignValue(String reqTypeName, String valueText) {
            this.requiredTypeName = reqTypeName;
            this.value = valueText;
            this.type = 3;
        }

        private RADConnectionDesignValue(String compName, int valueType, String name, FormModel manager) {
            this.radComponentName = compName;
            this.formModel = manager;
            if (valueType == 0) {
                this.needsInit = true;
                this.type = 0;
                this.propertyName = name;
            } else if (valueType == 1) {
                this.needsInit = true;
                this.type = 1;
                this.methodName = name;
            } else if (valueType == 4) {
                this.needsInit = true;
                this.type = 4;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public RADConnectionDesignValue(Class requiredType, String valueText) {
            this.requiredTypeName = requiredType.getName();
            this.value = valueText;
            this.type = 3;
        }

        public RADConnectionDesignValue(String userCode) {
            this.userCode = userCode;
            this.type = 2;
        }

        @Override
        public FormDesignValue copy(FormProperty formProperty) {
            switch (this.type) {
                case 2: {
                    return new RADConnectionDesignValue(this.userCode);
                }
                case 3: {
                    return new RADConnectionDesignValue(this.requiredTypeName, this.value);
                }
            }
            return null;
        }

        String getName() {
            if (this.needsInit) {
                this.initialize();
            }
            if (this.type == 3) {
                return FormUtils.getFormattedBundleString("FMT_VALUE_CONN", this.value);
            }
            if (this.type == 2) {
                return FormUtils.getBundleString("CTL_CODE_CONN");
            }
            if (this.radComponent == null || this.radComponent.getCodeExpression() == null) {
                return FormUtils.getBundleString("CTL_CONNECTION_INVALID");
            }
            if (this.type == 0) {
                return FormUtils.getFormattedBundleString("FMT_PROPERTY_CONN", this.radComponent.getName(), this.propertyName);
            }
            if (this.type == 1) {
                return FormUtils.getFormattedBundleString("FMT_METHOD_CONN", this.radComponent.getName(), this.methodName);
            }
            if (this.type == 4) {
                return FormUtils.getFormattedBundleString("FMT_BEAN_CONN", this.radComponent.getName());
            }
            throw new IllegalStateException();
        }

        public PropertyDescriptor getProperty() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.property;
        }

        public MethodDescriptor getMethod() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.method;
        }

        public String getCode() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.userCode;
        }

        public String getValue() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.value;
        }

        public RADComponent getRADComponent() {
            if (this.needsInit && !this.initialize()) {
                return null;
            }
            return this.radComponent;
        }

        private boolean initialize() {
            boolean retVal = false;
            this.radComponent = this.formModel.findRADComponent(this.radComponentName);
            if (this.radComponent != null) {
                if (this.type == 4) {
                    retVal = true;
                } else if (this.type == 0) {
                    PropertyDescriptor[] componentsProps = this.radComponent.getBeanInfo().getPropertyDescriptors();
                    for (int i = 0; i < componentsProps.length; ++i) {
                        if (!componentsProps[i].getName().equals(this.propertyName)) continue;
                        this.property = componentsProps[i];
                        retVal = true;
                        break;
                    }
                } else {
                    MethodDescriptor[] componentMethods = this.radComponent.getBeanInfo().getMethodDescriptors();
                    for (int i = 0; i < componentMethods.length; ++i) {
                        if (!componentMethods[i].getName().equals(this.methodName)) continue;
                        this.method = componentMethods[i];
                        retVal = true;
                        break;
                    }
                }
            }
            if (retVal) {
                this.needsInit = false;
            }
            return retVal;
        }

        @Override
        public Object getDesignValue() {
            switch (this.type) {
                case 0: {
                    try {
                        return this.getProperty().getReadMethod().invoke(this.getRADComponent().getBeanInstance(), new Object[0]);
                    }
                    catch (Exception e) {
                        return FormDesignValue.IGNORED_VALUE;
                    }
                }
                case 1: {
                    try {
                        return this.getMethod().getMethod().invoke(this.getRADComponent().getBeanInstance(), new Object[0]);
                    }
                    catch (Exception e) {
                        return FormDesignValue.IGNORED_VALUE;
                    }
                }
                case 3: {
                    return RADConnectionPropertyEditor.parseValue(this.requiredTypeName, this.value);
                }
                case 4: {
                    RADComponent comp = this.getRADComponent();
                    return comp == null ? FormDesignValue.IGNORED_VALUE : comp.getBeanInstance();
                }
                case 2: {
                    return FormDesignValue.IGNORED_VALUE;
                }
            }
            return FormDesignValue.IGNORED_VALUE;
        }

        @Override
        public Object getDesignValue(Object target) {
            return null;
        }

        public Object getValueForBean(Object target) {
            if (target != null) {
                switch (this.type) {
                    case 0: {
                        try {
                            return this.getProperty().getReadMethod().invoke(target, new Object[0]);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 1: {
                        try {
                            return this.getMethod().getMethod().invoke(target, new Object[0]);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    case 4: {
                        return target;
                    }
                }
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.getName();
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum Type {
        FormConnection,
        CustomCode;

    }
}

