/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormLAF {
    private static final String SWING_NOXP = "swing.noxp";
    private static final String NO_LAF_SWITCHING = "netbeans.form.no_laf_switching";
    private static boolean initialized = false;
    private static boolean lafBlockEntered;
    private static DelegatingDefaults delDefaults;
    private static Map<Object, Object> netbeansDefaults;
    private static Map<Object, Object> userDefaults;
    private static Map<Class, MetalTheme> lafToTheme;
    private static boolean ideLafIsMetal;
    private static boolean preview;
    private static Class previewLaf;
    private static Map<ClassLoader, Map<Object, Object>> classLoaderToDefaults;
    private static UIDefaults lastDefaults;
    private static Map<Object, Object> classLoaderDefaults;
    static String oldNoXP;
    static Object origLAF;

    private FormLAF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreviewInfo initPreviewLaf(Class lafClass, ClassLoader formClassLoader) {
        if (FormLAF.noLafSwitching()) {
            return null;
        }
        try {
            ClassLoader classLoader;
            boolean previewLafIsMetal = MetalLookAndFeel.class.isAssignableFrom(lafClass);
            if (!ideLafIsMetal && previewLafIsMetal && !MetalLookAndFeel.class.equals((Object)lafClass) && lafToTheme.get(MetalLookAndFeel.class) == null) {
                lafToTheme.put(MetalLookAndFeel.class, MetalLookAndFeel.getCurrentTheme());
            }
            LookAndFeel previewLookAndFeel = (LookAndFeel)lafClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (previewLafIsMetal) {
                MetalTheme theme = lafToTheme.get(lafClass);
                if (theme == null) {
                    lafToTheme.put(lafClass, MetalLookAndFeel.getCurrentTheme());
                } else {
                    MetalLookAndFeel.setCurrentTheme(theme);
                }
            }
            String noxp = null;
            boolean classic = FormLAF.isClassicWinLAF(lafClass.getName());
            if (classic) {
                noxp = System.getProperty(SWING_NOXP);
                System.setProperty(SWING_NOXP, "y");
            }
            UIDefaults previewDefaults = null;
            try {
                previewLookAndFeel.initialize();
                previewDefaults = previewLookAndFeel.getDefaults();
            }
            finally {
                if (classic) {
                    if (noxp == null) {
                        System.getProperties().remove(SWING_NOXP);
                    } else {
                        System.setProperty(SWING_NOXP, noxp);
                    }
                }
            }
            PreviewInfo info = new PreviewInfo(previewLookAndFeel, previewDefaults);
            if (FormLAF.isNimbusLAF(lafClass) && !FormLAF.isNimbusLAF(UIManager.getLookAndFeel().getClass())) {
                Object control = null;
                try {
                    control = UIManager.getDefaults().remove("control");
                    UIManager.getDefaults().put("defaultFont", previewDefaults.get("defaultFont"));
                    FormLAF.setUsePreviewDefaults(formClassLoader, info);
                    for (PropertyChangeListener listener : UIManager.getPropertyChangeListeners()) {
                        if (!listener.getClass().getName().contains("NimbusDefaults")) continue;
                        for (int i = 0; i < 5; ++i) {
                            listener.propertyChange(new PropertyChangeEvent(UIManager.class, "lookAndFeel", null, null));
                        }
                        UIManager.removePropertyChangeListener(listener);
                    }
                    for (PropertyChangeListener listener : UIManager.getDefaults().getPropertyChangeListeners()) {
                        if (!listener.getClass().getName().contains("NimbusDefaults")) continue;
                        UIManager.getDefaults().removePropertyChangeListener(listener);
                    }
                }
                finally {
                    FormLAF.setUsePreviewDefaults(null, null);
                }
                if (control != null) {
                    UIManager.getDefaults().put("control", (Object)control);
                }
            }
            if (previewLafIsMetal && ideLafIsMetal) {
                LookAndFeel ideLaf = UIManager.getLookAndFeel();
                MetalTheme theme = lafToTheme.get(ideLaf.getClass());
                MetalLookAndFeel.setCurrentTheme(theme);
            }
            if ((classLoader = lafClass.getClassLoader()) != null) {
                previewDefaults.put("ClassLoader", classLoader);
            }
            return info;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return null;
    }

    private static boolean isClassicWinLAF(String className) {
        return "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(className);
    }

    private static boolean isNimbusLAF(Class lafClass) {
        return lafClass.getName().endsWith("NimbusLookAndFeel");
    }

    private static void invalidateXPStyle() {
        try {
            Class<?> xpStyle = Class.forName("com.sun.java.swing.plaf.windows.XPStyle");
            Method method = xpStyle.getDeclaredMethod("invalidateStyle", null);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(FormLAF.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    private static void initialize() throws Exception {
        initialized = true;
        UIDefaults defaults = UIManager.getDefaults();
        HashSet keySet = new HashSet(defaults.keySet());
        for (Object key : keySet) {
            defaults.get(key);
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        ideLafIsMetal = laf instanceof MetalLookAndFeel;
        if (ideLafIsMetal) {
            lafToTheme.put(laf.getClass(), MetalLookAndFeel.getCurrentTheme());
        }
        LookAndFeel original = laf;
        try {
            original = (LookAndFeel)laf.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Logger.getLogger(FormLAF.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        Method method = UIManager.class.getDeclaredMethod("getLAFState", new Class[0]);
        method.setAccessible(true);
        Object lafState = method.invoke(null, new Object[0]);
        method = lafState.getClass().getDeclaredMethod("setLookAndFeelDefaults", UIDefaults.class);
        method.setAccessible(true);
        UIDefaults ide = UIManager.getLookAndFeelDefaults();
        assert (!(ide instanceof DelegatingDefaults));
        delDefaults = new DelegatingDefaults(null, original.getDefaults(), ide);
        method.invoke(lafState, delDefaults);
        UIManager.getDefaults().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Class clazz;
                Object newValue;
                if ((delDefaults.isDelegating() || delDefaults.isPreviewing()) && (newValue = evt.getNewValue()) instanceof Class && ComponentUI.class.isAssignableFrom(clazz = (Class)newValue)) {
                    UIManager.getDefaults().put(evt.getPropertyName(), (Object)null);
                }
            }
        });
    }

    static Object executeWithLookAndFeel(final FormModel formModel, final Mutex.ExceptionAction act) throws Exception {
        if (FormLAF.noLafSwitching()) {
            return act.run();
        }
        try {
            return Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    Class<Introspector> clazz = Introspector.class;
                    synchronized (Introspector.class) {
                        UIDefaults uIDefaults = UIManager.getDefaults();
                        synchronized (uIDefaults) {
                            Object object;
                            block13: {
                                boolean restoreAfter = true;
                                try {
                                    if (lafBlockEntered) {
                                        restoreAfter = false;
                                    } else {
                                        lafBlockEntered = true;
                                        FormLAF.useDesignerLookAndFeel(formModel);
                                        restoreAfter = true;
                                    }
                                    object = act.run();
                                    if (!restoreAfter) break block13;
                                }
                                catch (Throwable throwable) {
                                    if (restoreAfter) {
                                        FormLAF.useIDELookAndFeel();
                                        lafBlockEntered = false;
                                    }
                                    throw throwable;
                                }
                                FormLAF.useIDELookAndFeel();
                                lafBlockEntered = false;
                            }
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 6] lbl19 : MonitorExitStatement: MONITOREXIT : var2_2
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return object;
                        }
                    }
                }
            });
        }
        catch (MutexException ex) {
            throw ex.getException();
        }
    }

    public static void executeWithLookAndFeel(final FormModel formModel, final Runnable run) {
        if (FormLAF.noLafSwitching()) {
            run.run();
            return;
        }
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Class<Introspector> clazz = Introspector.class;
                synchronized (Introspector.class) {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    synchronized (uIDefaults) {
                        boolean restoreAfter = true;
                        try {
                            if (lafBlockEntered) {
                                restoreAfter = false;
                            } else {
                                lafBlockEntered = true;
                                FormLAF.useDesignerLookAndFeel(formModel);
                                restoreAfter = true;
                            }
                            run.run();
                        }
                        finally {
                            if (restoreAfter) {
                                FormLAF.useIDELookAndFeel();
                                lafBlockEntered = false;
                            }
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeWithLAFLocks(Runnable runnable) {
        if (FormLAF.noLafSwitching()) {
            runnable.run();
            return;
        }
        Class<Introspector> clazz = Introspector.class;
        synchronized (Introspector.class) {
            UIDefaults uIDefaults = UIManager.getDefaults();
            synchronized (uIDefaults) {
                runnable.run();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void useDesignerLookAndFeel(FormModel formModel) {
        if (!initialized) {
            try {
                FormLAF.initialize();
            }
            catch (Exception ex) {
                Logger.getLogger(FormLAF.class.getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
        UIDefaults defaults = UIManager.getDefaults();
        netbeansDefaults.clear();
        FormLAF.copyMultiUIDefaults(defaults, netbeansDefaults);
        netbeansDefaults.keySet().removeAll(userDefaults.keySet());
        defaults.keySet().removeAll(netbeansDefaults.keySet());
        if (!preview) {
            FormLAF.setUseDesignerDefaults(formModel);
        } else if (MetalLookAndFeel.class.isAssignableFrom(previewLaf)) {
            MetalLookAndFeel.setCurrentTheme(lafToTheme.get(previewLaf));
        }
    }

    private static void useIDELookAndFeel() {
        userDefaults.clear();
        FormLAF.copyMultiUIDefaults(UIManager.getDefaults(), userDefaults);
        if (!preview) {
            FormLAF.setUseDesignerDefaults(null);
        } else if (ideLafIsMetal && !FormLAF.isNimbusLAF(previewLaf)) {
            MetalLookAndFeel.setCurrentTheme(lafToTheme.get(UIManager.getLookAndFeel().getClass()));
        }
        UIManager.getDefaults().putAll(netbeansDefaults);
    }

    private static void copyMultiUIDefaults(UIDefaults what, Map where) {
        try {
            Method method = Hashtable.class.getDeclaredMethod("getIterator", Integer.TYPE);
            method.setAccessible(true);
            Object i = method.invoke((Object)what, 2);
            if (i instanceof Iterator) {
                Iterator iter = (Iterator)i;
                while (iter.hasNext()) {
                    Object item = iter.next();
                    if (!(item instanceof Map.Entry)) continue;
                    Map.Entry entry = (Map.Entry)item;
                    where.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(FormLAF.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
    }

    static LayoutStyle getDesignerLayoutStyle() {
        return LayoutStyle.getInstance();
    }

    static void setUseDesignerDefaults(FormModel formModel) {
        if (FormLAF.noLafSwitching() || delDefaults == null) {
            return;
        }
        ClassLoader classLoader = null;
        UIDefaults defaults = UIManager.getDefaults();
        if (formModel == null) {
            UIDefaults newDefaults = new UIDefaults();
            FormLAF.copyMultiUIDefaults(UIManager.getDefaults(), newDefaults);
            newDefaults.keySet().removeAll(lastDefaults.keySet());
            classLoaderDefaults.putAll(newDefaults);
            defaults.putAll(lastDefaults);
        } else {
            FileObject formFile = FormEditor.getFormDataObject(formModel).getFormFile();
            classLoader = ClassPathUtils.getProjectClassLoader(formFile);
            classLoaderDefaults = classLoaderToDefaults.get(classLoader);
            if (classLoaderDefaults == null) {
                classLoaderDefaults = new HashMap<Object, Object>();
                classLoaderToDefaults.put(classLoader, classLoaderDefaults);
            }
            lastDefaults.clear();
            FormLAF.copyMultiUIDefaults(defaults, lastDefaults);
            defaults.putAll(classLoaderDefaults);
        }
        delDefaults.setDelegating(classLoader);
    }

    public static void setUsePreviewDefaults(ClassLoader classLoader, PreviewInfo info) {
        if (FormLAF.noLafSwitching() || delDefaults == null) {
            return;
        }
        boolean classic = info == null ? (previewLaf == null ? false : FormLAF.isClassicWinLAF(previewLaf.getName())) : FormLAF.isClassicWinLAF(info.lafClass.getName());
        preview = classLoader != null;
        Class clazz = previewLaf = info == null ? null : info.lafClass;
        if (preview) {
            if (classic) {
                oldNoXP = System.getProperty(SWING_NOXP);
                System.setProperty(SWING_NOXP, "y");
                FormLAF.invalidateXPStyle();
            }
            if ((classLoaderDefaults = classLoaderToDefaults.get(classLoader)) == null) {
                classLoaderDefaults = new HashMap<Object, Object>();
                classLoaderToDefaults.put(classLoader, classLoaderDefaults);
            }
            HashMap<Object, Object> added = new HashMap<Object, Object>(classLoaderDefaults);
            added.keySet().removeAll(info.defaults.keySet());
            info.defaults.putAll(added);
            delDefaults.setPreviewDefaults(info.defaults);
            if (FormLAF.isNimbusLAF(previewLaf)) {
                origLAF = FormLAF.changeLAFStatesLAF(info.laf);
            }
        } else {
            if (classic) {
                if (oldNoXP == null) {
                    System.getProperties().remove(SWING_NOXP);
                } else {
                    System.setProperty(SWING_NOXP, oldNoXP);
                }
                FormLAF.invalidateXPStyle();
            }
            oldNoXP = null;
            if (origLAF != null) {
                FormLAF.changeLAFStatesLAF(origLAF);
                origLAF = null;
            }
        }
        delDefaults.setPreviewing(classLoader);
    }

    private static Object changeLAFStatesLAF(Object laf) {
        Object value = null;
        try {
            Method method = UIManager.class.getDeclaredMethod("getLAFState", new Class[0]);
            method.setAccessible(true);
            Object lafState = method.invoke(null, new Object[0]);
            Field field = lafState.getClass().getDeclaredField("lookAndFeel");
            field.setAccessible(true);
            value = field.get(lafState);
            field.set(lafState, laf);
        }
        catch (Exception ex) {
            Logger.getLogger(FormLAF.class.getName()).log(Level.INFO, ex.getMessage(), ex);
        }
        return value;
    }

    public static boolean getUsePreviewDefaults() {
        return preview && !delDefaults.isDelegating();
    }

    public static boolean inLAFBlock() {
        return preview || !FormLAF.noLafSwitching() && delDefaults != null && delDefaults.isDelegating();
    }

    public static boolean noLafSwitching() {
        return Boolean.getBoolean(NO_LAF_SWITCHING);
    }

    static {
        netbeansDefaults = new HashMap<Object, Object>();
        userDefaults = new HashMap<Object, Object>();
        lafToTheme = new HashMap<Class, MetalTheme>();
        classLoaderToDefaults = new WeakHashMap<ClassLoader, Map<Object, Object>>();
        lastDefaults = new UIDefaults();
    }

    public static class PreviewInfo {
        Class lafClass;
        UIDefaults defaults;
        LookAndFeel laf;

        PreviewInfo(LookAndFeel laf, UIDefaults defaults) {
            this.laf = laf;
            this.lafClass = laf.getClass();
            this.defaults = defaults;
        }
    }

    static class DelegatingDefaults
    extends UIDefaults {
        private UIDefaults preview;
        private UIDefaults original;
        private UIDefaults ide;
        private boolean delegating;
        private boolean previewing;
        private Map<ClassLoader, UIDefaults> classLoaderToLAFDefaults = new WeakHashMap<ClassLoader, UIDefaults>();
        private UIDefaults classLoaderLAFDefaults;

        DelegatingDefaults(UIDefaults preview, UIDefaults original, UIDefaults ide) {
            this.preview = preview;
            this.original = original;
            this.ide = ide;
        }

        public void setPreviewDefaults(UIDefaults preview) {
            this.preview = preview;
        }

        public void setDelegating(ClassLoader classLoader) {
            this.classLoaderLAFDefaults = this.classLoaderToLAFDefaults.get(classLoader);
            if (this.classLoaderLAFDefaults == null) {
                this.classLoaderLAFDefaults = new UIDefaults();
                this.classLoaderToLAFDefaults.put(classLoader, this.classLoaderLAFDefaults);
            }
            this.delegating = classLoader != null;
        }

        public boolean isDelegating() {
            return this.delegating;
        }

        public void setPreviewing(ClassLoader classLoader) {
            boolean bl = this.previewing = classLoader != null;
            if (this.previewing) {
                this.classLoaderLAFDefaults = this.classLoaderToLAFDefaults.get(classLoader);
                if (this.classLoaderLAFDefaults == null) {
                    this.classLoaderLAFDefaults = new UIDefaults();
                    this.classLoaderToLAFDefaults.put(classLoader, this.classLoaderLAFDefaults);
                }
            }
        }

        public boolean isPreviewing() {
            return this.previewing;
        }

        private UIDefaults getCurrentDefaults() {
            return this.delegating ? this.original : (this.previewing ? this.preview : this.ide);
        }

        @Override
        public Object get(Object key) {
            Object value;
            if (this.delegating) {
                value = this.classLoaderLAFDefaults.get(key);
                if (value == null) {
                    value = this.original.get(key);
                }
            } else if (this.previewing) {
                value = this.classLoaderLAFDefaults.get(key);
                if (value == null) {
                    value = this.preview.get(key);
                }
            } else {
                value = this.ide.get(key);
            }
            return value;
        }

        @Override
        public Set<Object> keySet() {
            Set set;
            if (this.delegating) {
                set = new HashSet(this.classLoaderLAFDefaults.keySet());
                set.addAll(this.original.keySet());
            } else if (this.previewing) {
                set = new HashSet(this.classLoaderLAFDefaults.keySet());
                set.addAll(this.preview.keySet());
            } else {
                set = this.ide.keySet();
            }
            return set;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            Set set;
            if (this.delegating) {
                set = new HashSet(this.classLoaderLAFDefaults.entrySet());
                set.addAll(this.original.entrySet());
            } else if (this.previewing) {
                set = new HashSet(this.classLoaderLAFDefaults.entrySet());
                set.addAll(this.preview.entrySet());
            } else {
                set = this.ide.entrySet();
            }
            return set;
        }

        @Override
        public Object put(Object key, Object value) {
            Object retVal = this.delegating || this.previewing ? this.classLoaderLAFDefaults.put(key, value) : this.ide.put(key, value);
            return retVal;
        }

        @Override
        public void putDefaults(Object[] keyValueList) {
            this.getCurrentDefaults().putDefaults(keyValueList);
        }

        @Override
        public Object get(Object key, Locale l) {
            return this.getCurrentDefaults().get(key, l);
        }

        @Override
        public synchronized void addResourceBundle(String bundleName) {
            this.getCurrentDefaults().addResourceBundle(bundleName);
        }

        @Override
        public synchronized void removeResourceBundle(String bundleName) {
            this.getCurrentDefaults().removeResourceBundle(bundleName);
        }

        @Override
        public void setDefaultLocale(Locale l) {
            this.getCurrentDefaults().setDefaultLocale(l);
        }

        @Override
        public Locale getDefaultLocale() {
            return this.getCurrentDefaults().getDefaultLocale();
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.getCurrentDefaults().addPropertyChangeListener(listener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.getCurrentDefaults().removePropertyChangeListener(listener);
        }

        @Override
        public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
            return this.getCurrentDefaults().getPropertyChangeListeners();
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "FormLAF.firePropertyChange called, but not implemented.");
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return this.getCurrentDefaults().keys();
        }
    }
}

