/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import java.awt.Color;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.swing.UIManager;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.ProcessStatusEx;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer2;
import org.openide.util.NbBundle;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public interface PostMessageDisplayer {
    public String getPostMessage(NativeProcess var1, long var2);

    public String getPostStatusString(NativeProcess var1);

    public String getPostMessage(NativeProcess.State var1, int var2, long var3);

    public static abstract class AbstractDisplayer
    implements PostMessageDisplayer2 {
        private final Default defaultImpl = new Default(null);

        protected AbstractDisplayer(String actionName) {
        }

        @Override
        public void outPostMessage(InputOutput io, NativeProcess process, long time) {
            this.defaultImpl.outPostMessage(io, process, time);
        }

        @Override
        public String getPostMessage(NativeProcess process, long time) {
            return this.defaultImpl.getPostMessage(process, time);
        }

        @Override
        public String getPostStatusString(NativeProcess process) {
            return this.defaultImpl.getPostStatusString(process);
        }

        @Override
        public String getPostMessage(NativeProcess.State state, int rc, long time) {
            return this.defaultImpl.getPostMessage(state, rc, time);
        }

        protected final String formatTime(long millis) {
            return Default.formatTime(millis);
        }

        protected static class Colors {
            protected Colors() {
            }

            protected static Color getColorError(InputOutput io) {
                Color color = IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.ERROR);
                if (color == null && (color = UIManager.getColor("nb.output.err.foreground")) == null) {
                    color = Color.RED;
                }
                return color;
            }

            protected static Color getColorFailure(InputOutput io) {
                Color color = IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_FAILURE);
                if (color == null && (color = UIManager.getColor("nb.output.failure.foreground")) == null) {
                    color = Color.RED.darker();
                }
                return color;
            }

            protected static Color getColorSuccess(InputOutput io) {
                Color color = IOColors.getColor((InputOutput)io, (IOColors.OutputType)IOColors.OutputType.LOG_SUCCESS);
                if (color == null && (color = UIManager.getColor("nb.output.success.foreground")) == null) {
                    color = Color.GREEN.darker().darker();
                }
                return color;
            }

            protected static Color getDefaultColorBackground() {
                Color back = UIManager.getColor("nb.output.backgorund");
                if (back == null) {
                    back = UIManager.getColor("TextField.background");
                    if (back == null) {
                        back = Color.WHITE;
                    } else if (Colors.isNimbus()) {
                        back = new Color(back.getRGB());
                    }
                }
                return back;
            }

            static boolean isNimbus() {
                return "Nimbus".equals(UIManager.getLookAndFeel().getID());
            }
        }
    }

    public static final class Default
    implements PostMessageDisplayer2 {
        private final String actionName;

        public Default(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public String getPostMessage(NativeProcess.State state, int rc, long timeMilliseconds) {
            StringBuilder res = new StringBuilder();
            switch (state) {
                case ERROR: {
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"FAILED", (Object)this.actionName.toUpperCase()));
                    break;
                }
                case CANCELLED: {
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"TERMINATED", (Object)this.actionName.toUpperCase()));
                    break;
                }
                case FINISHED: {
                    if (rc == 0) {
                        res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"SUCCESSFUL", (Object)this.actionName.toUpperCase()));
                        break;
                    }
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"FAILED", (Object)this.actionName.toUpperCase()));
                    break;
                }
            }
            res.append(" (");
            if (rc != 0) {
                res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"EXIT_VALUE", (Object)rc));
                res.append(", ");
            }
            res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"TOTAL_TIME", (Object)Default.formatTime(timeMilliseconds)));
            res.append(')');
            return res.toString();
        }

        @Override
        public String getPostStatusString(NativeProcess process) {
            ProcessStatusEx exitStatusEx = process.getExitStatusEx();
            if (exitStatusEx != null) {
                return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_FINISHED", (Object)this.actionName);
            }
            NativeProcess.State state = process.getState();
            switch (state) {
                case ERROR: {
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_FAILED", (Object)this.actionName);
                }
                case CANCELLED: {
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_TERMINATED", (Object)this.actionName);
                }
                case FINISHED: {
                    if (process.exitValue() == 0) {
                        return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_SUCCESSFUL", (Object)this.actionName);
                    }
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"MSG_FAILED", (Object)this.actionName);
                }
            }
            return "";
        }

        private static String formatTime(long millis) {
            if (millis == 0L) {
                return " 0" + NbBundle.getMessage(PostMessageDisplayer.class, (String)"MILLISECOND");
            }
            StringBuilder res = new StringBuilder();
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            if (hours > 0L) {
                res.append(" ").append(hours).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"HOUR"));
            }
            if (minutes > 0L) {
                res.append(" ").append(minutes - hours * 60L).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"MINUTE"));
            }
            if (seconds > 0L) {
                res.append(" ").append(seconds - minutes * 60L).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"SECOND"));
            } else {
                res.append(" ").append(millis).append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"MILLISECOND"));
            }
            return res.toString();
        }

        @Override
        public String getPostMessage(NativeProcess process, long time) {
            NativeProcess.State state = process.getState();
            StringBuilder res = new StringBuilder();
            ProcessStatusEx statusEx = process.getExitStatusEx();
            int status = process.exitValue();
            if (statusEx != null) {
                if (state == NativeProcess.State.ERROR) {
                    return NbBundle.getMessage(PostMessageDisplayer.class, (String)"FAILED", (Object)this.actionName.toUpperCase());
                }
                res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"FINISHED", (Object)this.actionName.toUpperCase()));
                res.append("; ");
                if (statusEx.ifExited()) {
                    res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"EXIT_VALUE", (Object)statusEx.getExitCode()));
                } else {
                    res.append(statusEx.termSignal());
                    if (statusEx.ifCoreDump()) {
                        res.append("; ");
                        res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"COREDUMPED"));
                    }
                }
                res.append("; ");
                res.append(NbBundle.getMessage(PostMessageDisplayer.class, (String)"TOTAL_TIME_EX", (Object)Default.formatTime(statusEx.realTime(TimeUnit.MILLISECONDS)), (Object)Default.formatTime(statusEx.sysTime(TimeUnit.MILLISECONDS)), (Object)Default.formatTime(statusEx.usrTime(TimeUnit.MILLISECONDS))));
                return res.toString();
            }
            return this.getPostMessage(state, status, time);
        }

        @Override
        public void outPostMessage(InputOutput io, NativeProcess process, long time) {
            Color color = process.getState() == NativeProcess.State.ERROR ? AbstractDisplayer.Colors.getColorError(io) : (process.exitValue() == 0 ? AbstractDisplayer.Colors.getColorSuccess(io) : AbstractDisplayer.Colors.getColorFailure(io));
            try {
                IOColorLines.println((InputOutput)io, (CharSequence)"\r", (Color)Color.BLACK);
                IOColorLines.println((InputOutput)io, (CharSequence)(this.getPostMessage(process, time) + "\r"), (Color)color);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

