/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;

public class ConfigValueCache {
    private final ConcurrentHashMap<String, Object> rootCache = new ConcurrentHashMap();
    private static final String ROOT_KEY_VALUE = "";
    private static final Logger LOG = Logger.getLogger(ConfigValueCache.class.getName());

    public void registerListener(String section, BiConsumer<String, JsonElement> listener) {
        ConfigData configData = this.getCachedConfigData(section);
        if (configData != null) {
            configData.setConsumer(listener);
        } else {
            this.setConfigInTree(section, new ConfigData(listener));
        }
    }

    public JsonElement getConfigValue(String section, String scope) {
        ConfigData configData = this.getCachedConfigData(section);
        if (configData == null) {
            return null;
        }
        if (scope == null) {
            return configData.getRootValue();
        }
        return configData.getScopedValue(scope);
    }

    public void updateCache(NbCodeLanguageClient client, String section, Object cacheValue, JsonElement tree) {
        ConfigData rootData;
        if (tree == null || cacheValue == null) {
            return;
        }
        ConfigValueCache currentCache = null;
        if (this.isConfigDataInstance(cacheValue)) {
            rootData = (ConfigData)cacheValue;
        } else if (this.isConfigValueInstance(cacheValue)) {
            currentCache = (ConfigValueCache)cacheValue;
            rootData = currentCache.getRootCacheValue();
        } else {
            return;
        }
        if (rootData != null) {
            rootData.setRootValue(tree);
            try {
                BiConsumer<String, JsonElement> consumer = rootData.getConsumer();
                if (consumer != null) {
                    consumer.accept(section, tree);
                }
            }
            catch (RuntimeException e) {
                LOG.log(Level.SEVERE, "Exception occurred while calling config change consumer handler, config: {0} and excpetion: {1}", new Object[]{section, e.getMessage()});
            }
            Map<String, JsonElement> scopedValuesMap = rootData.getAllScopedValues();
            if (scopedValuesMap != null && !scopedValuesMap.isEmpty()) {
                ArrayList configs = new ArrayList();
                scopedValuesMap.forEach((key, value) -> {
                    ConfigurationItem item = new ConfigurationItem();
                    item.setScopeUri(key);
                    item.setSection(section);
                    configs.add(item);
                });
                client.configuration(new ConfigurationParams(configs)).thenAccept(results -> {
                    if (results != null) {
                        for (int i = 0; i < results.size(); ++i) {
                            if (results.get(i) == null) continue;
                            String scopeUri = ((ConfigurationItem)configs.get(i)).getScopeUri();
                            rootData.setScopedValue(scopeUri, (JsonElement)results.get(i));
                        }
                    }
                });
            }
        }
        if (currentCache != null && tree.isJsonObject()) {
            if (currentCache.getRootCacheValue() != null) {
                currentCache.getRootCacheValue().setRootValue(tree);
            }
            HashMap entries = new HashMap(tree.getAsJsonObject().asMap());
            for (Map.Entry entry : entries.entrySet()) {
                Object child = currentCache.getCacheData((String)entry.getKey());
                String newSection = section != null ? section + "." + (String)entry.getKey() : (String)entry.getKey();
                this.updateCache(client, newSection, child, (JsonElement)entry.getValue());
            }
        }
    }

    public void cacheConfigValue(String section, JsonElement value, String scope) {
        this.registerCache(section);
        ConfigData configData = this.getCachedConfigData(section);
        if (configData != null) {
            if (scope != null) {
                configData.setScopedValue(scope, value);
            } else {
                configData.setRootValue(value);
            }
        }
    }

    protected void registerCache(String section) {
        ConfigData configData = this.getCachedConfigData(section);
        if (configData == null) {
            this.setConfigInTree(section, new ConfigData());
        }
    }

    protected ConfigData getConfigData(String section) {
        return this.getCachedConfigData(section);
    }

    private ConfigData getCachedConfigData(String section) {
        if (section == null || section.isEmpty()) {
            return null;
        }
        Object current = this;
        String[] parts = section.split("\\.");
        for (int i = 0; i <= parts.length; ++i) {
            if (!this.isConfigValueInstance(current)) {
                return i == parts.length ? (ConfigData)current : null;
            }
            if (i == parts.length) break;
            Object currentCache = current;
            if ((current = ((ConfigValueCache)currentCache).getCacheData(parts[i])) != null) continue;
            return null;
        }
        if (this.isConfigValueInstance(current)) {
            return ((ConfigValueCache)current).getRootCacheValue();
        }
        return this.isConfigDataInstance(current) ? (ConfigData)current : null;
    }

    private Object getCacheData(String section) {
        return this.rootCache.get(section);
    }

    private ConfigData getRootCacheValue() {
        return (ConfigData)this.rootCache.get(ROOT_KEY_VALUE);
    }

    private void setRootCacheValue(ConfigData configData) {
        this.rootCache.put(ROOT_KEY_VALUE, configData);
    }

    private Object put(String section, Object value) {
        return this.rootCache.merge(section, value, (oldValue, newValue) -> {
            if (value == null) {
                return null;
            }
            if (this.isConfigValueInstance(oldValue) && this.isConfigDataInstance(newValue)) {
                ((ConfigValueCache)oldValue).setRootCacheValue((ConfigData)newValue);
                return oldValue;
            }
            if (this.isConfigDataInstance(oldValue) && this.isConfigValueInstance(newValue)) {
                ((ConfigValueCache)newValue).setRootCacheValue((ConfigData)oldValue);
            }
            return newValue;
        });
    }

    private void setConfigInTree(String section, ConfigData configData) {
        if (section == null || section.isEmpty() || configData == null) {
            return;
        }
        Object current = this;
        String[] parts = section.split("\\.");
        for (String part : Arrays.asList(parts).subList(0, parts.length - 1)) {
            if (!this.isConfigValueInstance(current)) {
                return;
            }
            Object child = ((ConfigValueCache)current).getCacheData(part);
            if (this.isConfigValueInstance(child)) {
                current = child;
                continue;
            }
            ConfigValueCache configValueCache = new ConfigValueCache();
            if (child != null) {
                configValueCache.setRootCacheValue((ConfigData)child);
            }
            current = ((ConfigValueCache)current).put(part, configValueCache);
        }
        if (!this.isConfigValueInstance(current)) {
            return;
        }
        ((ConfigValueCache)current).put(parts[parts.length - 1], configData);
    }

    private boolean isConfigValueInstance(Object o) {
        return o instanceof ConfigValueCache;
    }

    private boolean isConfigDataInstance(Object o) {
        return o instanceof ConfigData;
    }

    protected class ConfigData {
        private JsonElement rootValue;
        private BiConsumer<String, JsonElement> consumer;
        private final ConcurrentHashMap<String, JsonElement> scopedValues = new ConcurrentHashMap();

        public ConfigData() {
        }

        public ConfigData(BiConsumer<String, JsonElement> consumer) {
            this(null, consumer);
        }

        public ConfigData(JsonElement value) {
            this(value, null);
        }

        public ConfigData(JsonElement value, BiConsumer<String, JsonElement> consumer) {
            this.rootValue = value;
            this.consumer = consumer;
        }

        public JsonElement getRootValue() {
            return this.rootValue;
        }

        public void setRootValue(JsonElement value) {
            this.rootValue = value;
        }

        public BiConsumer<String, JsonElement> getConsumer() {
            return this.consumer;
        }

        public void setConsumer(BiConsumer<String, JsonElement> consumer) {
            this.consumer = consumer;
        }

        public JsonElement getScopedValue(String fo) {
            return this.scopedValues.get(fo);
        }

        public void setScopedValue(String fo, JsonElement value) {
            this.scopedValues.put(fo, value);
        }

        public Map<String, JsonElement> getAllScopedValues() {
            return Collections.unmodifiableMap(new HashMap<String, JsonElement>(this.scopedValues));
        }
    }
}

