/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.ConfigValueCache;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.Workspace;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class ClientConfigurationManager {
    final ConfigValueCache cache = new ConfigValueCache();
    final NbCodeLanguageClient client;

    public ClientConfigurationManager(NbCodeLanguageClient client) {
        this.client = client;
    }

    public void registerConfigChangeListener(String section, BiConsumer<String, JsonElement> consumer) {
        this.cache.registerListener(section, consumer);
    }

    public CompletableFuture<JsonElement> getConfigurationUsingAltPrefix(String config) {
        return this.lookupCacheAndGetConfig(List.of(config), null, true, true).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfigurationUsingAltPrefix(String config, String scope) {
        return this.lookupCacheAndGetConfig(List.of(config), scope, true, true).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfigurationUsingAltPrefixWithoutCaching(String config) {
        return this.lookupCacheAndGetConfig(List.of(config), null, false, false).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfigurationUsingAltPrefixWithoutCaching(String config, String scope) {
        return this.lookupCacheAndGetConfig(List.of(config), null, false, false).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<List<JsonElement>> getConfigurationsUsingAltPrefix(List<String> configs) {
        return this.lookupCacheAndGetConfig(configs, null, true, true);
    }

    public CompletableFuture<JsonElement> getConfiguration(String config) {
        return this.lookupCacheAndGetConfig(List.of(config), null, false, true).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfigurationWithoutCaching(String config) {
        return this.lookupCacheAndGetConfig(List.of(config), null, false, false).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfigurationWithoutCaching(String config, String scope) {
        return this.lookupCacheAndGetConfig(List.of(config), null, false, false).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<JsonElement> getConfiguration(String config, String scope) {
        return this.lookupCacheAndGetConfig(List.of(config), scope, false, true).thenApply(result -> result.isEmpty() ? null : (JsonElement)result.get(0));
    }

    public CompletableFuture<List<JsonElement>> getConfigurations(List<String> configs) {
        return this.lookupCacheAndGetConfig(configs, null, false, true);
    }

    public CompletableFuture<List<JsonElement>> getConfigurations(List<String> configs, String scope) {
        return this.lookupCacheAndGetConfig(configs, scope, false, true);
    }

    private CompletableFuture<List<JsonElement>> lookupCacheAndGetConfig(List<String> configs, String scope, boolean isAltPrefix, boolean isCachingRequired) {
        String configPrefix = isAltPrefix ? this.client.getNbCodeCapabilities().getAltConfigurationPrefix() : this.client.getNbCodeCapabilities().getConfigurationPrefix();
        ArrayList<ConfigurationItem> itemsToRequest = new ArrayList<ConfigurationItem>();
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        String prjScope = this.getProjectFromFileScope(scope);
        for (int i = 0; i < configs.size(); ++i) {
            String config = configs.get(i);
            String prefixedConfig = configPrefix + config;
            JsonElement cachedValue = this.cache.getConfigValue(prefixedConfig, prjScope);
            if (cachedValue != null) {
                result.add(cachedValue);
                continue;
            }
            ConfigurationItem item = new ConfigurationItem();
            if (scope != null) {
                item.setScopeUri(scope);
            }
            item.setSection(prefixedConfig);
            itemsToRequest.add(item);
            result.add(null);
        }
        if (itemsToRequest.isEmpty()) {
            return CompletableFuture.completedFuture(result);
        }
        return this.client.configuration(new ConfigurationParams(itemsToRequest)).thenApply(clientConfigs -> {
            if (clientConfigs != null && clientConfigs.size() == result.size()) {
                int j = 0;
                for (int i = 0; i < result.size(); ++i) {
                    if (result.get(i) != null) continue;
                    JsonElement value = (JsonElement)clientConfigs.get(j);
                    result.set(i, value);
                    String prefixedConfig = configPrefix + (String)configs.get(i);
                    if (isCachingRequired) {
                        this.cache.cacheConfigValue(prefixedConfig, value, prjScope);
                    }
                    ++j;
                }
            } else {
                for (int i = 0; i < result.size(); ++i) {
                    if (result.get(i) != null) continue;
                    result.set(i, (JsonElement)new JsonObject());
                }
            }
            return result;
        });
    }

    public void handleConfigurationChange(JsonObject settings) {
        this.cache.updateCache(this.client, null, this.cache, (JsonElement)settings);
    }

    private String getProjectFromFileScope(String scope) {
        try {
            if (scope == null) {
                return null;
            }
            FileObject fo = Utils.fromUri(scope);
            if (fo == null) {
                return null;
            }
            Project prj = FileOwnerQuery.getOwner((FileObject)fo);
            if (prj == null) {
                return this.findWorkspaceFolder(fo);
            }
            return Utils.toUri(prj.getProjectDirectory());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String findWorkspaceFolder(FileObject file) {
        Workspace workspace = (Workspace)Lookup.getDefault().lookup(Workspace.class);
        if (workspace == null) {
            return null;
        }
        for (FileObject workspaceFolder : workspace.getClientWorkspaceFolders()) {
            if (!FileUtil.isParentOf((FileObject)workspaceFolder, (FileObject)file) && workspaceFolder != file) continue;
            return Utils.toUri(workspaceFolder);
        }
        for (FileObject workspaceFolder : workspace.getClientWorkspaceFolders()) {
            if (!FileUtil.isParentOf((FileObject)file, (FileObject)workspaceFolder)) continue;
            return Utils.toUri(workspaceFolder);
        }
        return null;
    }
}

