/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.apisupport.project.api.BasicWizardPanel;
import org.netbeans.modules.apisupport.project.ui.platform.Bundle;
import org.netbeans.modules.apisupport.project.ui.platform.HarnessUpgrader;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerHarness;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerJavadoc;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerModules;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizerSources;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformChooserWizardPanel;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformInfoWizardPanel;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class NbPlatformCustomizer
extends JPanel {
    static final String CHOOSER_STEP = Bundle.MSG_ChoosePlatform();
    static final String INFO_STEP = Bundle.MSG_PlatformName();
    static final String PLAF_DIR_PROPERTY = "selectedPlafDir";
    static final String PLAF_LABEL_PROPERTY = "selectedPlafLabel";
    private NbPlatformCustomizerSources sourcesTab;
    private NbPlatformCustomizerModules modulesTab;
    private NbPlatformCustomizerJavadoc javadocTab;
    private NbPlatformCustomizerHarness harnessTab;
    private JButton addButton;
    private JTabbedPane detailPane;
    private JPanel infoPane;
    private JLabel pflFolder;
    private JLabel platformLbl;
    private JList platformsList;
    private JScrollPane platformsListSP;
    private JTextField plfFolderValue;
    private JLabel plfName;
    private JTextField plfNameValue;
    private JButton removeButton;

    public static ActionListener showCustomizerAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NbPlatformCustomizer.showCustomizer();
            }
        };
    }

    public static Object showCustomizer() {
        AtomicBoolean canceled = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HarnessUpgrader.checkForUpgrade();
            }
        }, (String)Bundle.PROGRESS_checking_for_upgrade(), (AtomicBoolean)canceled, (boolean)false);
        NbPlatformCustomizer customizer = new NbPlatformCustomizer();
        JButton closeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)Bundle.CTL_Close());
        DialogDescriptor descriptor = new DialogDescriptor((Object)customizer, Bundle.CTL_NbPlatformManager_Title(), true, new Object[]{closeButton}, (Object)closeButton, 0, new HelpCtx("org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer"), null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.setVisible(true);
        dlg.dispose();
        return customizer.getSelectedNbPlatform();
    }

    private NbPlatformCustomizer() {
        this.initComponents();
        this.initTabs();
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NbPlatformCustomizer.this.refreshPlatform();
            }
        });
        this.refreshPlatform();
    }

    private void initTabs() {
        if (this.platformsList.getModel().getSize() > 0) {
            this.platformsList.setSelectedIndex(0);
            this.sourcesTab = new NbPlatformCustomizerSources();
            this.modulesTab = new NbPlatformCustomizerModules();
            this.javadocTab = new NbPlatformCustomizerJavadoc();
            this.harnessTab = new NbPlatformCustomizerHarness();
            this.detailPane.addTab(Bundle.CTL_ModulesTab(), this.modulesTab);
            this.detailPane.addTab(Bundle.CTL_SourcesTab(), this.sourcesTab);
            this.detailPane.addTab(Bundle.CTL_JavadocTab(), this.javadocTab);
            this.detailPane.addTab(Bundle.CTL_HarnessTab(), this.harnessTab);
            Container window = this.getTopLevelAncestor();
            if (window instanceof Window) {
                ((Window)window).pack();
            }
        }
    }

    private void refreshPlatform() {
        NbPlatform plaf = (NbPlatform)this.platformsList.getSelectedValue();
        if (plaf == null) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.plfNameValue.setText(NbPlatform.getComputedLabel(plaf.getDestDir()));
        this.plfNameValue.setCaretPosition(0);
        this.plfFolderValue.setText(plaf.getDestDir().getAbsolutePath());
        this.plfFolderValue.setCaretPosition(this.plfFolderValue.getText().length());
        boolean isValid = plaf.isValid();
        if (isValid) {
            if (this.sourcesTab == null) {
                this.initTabs();
            }
            if (this.sourcesTab != null) {
                this.modulesTab.setPlatform(plaf);
                this.sourcesTab.setSourceRootsProvider(plaf);
                this.javadocTab.setJavadocRootsProvider(plaf);
                this.harnessTab.setPlatform(plaf);
            }
        } else {
            this.modulesTab.reset();
            this.detailPane.setSelectedIndex(0);
        }
        this.detailPane.setEnabledAt(0, isValid);
        this.detailPane.setEnabledAt(1, isValid);
        this.detailPane.setEnabledAt(2, isValid);
        this.removeButton.setEnabled(!plaf.isDefault());
    }

    private void initComponents() {
        this.platformLbl = new JLabel();
        this.platformsListSP = new JScrollPane();
        this.platformsList = PlatformComponentFactory.getNbPlatformsList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.infoPane = new JPanel();
        this.plfName = new JLabel();
        this.pflFolder = new JLabel();
        this.plfNameValue = new JTextField();
        this.plfFolderValue = new JTextField();
        this.detailPane = new JTabbedPane();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.platformLbl.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.platformLbl, (String)NbBundle.getMessage(NbPlatformCustomizer.class, (String)"LBL_Platforms"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.platformLbl, gridBagConstraints);
        this.platformsList.setSelectionMode(0);
        this.platformsListSP.setViewportView(this.platformsList);
        this.platformsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_CTL_platformsList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 12, 6);
        this.add((Component)this.platformsListSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(NbPlatformCustomizer.class, (String)"CTL_AddPlatform"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizer.this.addPlatform(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_CTL_addButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(NbPlatformCustomizer.class, (String)"CTL_RemovePlatfrom"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizer.this.removePlatform(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_CTL_removeButton"));
        this.infoPane.setLayout(new GridBagLayout());
        this.plfName.setLabelFor(this.plfNameValue);
        Mnemonics.setLocalizedText((JLabel)this.plfName, (String)NbBundle.getMessage(NbPlatformCustomizer.class, (String)"LBL_PlatformName_N"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.infoPane.add((Component)this.plfName, gridBagConstraints);
        this.pflFolder.setLabelFor(this.plfFolderValue);
        Mnemonics.setLocalizedText((JLabel)this.pflFolder, (String)NbBundle.getMessage(NbPlatformCustomizer.class, (String)"LBL_PlatformFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.infoPane.add((Component)this.pflFolder, gridBagConstraints);
        this.plfNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.infoPane.add((Component)this.plfNameValue, gridBagConstraints);
        this.plfNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_CTL_plfNameValue"));
        this.plfFolderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.infoPane.add((Component)this.plfFolderValue, gridBagConstraints);
        this.plfFolderValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_CTL_plfFolderValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.infoPane.add((Component)this.detailPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 12, 0);
        this.add((Component)this.infoPane, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NbPlatformCustomizer.class, (String)"ACS_NbPlatformCustomizer"));
    }

    private PlatformComponentFactory.NbPlatformListModel getPlafListModel() {
        return (PlatformComponentFactory.NbPlatformListModel)this.platformsList.getModel();
    }

    private void removePlatform(ActionEvent evt) {
        NbPlatform plaf = (NbPlatform)this.platformsList.getSelectedValue();
        if (plaf != null) {
            this.getPlafListModel().removePlatform(plaf);
            this.platformsList.setSelectedValue(NbPlatform.getDefaultPlatform(), true);
            this.refreshPlatform();
        }
    }

    private void addPlatform(ActionEvent evt) {
        PlatformChooserWizardPanel chooser = new PlatformChooserWizardPanel(null);
        PlatformInfoWizardPanel info = new PlatformInfoWizardPanel(null);
        WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Panel[])new BasicWizardPanel[]{chooser, info});
        this.initPanel(chooser, wd, 0);
        this.initPanel(info, wd, 1);
        wd.setTitleFormat(new MessageFormat("{0}"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
        dialog.setTitle(Bundle.CTL_AddNetbeansPlatformTitle());
        dialog.setVisible(true);
        dialog.toFront();
        if (wd.getValue() == WizardDescriptor.FINISH_OPTION) {
            String plafDir = (String)wd.getProperty(PLAF_DIR_PROPERTY);
            String plafLabel = (String)wd.getProperty(PLAF_LABEL_PROPERTY);
            String id = plafLabel.replace(' ', '_');
            NbPlatform plaf = this.getPlafListModel().addPlatform(id, plafDir, plafLabel);
            if (plaf != null) {
                this.platformsList.setSelectedValue(plaf, true);
                this.refreshPlatform();
            }
        }
    }

    private void initPanel(BasicWizardPanel panel, WizardDescriptor wd, int i) {
        panel.setSettings(wd);
        JComponent jc = (JComponent)panel.getComponent();
        jc.putClientProperty("WizardPanel_autoWizardStyle", true);
        jc.putClientProperty("WizardPanel_contentDisplayed", true);
        jc.putClientProperty("WizardPanel_contentNumbered", true);
        jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
        jc.putClientProperty("WizardPanel_contentData", new String[]{CHOOSER_STEP, INFO_STEP});
    }

    private Object getSelectedNbPlatform() {
        return this.platformsList.getSelectedValue();
    }
}

