/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.env;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.MIMEResolver;

public class EnvFileResolver
extends MIMEResolver {
    public static final String ENV_EXT = "env";
    public static final String MIME_TYPE = "text/x-env";

    public EnvFileResolver() {
        super(new String[]{MIME_TYPE});
    }

    @CheckForNull
    public String findMIMEType(@NonNull FileObject fo) {
        String nameWithExt = fo.getNameExt().toLowerCase();
        if (nameWithExt.endsWith(".env")) {
            return MIME_TYPE;
        }
        int envPartPosition = 2;
        String[] nameParts = nameWithExt.split("\\.");
        if (nameParts.length >= envPartPosition && nameParts[nameParts.length - envPartPosition].equals(ENV_EXT)) {
            return MIME_TYPE;
        }
        return null;
    }
}

