/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDatabaseRequest
extends BmcRequest<UpdateDatabaseDetails> {
    private String databaseId;
    private UpdateDatabaseDetails updateDatabaseDetails;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public UpdateDatabaseDetails getUpdateDatabaseDetails() {
        return this.updateDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDatabaseDetails getBody$() {
        return this.updateDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).updateDatabaseDetails(this.updateDatabaseDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",updateDatabaseDetails=").append(String.valueOf((Object)this.updateDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDatabaseRequest)) {
            return false;
        }
        UpdateDatabaseRequest other = (UpdateDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals((Object)this.updateDatabaseDetails, (Object)other.updateDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.updateDatabaseDetails == null ? 43 : this.updateDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDatabaseRequest, UpdateDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private UpdateDatabaseDetails updateDatabaseDetails = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder updateDatabaseDetails(UpdateDatabaseDetails updateDatabaseDetails) {
            this.updateDatabaseDetails = updateDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDatabaseRequest o) {
            this.databaseId(o.getDatabaseId());
            this.updateDatabaseDetails(o.getUpdateDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDatabaseRequest build() {
            UpdateDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDatabaseDetails body) {
            this.updateDatabaseDetails(body);
            return this;
        }

        public UpdateDatabaseRequest buildWithoutInvocationCallback() {
            UpdateDatabaseRequest request = new UpdateDatabaseRequest();
            request.databaseId = this.databaseId;
            request.updateDatabaseDetails = this.updateDatabaseDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

