/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AutonomousDbPreviewVersionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="timePreviewBegin")
    private final Date timePreviewBegin;
    @JsonProperty(value="timePreviewEnd")
    private final Date timePreviewEnd;
    @JsonProperty(value="dbWorkload")
    private final DbWorkload dbWorkload;
    @JsonProperty(value="details")
    private final String details;

    @Deprecated
    @ConstructorProperties(value={"version", "timePreviewBegin", "timePreviewEnd", "dbWorkload", "details"})
    public AutonomousDbPreviewVersionSummary(String version, Date timePreviewBegin, Date timePreviewEnd, DbWorkload dbWorkload, String details) {
        this.version = version;
        this.timePreviewBegin = timePreviewBegin;
        this.timePreviewEnd = timePreviewEnd;
        this.dbWorkload = dbWorkload;
        this.details = details;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public Date getTimePreviewBegin() {
        return this.timePreviewBegin;
    }

    public Date getTimePreviewEnd() {
        return this.timePreviewEnd;
    }

    public DbWorkload getDbWorkload() {
        return this.dbWorkload;
    }

    public String getDetails() {
        return this.details;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AutonomousDbPreviewVersionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", timePreviewBegin=").append(String.valueOf(this.timePreviewBegin));
        sb.append(", timePreviewEnd=").append(String.valueOf(this.timePreviewEnd));
        sb.append(", dbWorkload=").append(String.valueOf((Object)this.dbWorkload));
        sb.append(", details=").append(String.valueOf(this.details));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AutonomousDbPreviewVersionSummary)) {
            return false;
        }
        AutonomousDbPreviewVersionSummary other = (AutonomousDbPreviewVersionSummary)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.timePreviewBegin, other.timePreviewBegin) && Objects.equals(this.timePreviewEnd, other.timePreviewEnd) && Objects.equals((Object)this.dbWorkload, (Object)other.dbWorkload) && Objects.equals(this.details, other.details) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.timePreviewBegin == null ? 43 : this.timePreviewBegin.hashCode());
        result = result * 59 + (this.timePreviewEnd == null ? 43 : this.timePreviewEnd.hashCode());
        result = result * 59 + (this.dbWorkload == null ? 43 : this.dbWorkload.hashCode());
        result = result * 59 + (this.details == null ? 43 : this.details.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DbWorkload implements BmcEnum
    {
        Oltp("OLTP"),
        Dw("DW"),
        Ajd("AJD"),
        Apex("APEX"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DbWorkload> map;

        private DbWorkload(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DbWorkload create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DbWorkload', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DbWorkload.class);
            map = new HashMap<String, DbWorkload>();
            for (DbWorkload v : DbWorkload.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="timePreviewBegin")
        private Date timePreviewBegin;
        @JsonProperty(value="timePreviewEnd")
        private Date timePreviewEnd;
        @JsonProperty(value="dbWorkload")
        private DbWorkload dbWorkload;
        @JsonProperty(value="details")
        private String details;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder timePreviewBegin(Date timePreviewBegin) {
            this.timePreviewBegin = timePreviewBegin;
            this.__explicitlySet__.add("timePreviewBegin");
            return this;
        }

        public Builder timePreviewEnd(Date timePreviewEnd) {
            this.timePreviewEnd = timePreviewEnd;
            this.__explicitlySet__.add("timePreviewEnd");
            return this;
        }

        public Builder dbWorkload(DbWorkload dbWorkload) {
            this.dbWorkload = dbWorkload;
            this.__explicitlySet__.add("dbWorkload");
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            this.__explicitlySet__.add("details");
            return this;
        }

        public AutonomousDbPreviewVersionSummary build() {
            AutonomousDbPreviewVersionSummary model = new AutonomousDbPreviewVersionSummary(this.version, this.timePreviewBegin, this.timePreviewEnd, this.dbWorkload, this.details);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AutonomousDbPreviewVersionSummary model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("timePreviewBegin")) {
                this.timePreviewBegin(model.getTimePreviewBegin());
            }
            if (model.wasPropertyExplicitlySet("timePreviewEnd")) {
                this.timePreviewEnd(model.getTimePreviewEnd());
            }
            if (model.wasPropertyExplicitlySet("dbWorkload")) {
                this.dbWorkload(model.getDbWorkload());
            }
            if (model.wasPropertyExplicitlySet("details")) {
                this.details(model.getDetails());
            }
            return this;
        }
    }
}

