/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.restriction;

import jakarta.persistence.criteria.FetchParent;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.query.range.Range;
import org.hibernate.query.restriction.NamedPathElement;
import org.hibernate.query.restriction.PathElement;
import org.hibernate.query.restriction.PathRange;
import org.hibernate.query.restriction.PathRoot;
import org.hibernate.query.restriction.Restriction;

@Incubating
public interface Path<X, U> {
    public jakarta.persistence.criteria.Path<U> path(Root<? extends X> var1);

    public Class<U> getType();

    default public <V> Path<X, V> to(SingularAttribute<? super U, V> attribute) {
        return new PathElement(this, attribute);
    }

    default public <V> Path<X, V> to(String attributeName, Class<V> attributeType) {
        return new NamedPathElement(this, attributeName, attributeType);
    }

    public static <X> Path<X, X> from(Class<X> type) {
        return new PathRoot<X>(type);
    }

    default public Restriction<X> restrict(Range<? super U> range) {
        return new PathRange(this, range);
    }

    default public Restriction<X> equalTo(U value) {
        return this.restrict(Range.singleValue(value));
    }

    default public Restriction<X> notEqualTo(U value) {
        return this.equalTo(value).negated();
    }

    default public Restriction<X> in(List<U> values) {
        return this.restrict(Range.valueList(values));
    }

    default public Restriction<X> notIn(List<U> values) {
        return this.in(values).negated();
    }

    default public Restriction<X> notNull() {
        return this.restrict(Range.notNull(this.getType()));
    }

    public FetchParent<?, ? extends U> fetch(Root<? extends X> var1);
}

