/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public class OptionRenderer
implements CommandLine.Help.IOptionRenderer {
    private static final String OPTION_NAME_SEPARATOR = ", ";
    private static final CommandLine.Help.Ansi.Text EMPTY_TEXT = CommandLine.Help.Ansi.OFF.text("");

    public CommandLine.Help.Ansi.Text[][] render(CommandLine.Model.OptionSpec option, CommandLine.Help.IParamLabelRenderer paramLabelRenderer, CommandLine.Help.ColorScheme scheme) {
        String[] names = option.names();
        if (names.length > 2) {
            throw new CommandLine.PicocliException("Options should have 2 names at most.");
        }
        CommandLine.Help.Ansi.Text shortName = names.length > 1 ? scheme.optionText(names[0]) : EMPTY_TEXT;
        CommandLine.Help.Ansi.Text longName = this.createLongName(option, scheme);
        CommandLine.Help.Ansi.Text[][] result = new CommandLine.Help.Ansi.Text[1][];
        CommandLine.Help.Ansi.Text description = scheme.text(option.description()[0]);
        if (option.description().length > 1) {
            throw new CommandLine.PicocliException("Option[" + String.valueOf(option) + "] description should have a single line.");
        }
        result[0] = EMPTY_TEXT.equals((Object)shortName) ? new CommandLine.Help.Ansi.Text[]{longName, description} : new CommandLine.Help.Ansi.Text[]{shortName.concat(OPTION_NAME_SEPARATOR).concat(longName), description};
        return result;
    }

    private CommandLine.Help.Ansi.Text createLongName(CommandLine.Model.OptionSpec option, CommandLine.Help.ColorScheme scheme) {
        String longestName = option.longestName();
        CommandLine.Help.Ansi.Text name = scheme.optionText(longestName);
        String paramLabel = this.formatParamLabel(option);
        if (StringUtil.isNotBlank((String)paramLabel) && !"none".equals(paramLabel) && !option.usageHelp() && !option.versionHelp()) {
            name = name.concat(" ").concat(paramLabel);
        }
        return name;
    }

    private String formatParamLabel(CommandLine.Model.OptionSpec option) {
        String label = option.paramLabel();
        if (label.startsWith("<") || "none".equals(label)) {
            return label;
        }
        return "<" + label + ">";
    }
}

