/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.resource;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Objects;

public final class URLResource
extends Resource {
    private final URLConnection connection;

    public URLResource(String pathName, URL url) throws IOException {
        this(pathName, url.openConnection());
    }

    public URLResource(String pathName, URLConnection connection) {
        super(pathName);
        if (connection instanceof JarURLConnection) {
            JarURLConnection j = (JarURLConnection)connection;
            j.setUseCaches(false);
        }
        this.connection = (URLConnection)Assert.checkNotNullParam((String)"connection", (Object)connection);
    }

    public URLResource(JarURLConnection jarConnection) {
        this(Objects.requireNonNullElse(jarConnection.getEntryName(), ""), jarConnection);
    }

    @Override
    public URL url() {
        return this.connection.getURL();
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public Instant modifiedTime() {
        long lastModified = this.connection.getLastModified();
        return lastModified == 0L ? null : Instant.ofEpochMilli(lastModified);
    }

    @Override
    public long size() {
        return this.connection.getContentLengthLong();
    }
}

