/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.kawa.format.AbstractFormat;
import gnu.kawa.functions.Apply;
import gnu.kawa.functions.ApplyToArgs;
import gnu.kawa.functions.DisplayFormat;
import gnu.kawa.functions.IsEq;
import gnu.kawa.functions.IsEqual;
import gnu.kawa.functions.IsEqv;
import gnu.kawa.functions.Map;
import gnu.kawa.functions.Not;
import gnu.kawa.functions.NumberCompare;
import gnu.kawa.functions.NumberPredicate;
import gnu.kawa.io.CharArrayInPort;
import gnu.kawa.io.InPort;
import gnu.kawa.lispexpr.GenArrayType;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReaderDispatch;
import gnu.kawa.lispexpr.ReaderDispatchSyntaxQuote;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.kawa.lispexpr.ReaderQuote;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.LazyType;
import gnu.kawa.reflect.MultValuesType;
import gnu.kawa.servlet.HttpRequestContext;
import gnu.mapping.Environment;
import gnu.mapping.Namespace;
import gnu.mapping.SimpleEnvironment;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import kawa.lang.Eval;

public class Scheme
extends LispLanguage {
    public static final int FOLLOW_R5RS = 5;
    public static final int FOLLOW_R6RS = 6;
    public static final int FOLLOW_R7RS = 7;
    int standardToFollow;
    private static Environment r5Environment;
    protected static final SimpleEnvironment kawaEnvironment;
    public static final Scheme instance;
    private static Scheme r5rsInstance;
    private static Scheme r6rsInstance;
    private static Scheme r7rsInstance;
    public static final LangPrimType booleanType;
    public static final ApplyToArgs applyToArgs;
    public static final Apply apply;
    public static final InstanceOf instanceOf;
    public static final Not not;
    public static final IsEq isEq;
    public static final IsEqv isEqv;
    public static final IsEqual isEqual;
    public static final Map map;
    public static final Map forEach;
    public static final NumberCompare numEqu;
    public static final NumberCompare numGrt;
    public static final NumberCompare numGEq;
    public static final NumberCompare numLss;
    public static final NumberCompare numLEq;
    public static final NumberPredicate isOdd;
    public static final NumberPredicate isEven;
    private static final String[] uniformVectorTags;
    public static final String emptyStringLeft;
    public static final String emptyStringRight;
    static Environment stdEnvironment;
    private HashMap<String, Type> types;
    private HashMap<Type, String> typeToStringMap;

    public int getStandardToFollow() {
        return this.standardToFollow;
    }

    public static Scheme getInstance() {
        return instance;
    }

    private static Scheme newStandardInstance(int standardToFollow) {
        Scheme instance = new Scheme(Scheme.getStdEnvironment());
        instance.standardToFollow = standardToFollow;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception loadClass(String path, Environment env) {
        Environment saveEnv = Environment.setSaveCurrent(env);
        try {
            instance.loadClass(path);
        }
        catch (ClassNotFoundException ex) {
            ClassNotFoundException classNotFoundException = ex;
            return classNotFoundException;
        }
        finally {
            Environment.restoreCurrent(saveEnv);
        }
        return null;
    }

    public static synchronized Environment getR5rsEnvironment() {
        Exception ex;
        if (r5Environment == null && (ex = Scheme.loadClass("kawa.lib.scheme.r5rs", r5Environment = Environment.make("r5rs-environment"))) != null) {
            throw new RuntimeException(ex);
        }
        return r5Environment;
    }

    public static synchronized Environment getStdEnvironment() {
        if (stdEnvironment == null) {
            stdEnvironment = Environment.make("standard-environment");
            Exception ex = Scheme.loadClass("kawa.lib.kawa.base", stdEnvironment);
            if (ex == null) {
                ex = Scheme.loadClass("kawa.lib.kawa.mstrings", stdEnvironment);
            }
            if (ex != null) {
                throw new RuntimeException(ex);
            }
            stdEnvironment.setLocked();
        }
        return stdEnvironment;
    }

    public static synchronized Scheme getR5rsInstance() {
        if (r5rsInstance == null) {
            r5rsInstance = Scheme.newStandardInstance(5);
        }
        return r5rsInstance;
    }

    public static synchronized Scheme getR6rsInstance() {
        if (r6rsInstance == null) {
            r6rsInstance = Scheme.newStandardInstance(6);
        }
        return r6rsInstance;
    }

    public static synchronized Scheme getR7rsInstance() {
        if (r7rsInstance == null) {
            r7rsInstance = Scheme.newStandardInstance(7);
        }
        return r7rsInstance;
    }

    public static Environment builtin() {
        return kawaEnvironment;
    }

    private void initScheme() {
        this.environ = kawaEnvironment;
        Environment saveEnv = Environment.setSaveCurrent(kawaEnvironment);
        try {
            this.loadClass("kawa.lib.kawa.base");
        }
        catch (ClassNotFoundException ex) {
            this.defAliasStFld("$construct$", "gnu.kawa.lispexpr.LispLanguage", "constructNamespace");
            this.defSntxStFld("object", "kawa.standard.object", "objectSyntax");
            this.defSntxStFld("module-export", "kawa.standard.export", "module_export");
            this.defSntxStFld("module-name", "kawa.standard.module_name", "module_name");
            this.defSntxStFld("export", "kawa.standard.export", "export");
            this.defSntxStFld("import", "kawa.standard.ImportFromLibrary", "instance");
            this.defSntxStFld("require", "kawa.standard.require", "require");
            this.defSntxStFld("include", "kawa.standard.Include", "include");
        }
        finally {
            Environment.restoreCurrent(saveEnv);
        }
        kawaEnvironment.setLocked();
        int withServlets = HttpRequestContext.importServletDefinitions;
        if (withServlets > 0) {
            try {
                this.loadClass(withServlets > 1 ? "gnu.kawa.servlet.servlets" : "gnu.kawa.servlet.HTTP");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Scheme() {
        this.environ = kawaEnvironment;
        this.userEnv = this.getNewEnvironment();
    }

    protected Scheme(Environment env) {
        this.environ = env;
    }

    @Override
    public String getName() {
        switch (this.standardToFollow) {
            case 5: {
                return "Scheme-r5rs";
            }
            case 6: {
                return "Scheme-r6rs";
            }
            case 7: {
                return "Scheme-r7rs";
            }
        }
        return "Scheme";
    }

    @Override
    public String getCompilationClass() {
        return "kawa.standard.SchemeCompilation";
    }

    public static Object eval(String string, Environment env) {
        return Scheme.eval(new CharArrayInPort(string), env);
    }

    public static Object eval(InPort port, Environment env) {
        SourceMessages messages = new SourceMessages();
        try {
            LispReader lexer = (LispReader)Language.getDefaultLanguage().getLexer(port, messages);
            Object body = ReaderParens.readList(lexer, null, 0, 1, -1, -1);
            if (messages.seenErrors()) {
                throw new SyntaxException(messages);
            }
            return Eval.evalBody(body, env, messages);
        }
        catch (SyntaxException e) {
            throw new RuntimeException("eval: errors while compiling:\n" + e.getMessages().toString(20));
        }
        catch (IOException e) {
            throw new RuntimeException("eval: I/O exception: " + e.toString());
        }
        catch (Throwable ex) {
            throw WrappedException.rethrow(ex);
        }
    }

    public static Object eval(Object sexpr, Environment env) {
        try {
            return Eval.eval(sexpr, env);
        }
        catch (Throwable ex) {
            throw WrappedException.rethrow(ex);
        }
    }

    @Override
    public AbstractFormat getFormat(boolean readable) {
        return readable ? DisplayFormat.schemeWriteFormat : DisplayFormat.schemeDisplayFormat;
    }

    @Override
    public LispReader getLexer(InPort inp, SourceMessages messages) {
        LispReader reader = super.getLexer(inp, messages);
        if (reader.getReadCase() == '\u0000' && this.standardToFollow == 5) {
            reader.setReadCase('D');
        }
        return reader;
    }

    @Override
    public int getNamespaceOf(Declaration decl) {
        return 3;
    }

    public static Type getTypeValue(Expression exp) {
        return Scheme.getInstance().getTypeFor(exp);
    }

    @Override
    protected synchronized HashMap<String, Type> getTypeMap() {
        if (this.types == null) {
            this.types = new HashMap(128);
            this.types.put("boolean", booleanType);
            this.types.put("parameter", Compilation.typeLocationProc);
            this.types.putAll(super.getTypeMap());
            int i = uniformVectorTags.length;
            while (--i >= 0) {
                String tag = uniformVectorTags[i];
                String cname = "gnu.lists." + tag.toUpperCase() + "Vector";
                this.types.put(tag + "vector", ClassType.make(cname));
            }
        }
        return this.types;
    }

    @Override
    public String formatType(Type type) {
        String str;
        if (type instanceof LazyType) {
            LazyType ltype = (LazyType)type;
            return this.formatType(ltype.getRawType()) + "[" + this.formatType(ltype.getValueType()) + "]";
        }
        if (type instanceof MultValuesType) {
            MultValuesType mtype = (MultValuesType)type;
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("values[");
            int n = mtype.getValueCount();
            for (int i = 0; i < n; ++i) {
                Type etype;
                if (i > 0) {
                    sbuf.append(' ');
                }
                sbuf.append((etype = mtype.getValueType(i)) == null ? "unspecified" : this.formatType(etype));
            }
            sbuf.append(']');
            return sbuf.toString();
        }
        if (type instanceof GenArrayType) {
            Type elementType;
            GenArrayType atype = (GenArrayType)type;
            StringBuilder sbuf = new StringBuilder("array");
            int rank = atype.rank();
            if (rank >= 0) {
                sbuf.append(rank);
            }
            if ((elementType = atype.getComponentType()) != null && elementType != Type.objectType) {
                sbuf.append('[');
                sbuf.append(this.formatType(elementType));
                sbuf.append(']');
            }
            return sbuf.toString();
        }
        if (this.typeToStringMap == null) {
            this.typeToStringMap = new HashMap();
            for (Map.Entry<String, Type> e : this.getTypeMap().entrySet()) {
                this.typeToStringMap.put(e.getValue(), e.getKey());
            }
        }
        if ((str = this.typeToStringMap.get(type)) != null) {
            return str;
        }
        return super.formatType(type);
    }

    public static Type exp2Type(Expression exp) {
        return Scheme.getInstance().getTypeFor(exp);
    }

    public Symbol asSymbol(String ident) {
        return Namespace.EmptyNamespace.getSymbol(ident);
    }

    public boolean appendBodyValues() {
        return false;
    }

    @Override
    public boolean keywordsAreSelfEvaluating() {
        return false;
    }

    @Override
    public ReadTable createReadTable() {
        ReadTable tab = ReadTable.createInitial();
        int std = this.standardToFollow;
        ReaderDispatch dispatchTable = (ReaderDispatch)tab.lookup(35);
        ReaderDispatchSyntaxQuote sentry = new ReaderDispatchSyntaxQuote();
        dispatchTable.set(39, sentry);
        dispatchTable.set(96, sentry);
        dispatchTable.set(44, sentry);
        tab.putReaderCtorFld("path", "gnu.kawa.lispexpr.LangObjType", "pathType");
        tab.putReaderCtorFld("filepath", "gnu.kawa.lispexpr.LangObjType", "filepathType");
        tab.putReaderCtorFld("URI", "gnu.kawa.lispexpr.LangObjType", "URIType");
        tab.putReaderCtor("symbol", ClassType.make("gnu.mapping.Symbol"));
        tab.putReaderCtor("namespace", ClassType.make("gnu.mapping.Namespace"));
        tab.putReaderCtorFld("duration", "kawa.lib.numbers", "duration");
        if (std != 5 && std != 6 && std != 7) {
            tab.postfixLookupOperator = (char)58;
            tab.setFinalColonIsKeyword(true);
            tab.extraFlags = 8;
            tab.set(64, new ReaderQuote(LispLanguage.splice_sym, ':', LispLanguage.splice_colon_sym, 6));
        }
        return tab;
    }

    public static void registerEnvironment() {
        Language.setDefaults(Scheme.getInstance());
    }

    static {
        kawaEnvironment = Environment.make("kawa-environment");
        instance = new Scheme(kawaEnvironment);
        booleanType = new LangPrimType(Type.booleanType, instance);
        applyToArgs = new ApplyToArgs("apply-to-args", instance);
        apply = new Apply("apply", applyToArgs);
        instanceOf = new InstanceOf(instance, "instance?");
        not = new Not(instance, "not");
        isEq = new IsEq(instance, "eq?");
        isEqv = new IsEqv(instance, "eqv?", isEq);
        isEqual = new IsEqual(instance, "equal?");
        map = new Map(true, applyToArgs, isEq);
        forEach = new Map(false, applyToArgs, isEq);
        numEqu = NumberCompare.make(instance, "=", 8);
        numGrt = NumberCompare.make(instance, ">", 16);
        numGEq = NumberCompare.make(instance, ">=", 24);
        numLss = NumberCompare.make(instance, "<", 4);
        numLEq = NumberCompare.make(instance, "<=", 12);
        isOdd = new NumberPredicate(instance, "odd?", 1);
        isEven = new NumberPredicate(instance, "even?", 2);
        uniformVectorTags = new String[]{"s8", "s16", "s32", "s64", "u8", "u16", "u32", "u64", "f32", "f64"};
        emptyStringLeft = new String();
        emptyStringRight = new String();
        instance.initScheme();
    }
}

