/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.border.AbstractBorder;
import net.sf.freecol.client.gui.panel.FreeColBorder;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColImageBorder
extends AbstractBorder
implements FreeColBorder {
    private static final List<FreeColImageBorder> borders = new ArrayList<FreeColImageBorder>();
    public static final FreeColImageBorder panelWithoutShadowBorder = new FreeColImageBorder("image.border.panel.noshadow");
    public static final FreeColImageBorder panelBorder = new FreeColImageBorder("image.border.panel");
    public static final FreeColImageBorder buttonBorder = new FreeColImageBorder("image.border.button");
    public static final FreeColImageBorder simpleButtonBorder = new FreeColImageBorder("image.border.button.simple");
    public static final FreeColImageBorder menuBarBorder = new FreeColImageBorder("image.border.menu");
    public static final FreeColImageBorder woodenPanelBorder = new FreeColImageBorder("image.border.wooden");
    public static final FreeColImageBorder colonyWarehouseBorder = new FreeColImageBorder("image.border.colonyWarehouse");
    public static final FreeColImageBorder colonyPanelBorder = new FreeColImageBorder("image.border.colony.panel");
    public static final FreeColImageBorder innerColonyPanelBorder = new FreeColImageBorder("image.border.colony.panel.inner");
    public static final FreeColImageBorder outerColonyPanelBorder = new FreeColImageBorder("image.border.colony.panel.outer");
    private static float scaleFactor = 1.0f;
    private final String baseKey;
    private final boolean noScaling;
    private boolean initialized = false;
    private BufferedImage topLeftCornerImage;
    private BufferedImage topStartImage;
    private BufferedImage topImage;
    private BufferedImage topEndImage;
    private BufferedImage topRightCornerImage;
    private BufferedImage rightStartImage;
    private BufferedImage rightImage;
    private BufferedImage rightEndImage;
    private BufferedImage bottomRightCornerImage;
    private BufferedImage bottomEndImage;
    private BufferedImage bottomImage;
    private BufferedImage bottomStartImage;
    private BufferedImage bottomLeftCornerImage;
    private BufferedImage leftEndImage;
    private BufferedImage leftImage;
    private BufferedImage leftStartImage;

    private FreeColImageBorder(String baseKey) {
        this(baseKey, false);
    }

    private FreeColImageBorder(String baseKey, boolean noScaling) {
        this.baseKey = baseKey;
        this.noScaling = noScaling;
        this.loadImages();
        borders.add(this);
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.loadImages();
        }
    }

    private void loadImages() {
        this.loadImages(this.getImage(this.baseKey + ".nw"), this.getImage(this.baseKey + ".nnw"), this.getImage(this.baseKey + ".n"), this.getImage(this.baseKey + ".nne"), this.getImage(this.baseKey + ".ne"), this.getImage(this.baseKey + ".ene"), this.getImage(this.baseKey + ".e"), this.getImage(this.baseKey + ".ese"), this.getImage(this.baseKey + ".se"), this.getImage(this.baseKey + ".sse"), this.getImage(this.baseKey + ".s"), this.getImage(this.baseKey + ".ssw"), this.getImage(this.baseKey + ".sw"), this.getImage(this.baseKey + ".wsw"), this.getImage(this.baseKey + ".w"), this.getImage(this.baseKey + ".wnw"));
        this.initialized = true;
    }

    private void loadImages(BufferedImage topLeftCornerImage, BufferedImage topStartImage, BufferedImage topImage, BufferedImage topEndImage, BufferedImage topRightCornerImage, BufferedImage rightStartImage, BufferedImage rightImage, BufferedImage rightEndImage, BufferedImage bottomRightCornerImage, BufferedImage bottomEndImage, BufferedImage bottomImage, BufferedImage bottomStartImage, BufferedImage bottomLeftCornerImage, BufferedImage leftEndImage, BufferedImage leftImage, BufferedImage leftStartImage) {
        this.topLeftCornerImage = topLeftCornerImage;
        this.topStartImage = topStartImage;
        this.topImage = topImage;
        this.topEndImage = topEndImage;
        this.topRightCornerImage = topRightCornerImage;
        this.rightStartImage = rightStartImage;
        this.rightImage = rightImage;
        this.rightEndImage = rightEndImage;
        this.bottomRightCornerImage = bottomRightCornerImage;
        this.bottomEndImage = bottomEndImage;
        this.bottomImage = bottomImage;
        this.bottomStartImage = bottomStartImage;
        this.bottomLeftCornerImage = bottomLeftCornerImage;
        this.leftEndImage = leftEndImage;
        this.leftImage = leftImage;
        this.leftStartImage = leftStartImage;
    }

    public static void setScaleFactor(float scaleFactor) {
        FreeColImageBorder.scaleFactor = scaleFactor;
        FreeColImageBorder.reloadAllImages();
    }

    private static void reloadAllImages() {
        borders.stream().forEach(FreeColImageBorder::loadImages);
    }

    private BufferedImage getImage(String key) {
        ImageResource ir = ResourceManager.getImageResource(key, false);
        if (ir == null) {
            return null;
        }
        BufferedImage image = ir.getImage();
        if (this.noScaling) {
            return image;
        }
        Dimension scaledDimensions = new Dimension(Math.round((float)image.getWidth() * scaleFactor), Math.round((float)image.getHeight() * scaleFactor));
        return ir.getImage(scaledDimensions, false);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        this.ensureInitialized();
        return this.getBorderInsets(c, null);
    }

    @Override
    public List<Rectangle> getOpenSpace(Component c) {
        int openSpaceHeight;
        this.ensureInitialized();
        ArrayList<Rectangle> openSpace = new ArrayList<Rectangle>();
        if (this.topStartImage != null && this.topStartImage.getHeight() < this.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topEndImage))) {
            openSpaceHeight = this.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topEndImage)) - this.topStartImage.getHeight();
            openSpace.add(new Rectangle(0, 0, this.topStartImage.getWidth(), openSpaceHeight));
        }
        if (this.topImage != null && this.topImage.getHeight() < this.max(FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topEndImage))) {
            openSpaceHeight = this.max(FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topEndImage)) - this.topImage.getHeight();
            int x = FreeColImageBorder.getWidth(this.topStartImage);
            int width = c.getWidth() - FreeColImageBorder.getWidth(this.topStartImage) - FreeColImageBorder.getWidth(this.topEndImage);
            openSpace.add(new Rectangle(x, 0, width, openSpaceHeight));
        }
        if (this.topEndImage != null && this.topEndImage.getHeight() < this.max(FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topImage))) {
            openSpaceHeight = this.max(FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topImage)) - this.topEndImage.getHeight();
            openSpace.add(new Rectangle(c.getWidth() - this.topEndImage.getWidth(), 0, this.topEndImage.getWidth(), openSpaceHeight));
        }
        return openSpace;
    }

    public int getTopLeftCornerInsetY() {
        int top = this.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topEndImage), FreeColImageBorder.getHeight(this.topLeftCornerImage), FreeColImageBorder.getHeight(this.topRightCornerImage));
        return top - FreeColImageBorder.getHeight(this.topLeftCornerImage);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        this.ensureInitialized();
        int top = this.max(FreeColImageBorder.getHeight(this.topImage), FreeColImageBorder.getHeight(this.topStartImage), FreeColImageBorder.getHeight(this.topEndImage), FreeColImageBorder.getHeight(this.topLeftCornerImage), FreeColImageBorder.getHeight(this.topRightCornerImage));
        int left = this.max(FreeColImageBorder.getWidth(this.leftImage), FreeColImageBorder.getWidth(this.leftStartImage), FreeColImageBorder.getWidth(this.leftEndImage), FreeColImageBorder.getWidth(this.topLeftCornerImage), FreeColImageBorder.getWidth(this.bottomLeftCornerImage));
        int bottom = this.max(FreeColImageBorder.getHeight(this.bottomImage), FreeColImageBorder.getHeight(this.bottomStartImage), FreeColImageBorder.getHeight(this.bottomEndImage), FreeColImageBorder.getHeight(this.bottomLeftCornerImage), FreeColImageBorder.getHeight(this.bottomRightCornerImage));
        int right = this.max(FreeColImageBorder.getWidth(this.rightImage), FreeColImageBorder.getWidth(this.rightStartImage), FreeColImageBorder.getWidth(this.rightEndImage), FreeColImageBorder.getWidth(this.topRightCornerImage), FreeColImageBorder.getWidth(this.bottomRightCornerImage));
        if (this.topImage == null) {
            top = 0;
        }
        if (this.leftImage == null) {
            left = 0;
        }
        if (this.bottomImage == null) {
            bottom = 0;
        }
        if (this.rightImage == null) {
            right = 0;
        }
        if (insets == null) {
            return new Insets(top, left, bottom, right);
        }
        insets.top = top;
        insets.left = left;
        insets.bottom = bottom;
        insets.right = right;
        return insets;
    }

    private int max(int ... numbers) {
        int highest = Integer.MIN_VALUE;
        for (int i : numbers) {
            if (i <= highest) continue;
            highest = i;
        }
        return highest;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int h;
        int w;
        this.ensureInitialized();
        Insets insets = this.getBorderInsets(c);
        Graphics2D g2 = (Graphics2D)g;
        int topHeight = FreeColImageBorder.getHeight(this.topImage);
        int leftWidth = FreeColImageBorder.getWidth(this.leftImage);
        int bottomHeight = FreeColImageBorder.getHeight(this.bottomImage);
        int rightWidth = FreeColImageBorder.getWidth(this.rightImage);
        int topStartWidth = FreeColImageBorder.getWidth(this.topStartImage);
        int topStartHeight = FreeColImageBorder.getHeight(this.topStartImage);
        int topEndWidth = FreeColImageBorder.getWidth(this.topEndImage);
        int topEndHeight = FreeColImageBorder.getHeight(this.topEndImage);
        int leftStartWidth = FreeColImageBorder.getWidth(this.leftStartImage);
        int leftStartHeight = FreeColImageBorder.getHeight(this.leftStartImage);
        int leftEndWidth = FreeColImageBorder.getWidth(this.leftEndImage);
        int leftEndHeight = FreeColImageBorder.getHeight(this.leftEndImage);
        int bottomStartWidth = FreeColImageBorder.getWidth(this.bottomStartImage);
        int bottomStartHeight = FreeColImageBorder.getHeight(this.bottomStartImage);
        int bottomEndWidth = FreeColImageBorder.getWidth(this.bottomEndImage);
        int bottomEndHeight = FreeColImageBorder.getHeight(this.bottomEndImage);
        int rightStartWidth = FreeColImageBorder.getWidth(this.rightStartImage);
        int rightStartHeight = FreeColImageBorder.getHeight(this.rightStartImage);
        int rightEndWidth = FreeColImageBorder.getWidth(this.rightEndImage);
        int rightEndHeight = FreeColImageBorder.getHeight(this.rightEndImage);
        int topLeftCornerWidth = FreeColImageBorder.getWidth(this.topLeftCornerImage);
        int topLeftCornerHeight = FreeColImageBorder.getHeight(this.topLeftCornerImage);
        int topRightCornerWidth = FreeColImageBorder.getWidth(this.topRightCornerImage);
        int topRightCornerHeight = FreeColImageBorder.getHeight(this.topRightCornerImage);
        int bottomLeftCornerWidth = FreeColImageBorder.getWidth(this.bottomLeftCornerImage);
        int bottomLeftCornerHeight = FreeColImageBorder.getHeight(this.bottomLeftCornerImage);
        int bottomRightCornerWidth = FreeColImageBorder.getWidth(this.bottomRightCornerImage);
        int bottomRightCornerHeight = FreeColImageBorder.getHeight(this.bottomRightCornerImage);
        if (this.topStartImage != null) {
            w = Math.min(topStartWidth, width - topLeftCornerWidth - topRightCornerWidth);
            ImageUtils.fillTexture(g2, this.topStartImage, x + topLeftCornerWidth, y + insets.top - topStartHeight, w, topStartHeight);
        }
        if (this.topImage != null) {
            ImageUtils.fillTexture(g2, this.topImage, x + topLeftCornerWidth + topStartWidth, y + insets.top - topHeight, width - topLeftCornerWidth - topRightCornerWidth - topStartWidth - topEndWidth, topHeight);
        }
        if (this.topEndImage != null) {
            w = Math.min(topEndWidth, width - topLeftCornerWidth - topRightCornerWidth - topStartWidth);
            ImageUtils.fillTexture(g2, this.topEndImage, x + width - Math.max(insets.right, topRightCornerWidth) - w, y + insets.top - topEndHeight, w, topEndHeight);
        }
        if (this.leftStartImage != null) {
            h = Math.min(leftStartHeight, height - Math.max(insets.top, topLeftCornerHeight) - bottomLeftCornerHeight);
            ImageUtils.fillTexture(g2, this.leftStartImage, x + insets.left - leftStartWidth, y + Math.max(insets.top, topLeftCornerHeight), leftStartWidth, h);
        }
        if (this.leftImage != null) {
            ImageUtils.fillTexture(g2, this.leftImage, x + insets.left - leftWidth, y + Math.max(insets.top, topLeftCornerHeight) + leftStartHeight, leftWidth, height - Math.max(insets.top, topLeftCornerHeight) - Math.max(insets.bottom, bottomLeftCornerHeight) - leftStartHeight - leftEndHeight);
        }
        if (this.leftEndImage != null) {
            h = Math.min(leftEndHeight, height - topLeftCornerHeight - bottomLeftCornerHeight - leftStartHeight);
            ImageUtils.fillTexture(g2, this.leftEndImage, x + insets.left - leftEndWidth, y + height - Math.max(insets.bottom, bottomLeftCornerHeight) - h, leftEndWidth, h);
        }
        if (this.bottomStartImage != null) {
            w = Math.min(bottomStartWidth, width - bottomLeftCornerWidth - bottomRightCornerWidth);
            ImageUtils.fillTexture(g2, this.bottomStartImage, x + bottomLeftCornerWidth, y + height - insets.bottom, w, bottomStartHeight);
        }
        if (this.bottomImage != null) {
            ImageUtils.fillTexture(g2, this.bottomImage, x + bottomLeftCornerWidth + bottomStartWidth, y + height - insets.bottom, width - bottomLeftCornerWidth - bottomRightCornerWidth - bottomStartWidth - bottomEndWidth, bottomHeight);
        }
        if (this.bottomEndImage != null) {
            w = Math.min(bottomEndWidth, width - bottomLeftCornerWidth - bottomRightCornerWidth - bottomStartWidth);
            ImageUtils.fillTexture(g2, this.bottomEndImage, x + width - Math.max(insets.right, bottomRightCornerWidth) - w, y + height - insets.bottom, w, bottomEndHeight);
        }
        if (this.rightStartImage != null) {
            h = Math.min(rightStartHeight, height - Math.max(insets.top, topRightCornerHeight) - bottomRightCornerHeight);
            ImageUtils.fillTexture(g2, this.rightStartImage, x + width - insets.right, y + Math.max(insets.top, topRightCornerHeight), rightStartWidth, h);
        }
        if (this.rightImage != null) {
            ImageUtils.fillTexture(g2, this.rightImage, x + width - insets.right, y + Math.max(insets.top, topRightCornerHeight) + rightStartHeight, rightWidth, height - Math.max(insets.top, topRightCornerHeight) - bottomRightCornerHeight - rightStartHeight - rightEndHeight);
        }
        if (this.rightEndImage != null) {
            h = Math.min(rightEndHeight, height - topRightCornerHeight - bottomRightCornerHeight - rightStartHeight);
            ImageUtils.fillTexture(g2, this.rightEndImage, x + width - insets.right, y + height - Math.max(insets.bottom, bottomRightCornerHeight) - h, rightEndWidth, h);
        }
        if (this.topLeftCornerImage != null) {
            ImageUtils.fillTexture(g2, this.topLeftCornerImage, x + Math.max(insets.left, topLeftCornerWidth) - topLeftCornerWidth, y + Math.max(insets.top, topLeftCornerHeight) - topLeftCornerHeight, topLeftCornerWidth, topLeftCornerHeight);
        }
        if (this.topRightCornerImage != null) {
            ImageUtils.fillTexture(g2, this.topRightCornerImage, x + width - Math.max(insets.right, topRightCornerWidth), y + Math.max(insets.top, topRightCornerHeight) - topRightCornerHeight, topRightCornerWidth, topRightCornerHeight);
        }
        if (this.bottomLeftCornerImage != null) {
            ImageUtils.fillTexture(g2, this.bottomLeftCornerImage, x + Math.max(insets.left, bottomLeftCornerWidth) - bottomLeftCornerWidth, y + height - Math.max(insets.bottom, bottomLeftCornerHeight), bottomLeftCornerWidth, bottomLeftCornerHeight);
        }
        if (this.bottomRightCornerImage != null) {
            ImageUtils.fillTexture(g2, this.bottomRightCornerImage, x + width - Math.max(insets.right, bottomRightCornerWidth), y + height - Math.max(insets.bottom, bottomRightCornerHeight), bottomRightCornerWidth, bottomRightCornerHeight);
        }
    }

    private static int getHeight(Image im) {
        return im == null ? 0 : im.getHeight(null);
    }

    private static int getWidth(Image im) {
        return im == null ? 0 : im.getWidth(null);
    }
}

