/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.animation;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.animation.Animation;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.common.io.sza.AnimationEvent;
import net.sf.freecol.common.io.sza.ImageAnimationEvent;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public final class UnitImageAnimation
extends Animation {
    private static final Logger logger = Logger.getLogger(UnitImageAnimation.class.getName());
    public static final Map<Direction, List<Direction>> alternatives = new HashMap<Direction, List<Direction>>();
    private final SimpleZippedAnimation animation;
    private boolean mirror;

    public UnitImageAnimation(Unit unit, Tile tile, SimpleZippedAnimation animation) {
        super(unit, CollectionUtils.makeUnmodifiableList(tile));
        this.animation = animation;
        this.mirror = false;
    }

    public void setMirrored(boolean mirror) {
        this.mirror = mirror;
    }

    private static synchronized List<Direction> trialDirections(Direction direction) {
        if (alternatives.isEmpty()) {
            for (Direction d : Direction.allDirections) {
                ArrayList<Direction> a = new ArrayList<Direction>();
                a.add(d);
                switch (d) {
                    case N: 
                    case S: {
                        a.add(Direction.E);
                        a.add(Direction.W);
                        a.add(d.rotate(1));
                        a.add(d.rotate(-1));
                        a.add(d.rotate(3));
                        a.add(d.rotate(-3));
                        break;
                    }
                    case NE: 
                    case SW: {
                        a.add(d.rotate(1));
                        a.add(d.rotate(2));
                        a.add(d.rotate(-1));
                        a.add(d.rotate(3));
                        break;
                    }
                    case NW: 
                    case SE: {
                        a.add(d.rotate(-1));
                        a.add(d.rotate(-2));
                        a.add(d.rotate(1));
                        a.add(d.rotate(-3));
                        break;
                    }
                    case E: 
                    case W: {
                        a.add(d.rotate(1));
                        a.add(d.rotate(-1));
                        a.add(d.rotate(2));
                        a.add(d.rotate(-2));
                    }
                }
                alternatives.put(d, a);
            }
        }
        return alternatives.get(direction);
    }

    public static UnitImageAnimation build(Unit unit, Tile tile, Direction dirn, String base, float scale) {
        for (Direction d : UnitImageAnimation.trialDirections(dirn)) {
            String szaId = base + StringUtils.downCase(d.toString());
            SimpleZippedAnimation sza = ImageLibrary.getSZA(szaId, scale);
            if (sza != null) {
                return new UnitImageAnimation(unit, tile, sza);
            }
            szaId = base + StringUtils.downCase(d.getEWMirroredDirection().toString());
            sza = ImageLibrary.getSZA(szaId, scale);
            if (sza == null) continue;
            UnitImageAnimation ret = new UnitImageAnimation(unit, tile, sza);
            ret.setMirrored(true);
            return ret;
        }
        return null;
    }

    @Override
    public void executeWithLabel(JLabel unitLabel, Animations.Procedure paintCallback) {
        ImageIcon icon = (ImageIcon)unitLabel.getIcon();
        for (AnimationEvent event : this.animation) {
            long time = System.nanoTime();
            if (!(event instanceof ImageAnimationEvent)) continue;
            ImageAnimationEvent ievent = (ImageAnimationEvent)event;
            Image image = ievent.getImage();
            if (this.mirror) {
                image = ImageUtils.createMirroredImage(image);
            }
            icon.setImage(image);
            paintCallback.execute();
            time = (long)ievent.getDurationInMs() - (System.nanoTime() - time) / 1000000L;
            if (time <= 0L) continue;
            Utils.delay(time, "Animation delayed.");
        }
    }
}

