# Lore - Technology in the Cataclysm

#### Seriously, spoiler alert.
CDDA tells stories using unreliable narrators and a found footage style.  Knowing too much of the lore can ruin your experience.  Don't read this unless you plan to contribute, please! All contents subject to change with project development.

## Summary
Technology native to Cataclysm Earth should, except in specific situations, be *at a modern real life level*.  The design rationale for this is simple: it allows straightforward answers to questions about things like "is this idea reasonable", "how much ____ should this do", and more.  If it is possible in real life (and you can prove it), it's probably appropriate for Cataclysm.  Likewise, if it's not possible in real life, it is probably not possible in Cataclysm... the exceptions will be enumerated in this document.

See [the timeline](./lore-background.md) for lore explanations of the divergent technology in this world.

*Note: this section has recently changed**. Previously, CBMs were a CDDA-Earth technology, but we're changing that lore.

## Civilian Tech
In terms of civilian technology there are a handful of things that differ from our world.  All of these are very rare and expensive.

### Cybernetics
Cybernetics were not available on CDDA-Earth prior to the portal storms.  The technology level of the CBMs available from the Exodii faction should be roughly comparable to things that we can make in the modern day, with exceptions being considered special and rare.  The main difference isn't what the tech itself can do, but the fact that it can do it from an arm interface that draws from your central power supply and is connected to your brain.

Note that this is a change to the lore implemented around 2021 or so. There are a few gameplay reasons for this change, and examining them can be helpful to understanding how the design philosophy works.
- Prior to the change, cybernetics were required to make sense as something developed on an Earth with a similar technology level to ours, or we had to make CDDA Earth so different from ours that it loses a lot of the "real life zombie apocalypse" feel.  Making them interdimensional removes a lot of restrictions on the design space of what "makes sense" for a cybernetic.  For example, things like shotgun arms and knives for hands don't make a ton of sense in the "real world" we're trying to go for in DDA, but they're totally something someone may have cooked up *somewhere*. This allows them to stay in.
- Labs used to be a very one-stop-shop for loot (and still are, at the time of this writing).  The lore change to CBMs should allow us to move them to their own type of dungeon at some point, giving a wider variety of exploration goals with different feels.
- Linking NPCs to the process of cybernetic installation makes it more possible to ensure players can reliably obtain critical important CBMs instead of being completely reliant on random loot generation and dissecting dozens of zombie corpses to try to get enough power to run them. However, random loot should still remain part of the process of getting CBMs.

#### Prosthetics
Prosthetic limbs available to civilians are not markedly above the level available on our Earth.  Note that the level available on our Earth has gotten quite impressive, so this is a pretty high bar.

### Robots and AI
Proto-AI evolved from dimensional heuristics (the secrets of which are completely black box and explained away as a kind of deep learning) has made civilian level robots conceivable, albeit extremely rare.  The first public release of robots was police eyebots six years before the Cataclysm.  Most non-police civilian level applications are medical.  These AIs do well in constrained environments with very specific tasks.  They are, however, deeply stupid, especially without their central controllers and human supervision. These are not science fiction robots that can adapt to a situation and respond appropriately. They're not really anything more than you'd expect from slapping a processor and some algorithms onto a drone nowadays.  Some of these have guns and have foolishly been activated to use those guns without supervision.

### Energy Storage
Energy storage among civilians is basically the same as real life earth, with a couple exceptions:
- electrolytic hydrogen fuel cells are moderately more efficient, thanks to an early introduction of transdimensional tech.  As a result, fuel cell powered vehicles and other technologies are more common.
- Li-ion batteries are no better, but are a bit cheaper and more common

### Powered Suits
Due to the availability of fuel cells, powered exoskeletons for industrial work are extremely rare but do exist.  These suits are bulky but allow a degree of finesse that a crane or forklift can't match.  Their primary market is wealthy nerds.

Just as in real life, powered exoskeletons are used to assist rehabilitation of people with neurological damage. These are slightly more common in CDDA-Earth, as the technology was developed earlier due to earlier availability of appropriate power cells, but aside from being more common they're not much different.

## Widespread Military Technology
The military at large has access to technology that far exceeds civilian capacity, but whose existence doesn't potentially compromise the secrets of interdimensional travel and research.

### Energy Storage
Milspec energy storage is based around next generation power cells nicknamed "plutonium fuel cells".  These are neither radiation based nor fuel cells, but the name stuck.  From a design standpoint these are handwavium, items that exist to explain hypertech available to the military.  Design-wise they should be:
- Rare
- Not rechargeable
- Not found outside labs and military technology
From a story standpoint, these cells use a small amount of exotic matter from the netherum as a power source, catalyzed by plutonium.  When the exotic matter runs out the empty plutonium cell can be sent to a central facility to be reloaded... but that facility no longer exists.

### Power Armor
Milspec power armor relies on plutonium cells to function, this is what enables its existence.  Aside from fictionalized power storage, the rest of its capabilities are real life.  These are not like the power armour in fallout, more of a combat exoskeleton supporting some armour plating.

#### Industrial Powered Lifting Suits
See Civilian entry. Powered suits that are of somewhat limited use in civilian settings found a lot more applications for military engineering and are fairly common on ships and in deployed engineering units.

### Turrets and robots
At the very end of the cataclysm, dimensional heuristic AI was used to create human-free automated turrets and combat robots. These protocols were never meant to be used without a human, and the developers and users of the technology warned against trying to use them in this way. Turrets and "independent" robots without a human overseer and a connection to Melchior should be *profoundly* stupid and quite dangerous to anyone around them.

### Weaponry
Like power armor, the major divergence point for weaponry is the existence of high density fictionalized power cells.  All other technology should be as realistic as possible.  Due to the extreme rarity and "one and done" nature of plutonium cells, military lasers and things are rare.  Technology that hasn't even been prototyped, or at the very least modeled theoretically, in our world is probably not appropriate for Cataclysm.

When designing a high-tech weapon for the game, first ask yourself "why". Why would this weapon have been in production?  If it is a prototype, it should be unreliable and impractical for day to day use.  It is possible that high tech special use weapons exist, but they should definitely not be in major circulation.  CDDA-Earth only started majorly branching from our own timeline quite recently.

## Top Secret Technology

### Dimensional Manipulation
At the heart of most of the differences in technology is the ability to examine and manipulate dimensions in the CDDA universe. Portable versions of this technology are possible but should be limited, extremely rare, and extremely costly in energy terms.  That said, the events causing the cataclysm made the energy costs at least an order of magnitude lower, which in turn means that things that may have been barely functional proof-of-concept prototypes before may now be able to work fairly well.

### Dimensional Heuristics
"Smart" AI in Cataclysm relies on the ability to scan adjacent dimensions to learn the results of an upcoming action.  Before the cataclysm this could only look a few moments into the future in response to very specific questions, and was very power costly.  After the cataclysm, dimensional barriers are much lower, and this technology is far less costly energy-wise.  This allows a computer to simulate human deduction abilities.  It does not provide clairvoyance nor omniscience, nor real intelligence; it does not make AIs great planners of the long term future.

### Cloning
Advanced organ and body part cloning, derived from the study of crashed mi-go scouts and their ships, allows scientists to experiment on human parts grown in the lab.  The exact capabilities of these cloning vats hasn't yet been explored in game.

### Mutagens
Mutation is not so much a technology as taking advantage of the blob infection in all people.  These were developed very close to the Cataclysm, and would be totally unknown to the public.

#### What are mutations?
Mutations in Cataclysm are governed by the latent blob infection in all living things.  They are not the same as what is generally meant by mutation in a scientific sense, nor what we generally see in pulp scifi.  Cataclysm mutations are non genetic (more accurately, they don't *have* to be genetic.  The blob is keen on reusing stuff, and might alter gene expression to achieve a goal when it's quick and easy).

A quick analogy to explain this: DNA serves like a blueprint for the architecture of the cell.  These mutations have an intermediary, like an architect standing at the building site offering new advice that supercedes the blueprint.


## Alien Technology
The biggest branch point in CDDA tech is the availability of sci-fi technology from other dimensions.  We're still fine tuning the rules about this, so this section is under construction.

The basic rule of thumb is that the more advanced or unbelievable the technology, the less player modifiable it should be.  An alien chemical propellant weapon might be modified to accept earth bullets because the principles are quite similar, but no player is going to be dismantling a mi-go slaver rifle and salvaging recognizable components. 

### Scale of technology/power levels in game
```
Modern Earth |S-U-X-E^--M------------F-Y----!T-----B| Basically Magic

S: Survivors
U: Exodii understanding of most technical theory
X: XEDRA/Hub01/02
E: Exodii functional technology with principles they no longer understand
^: High upper limit of what a modern human could conceivably come to understand and work with
M: Mi-Go
F: Mycus (though it is unclear if the mycus has any true intent or forward thought, so it's hard to say if it's truly technology)
Y: Yrax
!: After this, it's magic for all intents and purposes
T: Triffids
B: Blob
```

### Exodii Technology
The Exodii are a faction of human travellers from other cataclysm-affected dimensions.  They have replaced a majority of their bodies with cybernetics to enable them to more easily defend against the zombie threat, both inside and out.  In general, Exodii technology should **not** be significantly more advanced than our own, with a few exceptions as outlined here.

#### Cybernetics
Cybernetics were brought to earth after the cataclysm, by the Exodii.  A readily available CBM should not contain technology that can't be explained by modern technology, except for the details of it being attached to the body without harm.  We can handwave away neural interfacing with CBMs.  Unique advanced CBMs may possess greater capabilities but access to these should be strictly gated through story advancement through one of several factions.  Cybernetics are a core part of the Exodii identity and have likely been part of their repertoire for centuries or more.

Cybernetic technology includes the **auto-doc**, an operating table assisted by at least one adapted human brain as a central computer, and a traditional computer that mostly assists the adapted brain by providing it with additional knowledge from previous operations.  Technically this means an auto-doc is itself a cyborg.  It consists of a surgical unit very similar to a modern remote controlled surgical robot, and an anaesthesia machine.

#### Braaaains
The Exodii use human and animal brains as computing assistants all the time.  Their major source of human brains are "feral" humans, who have had significant brain damage from the Blob.  They excise damaged tissue creating a lobotomized brain, which then gets hooked up to Exodii machinery to function as a handy computer able to make fairly complex decisions.

#### Computers and software
Exodii computers and software are somewhat less advanced (at least superficially) on average than our or CDDA Earth.  This is largely the result of them being kludged together from completely incompatible sources over decades to millenia.  They do as much computing as possible using wetware.  The Exodii neural uplink is able to function as a compatability bus for a lot of software, but it is very slow: literally, a human brain can take input from one piece of software and figure out how to output it to another.  Over time it can be trained to do this quickly, and over more time, train a machine to do it automatically, but it's not fast and it's not reliable.

The Exodii do not have the capacity to develop novel microprocessors and things like that, but they can print existing designs according to spec, mostly as needed for CBMs.

#### Manufacturing
The Exodii have on-base a series of 3D printers able to manufacture the components needed for their most fundamental cybernetics.  These are maintained like religious relics and each part's structure (including the software) is known on an exacting level.  The actual function of some of the components has been lost over time.  Additionally they have some tools for separating and reforging scrap metals and other raw materials into the parts needed for their printers.

Off-site the Exodii maintain separate structures that they've gathered over time and try to bring along.  These allow more extensive and robust recycling and manufacturing of things that are useful to, but not necessary to, the Exodii.

#### Portals
Exodii portal technology is quite different from that employed by XEDRA.  While on the surface they seem to do the same thing, they are fundamentally wholly different technologies.  Exodii portal tech cannot be easily targeted to a location the way XEDRA tech seems to be; they can filter destinations based on criteria, but cannot pinpoint a single location to travel to until they've gone there.  They are able to set up beacons, once they have hit a dimension, and then travel to the beacon reliably - so they can go back to previously dimensions, and can home in on a single dimension once they've chosen it and send all their stuff there.

Exodii portal tech is moderately hostile to organic material.  How exactly it classifies this is unclear and it's unlikely the Exodii know themselves.  Inert organic matter like plastic and wood fare better but may still decay during the jump.  Exposed living tissue is at greater risk, so the gardens on the Exodii base tend to die and need replanting each trip.  Food in tins and containers is at less, but not no, risk of damage, as are partial conversion exodii, who limit their risk by entering a hibernation state and encasing themselves in metal pods during travel (conveniently this also means that if they die, they are locked up safely).  Due to these dangers, the Exodii avoid unnecessary dimensional transit.  However, this effect is mostly seen as a feature, not a bug: if the base is overrun and needs to make an emergency teleport, it will kill almost any interlopers immediately.

### Yrax Technology
