/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql.jdbcwrapper;

import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sql.jdbcwrapper.GenericConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.HSQLDBConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.MySQLConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.OracleConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.PostgresConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.RedBrickConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLServerConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.SQLiteConnectionDecorator;
import ca.sqlpower.sql.jdbcwrapper.SybaseConnectionDecorator;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class ConnectionDecorator
implements Connection {
    private static Logger logger = Logger.getLogger(ConnectionDecorator.class);
    private int openStatementCount;
    protected Connection connection;
    protected DatabaseMetaDataDecorator databaseMetaDataDecorator = null;

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Currently it is only possible to wrap JDBC 3.");
    }

    protected ConnectionDecorator(Connection delegate) {
        this.connection = delegate;
    }

    public static Connection createFacade(Connection delegate) throws SQLException {
        String driverName = delegate.getMetaData().getDriverName();
        logger.debug((Object)("static createFacade, driver class is: " + delegate.getClass().getName()));
        logger.debug((Object)("static createFacade, driver name is: " + driverName));
        if (driverName.equals("PostgreSQL Native Driver")) {
            return new PostgresConnectionDecorator(delegate);
        }
        if (driverName.equals("Oracle JDBC driver")) {
            return new OracleConnectionDecorator(delegate);
        }
        if (driverName.equals("SQLServer") || driverName.equals("Microsoft SQL Server 2005 JDBC Driver") || driverName.startsWith("Microsoft SQL Server JDBC Driver")) {
            return new SQLServerConnectionDecorator(delegate);
        }
        if (driverName.equals("MySQL-AB JDBC Driver")) {
            return new MySQLConnectionDecorator(delegate);
        }
        if (driverName.equals("HSQL Database Engine Driver")) {
            return new HSQLDBConnectionDecorator(delegate);
        }
        if (driverName.equals("SQLiteJDBC")) {
            return new SQLiteConnectionDecorator(delegate);
        }
        if (driverName.equals("RBW_JDBC_Driver")) {
            return new RedBrickConnectionDecorator(delegate);
        }
        if (driverName.equals("jConnect (TM) for JDBC (TM)")) {
            return new SybaseConnectionDecorator(delegate);
        }
        if (driverName.equals("SQL Power Mock JDBC Database Driver")) {
            return delegate;
        }
        return new GenericConnectionDecorator(delegate);
    }

    public int getOpenStatementCount() {
        return this.openStatementCount;
    }

    protected void incrementOpenStatements() {
        ++this.openStatementCount;
        logger.debug((Object)("New Statement opened: Count is " + this.openStatementCount));
    }

    protected void decrementOpenStatements() {
        --this.openStatementCount;
        logger.debug((Object)("Existing Statement closed: Count is " + this.openStatementCount));
    }

    protected abstract Statement makeStatementDecorator(Statement var1);

    protected abstract PreparedStatement makePreparedStatementDecorator(PreparedStatement var1);

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = this.makeStatementDecorator(this.connection.createStatement());
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = this.makeStatementDecorator(this.connection.createStatement(resultSetType, resultSetConcurrency));
        return stmt;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = this.makeStatementDecorator(this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        return stmt;
    }

    public boolean equals(Object obj) {
        return this.connection.equals(obj);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql, columnIndexes));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.makePreparedStatementDecorator(this.connection.prepareStatement(sql, columnNames));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public String toString() {
        return this.connection.toString();
    }
}

