/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.validator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExistsValidator
extends AbstractFileValidator {
    public static final FileExistsValidator INSTANCE = new FileExistsValidator();
    static final String VALIDATOR_NAME = "fileExists";
    private static final String KEY_FAIL_IF_DOES_NOT_EXIST = "org.pentaho.di.job.entries.createfile.failIfDoesNotExist";

    @Override
    public boolean validate(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        String filename = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        VariableSpace variableSpace = this.getVariableSpace(source, propertyName, remarks, context);
        boolean failIfDoesNotExist = this.getFailIfDoesNotExist(source, propertyName, remarks, context);
        if (null == variableSpace) {
            return false;
        }
        String realFileName = variableSpace.environmentSubstitute(filename);
        FileObject fileObject = null;
        try {
            fileObject = KettleVFS.getFileObject((String)realFileName);
            if (fileObject == null || fileObject != null && !fileObject.exists() && failIfDoesNotExist) {
                JobEntryValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, JobEntryValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            try {
                fileObject.close();
            }
            catch (IOException ignored) {}
        }
        catch (Exception e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }

    public static ValidatorContext putFailIfDoesNotExist(boolean failIfDoesNotExist) {
        ValidatorContext context = new ValidatorContext();
        context.put(KEY_FAIL_IF_DOES_NOT_EXIST, failIfDoesNotExist);
        return context;
    }

    protected boolean getFailIfDoesNotExist(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        Object obj = context.get(KEY_FAIL_IF_DOES_NOT_EXIST);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void putFailIfDoesNotExist(ValidatorContext context, boolean failIfDoesNotExist) {
        context.put(KEY_FAIL_IF_DOES_NOT_EXIST, failIfDoesNotExist);
    }
}

