/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.swingui.ColourScheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class BasicRelationshipUI
extends RelationshipUI
implements Serializable {
    private static Logger logger = Logger.getLogger(BasicRelationshipUI.class);
    private static final double NINETY_DEGREES = Math.toRadians(90.0);
    protected Rectangle computedBounds;
    protected transient GeneralPath path;
    protected transient GeneralPath containmentPath;
    protected float nonSelectedStrokeWidth = 1.0f;
    protected float selectedStrokeWidth = 2.0f;
    protected int radius = 4;
    private FontMetrics fm;
    private JLabel parentToChild = new JLabel();
    private JLabel childToParent = new JLabel();

    public static PlayPenComponentUI createUI(PlayPenComponent c) {
        logger.debug((Object)("Creating new BasicRelationshipUI for " + c));
        return new BasicRelationshipUI();
    }

    @Override
    public void installUI(PlayPenComponent c) {
        logger.debug((Object)("Installing BasicRelationshipUI on " + c));
        this.relationship = (Relationship)c;
        this.fm = this.relationship.getPlayPen() != null ? this.relationship.getFontMetrics(this.relationship.getFont()) : null;
        this.computedBounds = new Rectangle(this.relationship.getBounds());
        this.relationship.addSPListener((SPListener)this);
    }

    @Override
    public void uninstallUI(PlayPenComponent c) {
        this.relationship = (Relationship)c;
        this.relationship.removeSPListener((SPListener)this);
    }

    @Override
    public void revalidate() {
        Rectangle OldBounds = this.computedBounds;
        Rectangle bounds = this.computeBounds();
        if (!this.computedBounds.equals(OldBounds)) {
            this.relationship.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }

    @Override
    public void paint(Graphics2D g2) {
        this.paint(g2, this.relationship);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, PlayPenComponent c) {
        logger.debug((Object)"BasicRelationshipUI is painting");
        Relationship r = (Relationship)c;
        Graphics2D g2 = (Graphics2D)g;
        int orientation = r.getOrientation();
        this.childToParent.setFont(g2.getFont());
        this.parentToChild.setFont(g2.getFont());
        logger.debug((Object)("orientation is: " + orientation));
        if (c == null) {
            throw new NullPointerException("Relationship c is null");
        }
        g2.translate(-c.getX(), -c.getY());
        if (logger.isDebugEnabled()) {
            g2.setColor(c.getBackgroundColor());
            Rectangle bounds = c.getBounds();
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            logger.debug((Object)("Relationship bounds " + bounds));
            g2.setColor(c.getForegroundColor());
        }
        try {
            ImmutablePoint pktloc = this.relationship.createPkConnectionPoint();
            Point start = new Point(pktloc.getX() + r.getPkTable().getLocation().x, pktloc.getY() + r.getPkTable().getLocation().y);
            Point lineStart = new Point(start);
            if ((orientation & 2) != 0) {
                lineStart.x -= this.getTerminationLength();
            } else if ((orientation & 1) != 0) {
                lineStart.x += this.getTerminationLength();
            } else if ((orientation & 8) != 0) {
                lineStart.y -= this.getTerminationLength();
            } else if ((orientation & 4) != 0) {
                lineStart.y += this.getTerminationLength();
            }
            ImmutablePoint fktloc = this.relationship.createFkConnectionPoint();
            Point end = new Point(fktloc.getX() + r.getFkTable().getLocation().x, fktloc.getY() + r.getFkTable().getLocation().y);
            Point lineEnd = new Point(end);
            if ((orientation & 0x20) != 0) {
                lineEnd.x -= this.getTerminationLength();
            } else if ((orientation & 0x10) != 0) {
                lineEnd.x += this.getTerminationLength();
            } else if ((orientation & 0x80) != 0) {
                lineEnd.y -= this.getTerminationLength();
            } else if ((orientation & 0x40) != 0) {
                lineEnd.y += this.getTerminationLength();
            }
            this.containmentPath = new GeneralPath(1, 10);
            Rectangle2D parentBounds = this.fm.getStringBounds(r.getTextForParentLabel(), g2);
            Rectangle2D childBounds = this.fm.getStringBounds(r.getTextForChildLabel(), g2);
            int pkStringWidth = parentBounds.getBounds().width;
            int fkStringWidth = childBounds.getBounds().width;
            int maxStringWidth = Math.max(pkStringWidth, fkStringWidth);
            int pkLabelDistance = 0;
            int fkLabelDistance = 0;
            boolean rotate = false;
            float parentToChildLabelStartX = 0.0f;
            float childToParentLabelStartX = 0.0f;
            float parentToChildLabelStartY = 0.0f;
            float childToParentLabelStartY = 0.0f;
            g2.setColor(r.getForegroundColor());
            float leftmost = 0.0f;
            float rightmost = 0.0f;
            float highest = 0.0f;
            float lowest = 0.0f;
            if (r.displayRelationshipLabel()) {
                if (lineStart.x > lineEnd.x) {
                    logger.debug((Object)"Parent is at the right side of child");
                    leftmost = lineEnd.x;
                    rightmost = lineStart.x;
                } else {
                    logger.debug((Object)"Parent is at the left side of child");
                    leftmost = lineStart.x;
                    rightmost = lineEnd.x;
                }
                if (lineStart.y > lineEnd.y) {
                    logger.debug((Object)"Parent is below the child");
                    highest = lineEnd.y;
                    lowest = lineStart.y;
                } else {
                    logger.debug((Object)"Parent is above the child");
                    highest = lineStart.y;
                    lowest = lineEnd.y;
                }
                parentToChildLabelStartX = this.calculateRelationshipLabelStart(leftmost, rightmost, this.fm.stringWidth(r.getTextForParentLabel()));
                childToParentLabelStartX = this.calculateRelationshipLabelStart(leftmost, rightmost, this.fm.stringWidth(r.getTextForChildLabel()));
                parentToChildLabelStartY = this.calculateRelationshipLabelStart(highest, lowest, this.fm.stringWidth(r.getTextForParentLabel()));
                childToParentLabelStartY = this.calculateRelationshipLabelStart(highest, lowest, this.fm.stringWidth(r.getTextForChildLabel()));
            }
            if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y + this.getTerminationLength());
                this.containmentPath.lineTo(lineEnd.x - this.getTerminationLength(), lineStart.y + this.getTerminationLength());
                this.containmentPath.lineTo(lineEnd.x - this.getTerminationLength(), lineEnd.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                if (r.displayRelationshipLabel()) {
                    leftmost = lineEnd.x - this.getTerminationLength();
                    rightmost = lineStart.x;
                    parentToChildLabelStartX = this.calculateRelationshipLabelStart(leftmost, rightmost, this.fm.stringWidth(r.getTextForParentLabel()));
                    childToParentLabelStartX = this.calculateRelationshipLabelStart(leftmost, rightmost, this.fm.stringWidth(r.getTextForChildLabel()));
                    pkLabelDistance = lineStart.y + this.getTerminationLength() - this.fm.getHeight();
                    fkLabelDistance = lineStart.y + this.getTerminationLength();
                }
                this.containmentPath.lineTo(lineEnd.x - this.getTerminationLength(), lineEnd.y);
                this.containmentPath.lineTo(lineEnd.x - this.getTerminationLength(), lineStart.y + this.getTerminationLength());
                this.containmentPath.lineTo(lineStart.x, lineStart.y + this.getTerminationLength());
            } else if (r.isStraightLine()) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
            } else if ((orientation & 3) != 0 && (orientation & 0x30) != 0) {
                int midx = Math.abs(lineEnd.x - lineStart.x) / 2 + Math.min(lineStart.x, lineEnd.x);
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(midx, lineStart.y);
                this.containmentPath.lineTo(midx, lineEnd.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                if (r.displayRelationshipLabel()) {
                    this.parentToChild.setIcon(null);
                    this.childToParent.setIcon(null);
                    if (lineStart.x > lineEnd.x) {
                        if (lineStart.y < lineEnd.y) {
                            logger.debug((Object)"pk table is at right and higher");
                            if (lineEnd.y - lineStart.y > maxStringWidth || lineStart.x - lineEnd.x < lineEnd.y - lineStart.y) {
                                pkLabelDistance = midx + this.fm.getHeight();
                                fkLabelDistance = midx;
                                rotate = true;
                            } else {
                                pkLabelDistance = lineStart.y - this.fm.getHeight();
                                fkLabelDistance = lineEnd.y;
                            }
                        } else {
                            logger.debug((Object)"pk table is at right and lower");
                            if (lineStart.y - lineEnd.y > maxStringWidth || lineStart.x - lineEnd.x < lineStart.y - lineEnd.y) {
                                pkLabelDistance = midx + this.fm.getHeight();
                                fkLabelDistance = midx;
                                rotate = true;
                            } else {
                                pkLabelDistance = lineEnd.y - this.fm.getHeight();
                                fkLabelDistance = lineStart.y;
                            }
                        }
                    } else if (lineStart.y < lineEnd.y) {
                        logger.debug((Object)"pk table is at left and higher");
                        if (lineEnd.y - lineStart.y > maxStringWidth || lineEnd.x - lineStart.x < lineEnd.y - lineStart.y) {
                            pkLabelDistance = midx + this.fm.getHeight();
                            fkLabelDistance = midx;
                            rotate = true;
                        } else {
                            pkLabelDistance = lineStart.y - this.fm.getHeight();
                            fkLabelDistance = lineEnd.y;
                        }
                    } else {
                        logger.debug((Object)"pk table is at left and lower");
                        if (lineStart.y - lineEnd.y > maxStringWidth || lineEnd.x - lineStart.x < lineStart.y - lineEnd.y) {
                            pkLabelDistance = midx + this.fm.getHeight();
                            fkLabelDistance = midx;
                            rotate = true;
                        } else {
                            pkLabelDistance = lineEnd.y - this.fm.getHeight();
                            fkLabelDistance = lineStart.y;
                        }
                    }
                }
                this.containmentPath.lineTo(midx, lineEnd.y);
                this.containmentPath.lineTo(midx, lineStart.y);
                this.containmentPath.moveTo(lineStart.x, lineStart.y);
            } else if ((orientation & 0xC) != 0 && (orientation & 0xC0) != 0) {
                int midy = Math.abs(lineEnd.y - lineStart.y) / 2 + Math.min(lineStart.y, lineEnd.y);
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineStart.x, midy);
                this.containmentPath.lineTo(lineEnd.x, midy);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                if (r.displayRelationshipLabel()) {
                    this.parentToChild.setIcon(null);
                    this.childToParent.setIcon(null);
                    if (lineStart.x > lineEnd.x) {
                        if (lineStart.y > lineEnd.y) {
                            logger.debug((Object)"pk table is at right and lower");
                            if (lineStart.x - lineEnd.x > maxStringWidth || lineStart.x - lineEnd.x > lineStart.y - lineEnd.y) {
                                pkLabelDistance = midy - this.fm.getHeight();
                                fkLabelDistance = midy;
                            } else {
                                pkLabelDistance = lineStart.x + this.fm.getHeight();
                                fkLabelDistance = lineEnd.x;
                                rotate = true;
                            }
                        } else {
                            logger.debug((Object)"pk table is at right and higher");
                            if (lineStart.x - lineEnd.x > maxStringWidth || lineStart.x - lineEnd.x > lineEnd.y - lineStart.y) {
                                pkLabelDistance = midy - this.fm.getHeight();
                                fkLabelDistance = midy;
                            } else {
                                pkLabelDistance = lineEnd.x;
                                fkLabelDistance = lineStart.x + this.fm.getHeight();
                                rotate = true;
                            }
                        }
                    } else if (lineStart.y > lineEnd.y) {
                        logger.debug((Object)"pk table is at left and lower");
                        if (lineEnd.x - lineStart.x > maxStringWidth || lineEnd.x - lineStart.x > lineStart.y - lineEnd.y) {
                            pkLabelDistance = midy - this.fm.getHeight();
                            fkLabelDistance = midy;
                        } else {
                            pkLabelDistance = lineEnd.x + this.fm.getHeight();
                            fkLabelDistance = lineStart.x;
                            rotate = true;
                        }
                    } else {
                        logger.debug((Object)"pk table is at left and higher");
                        if (lineEnd.x - lineStart.x > maxStringWidth || lineEnd.x - lineStart.x > lineEnd.y - lineStart.y) {
                            pkLabelDistance = midy - this.fm.getHeight();
                            fkLabelDistance = midy;
                        } else {
                            pkLabelDistance = lineEnd.x + this.fm.getHeight();
                            fkLabelDistance = lineStart.x;
                            rotate = true;
                        }
                    }
                }
                this.containmentPath.lineTo(lineEnd.x, midy);
                this.containmentPath.lineTo(lineStart.x, midy);
                this.containmentPath.moveTo(lineStart.x, lineStart.y);
            } else if ((orientation & 3) != 0) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineEnd.x, lineStart.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                if (r.displayRelationshipLabel()) {
                    this.parentToChild.setIcon(null);
                    this.childToParent.setIcon(null);
                    if (Math.abs(lineStart.x - lineEnd.x) > maxStringWidth || Math.abs(lineStart.x - lineEnd.x) > Math.abs(lineStart.y - lineEnd.y)) {
                        pkLabelDistance = lineStart.y - this.fm.getHeight();
                        fkLabelDistance = lineStart.y;
                    } else {
                        rotate = true;
                        pkLabelDistance = lineEnd.x + (this.getTerminationLength() + this.getTerminationWidth()) / 2;
                        fkLabelDistance = lineEnd.x - this.fm.getHeight() + (this.getTerminationLength() + this.getTerminationWidth()) / 2;
                    }
                }
                this.containmentPath.lineTo(lineEnd.x, lineStart.y);
                this.containmentPath.moveTo(lineStart.x, lineStart.y);
            } else if ((orientation & 0xC) != 0) {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineStart.x, lineEnd.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                if (r.displayRelationshipLabel()) {
                    this.parentToChild.setIcon(null);
                    this.childToParent.setIcon(null);
                    if (Math.abs(lineStart.x - lineEnd.x) > maxStringWidth || Math.abs(lineStart.x - lineEnd.x) > Math.abs(lineStart.y - lineEnd.y)) {
                        pkLabelDistance = lineEnd.y - this.fm.getHeight();
                        fkLabelDistance = lineEnd.y;
                    } else {
                        rotate = true;
                        pkLabelDistance = lineStart.x + (this.getTerminationLength() + this.getTerminationWidth()) / 2;
                        fkLabelDistance = lineStart.x - this.fm.getHeight() + (this.getTerminationLength() + this.getTerminationWidth()) / 2;
                    }
                }
                this.containmentPath.lineTo(lineStart.x, lineEnd.y);
                this.containmentPath.moveTo(lineStart.x, lineStart.y);
            } else {
                this.containmentPath.moveTo(start.x, start.y);
                this.containmentPath.lineTo(lineStart.x, lineStart.y);
                this.containmentPath.lineTo(lineEnd.x, lineEnd.y);
                this.containmentPath.lineTo(end.x, end.y);
                this.path = new GeneralPath(this.containmentPath);
                this.parentToChild.setIcon(null);
                this.childToParent.setIcon(null);
            }
            if (r.displayRelationshipLabel()) {
                Point childTranslate;
                Point parentTranslate;
                int mult;
                int n = mult = pkLabelDistance > fkLabelDistance ? 1 : -1;
                if (rotate) {
                    parentTranslate = new Point(pkLabelDistance + mult * this.fm.getDescent(), (int)parentToChildLabelStartY);
                    childTranslate = new Point(fkLabelDistance - mult * this.fm.getDescent(), (int)childToParentLabelStartY);
                } else {
                    parentTranslate = new Point((int)parentToChildLabelStartX, pkLabelDistance + mult * this.fm.getDescent());
                    childTranslate = new Point((int)childToParentLabelStartX, fkLabelDistance - mult * this.fm.getDescent());
                }
                this.drawLabel(g2, r, parentTranslate, childTranslate, (int)Math.min((float)pkStringWidth, rotate ? lowest - highest : rightmost - leftmost), (int)Math.min((float)fkStringWidth, rotate ? lowest - highest : rightmost - leftmost), this.fm.getHeight(), rotate);
            }
            if (!r.isSelected()) {
                g2.setColor(r.getForegroundColor());
            } else if (r.getForegroundColor().darker().equals(r.getForegroundColor())) {
                g2.setColor((Color)ColourScheme.SQLPOWER_ORANGE);
            } else {
                g2.setColor(r.getForegroundColor().darker());
            }
            Stroke oldStroke = g2.getStroke();
            if (this.relationship.getModel().isIdentifying()) {
                g2.setStroke(this.getIdentifyingStroke());
            } else {
                g2.setStroke(this.getNonIdentifyingStroke());
            }
            g2.draw(this.path);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Drew path " + this.path));
            }
            g2.setStroke(new BasicStroke(this.getStrokeWidth()));
            this.paintTerminations(g2, start, end, orientation);
            g2.setStroke(oldStroke);
        }
        finally {
            g2.translate(c.getX(), c.getY());
        }
    }

    public void drawLabel(Graphics2D g2, Relationship r, Point parentTranslate, Point childTranslate, int pkWidth, int fkWidth, int stringHeight, boolean rotate) {
        g2.translate(parentTranslate.x, parentTranslate.y);
        if (rotate) {
            g2.rotate(NINETY_DEGREES);
        }
        this.parentToChild.setText(r.getTextForParentLabel());
        this.parentToChild.setBounds(0, 0, pkWidth, stringHeight);
        if (logger.isDebugEnabled()) {
            this.drawBounds(this.parentToChild.getBounds(), g2);
        }
        this.parentToChild.paint(g2);
        if (rotate) {
            g2.rotate(-NINETY_DEGREES);
        }
        g2.translate(-parentTranslate.x, -parentTranslate.y);
        g2.translate(childTranslate.x, childTranslate.y);
        if (rotate) {
            g2.rotate(NINETY_DEGREES);
        }
        this.childToParent.setText(r.getTextForChildLabel());
        this.childToParent.setBounds(0, 0, fkWidth, stringHeight);
        if (logger.isDebugEnabled()) {
            this.drawBounds(this.childToParent.getBounds(), g2);
        }
        this.childToParent.paint(g2);
        if (rotate) {
            g2.rotate(-NINETY_DEGREES);
        }
        g2.translate(-childTranslate.x, -childTranslate.y);
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(this.relationship, p.x, p.y);
    }

    public boolean contains(PlayPenComponent c, int x, int y) {
        logger.debug((Object)("Contains, Looking for " + x + "," + y + " My bounds are: " + this.relationship.getBounds()));
        if (this.containmentPath == null) {
            return false;
        }
        return this.containmentPath.intersects(x - this.radius, y - this.radius, this.radius * 2, this.radius * 2);
    }

    @Override
    public boolean intersects(Rectangle region) {
        if (this.containmentPath == null) {
            return false;
        }
        return this.containmentPath.intersects(region.x, region.y, region.width, region.height);
    }

    public BasicRelationshipUI() {
    }

    BasicRelationshipUI(BasicRelationshipUI copy) {
        this.relationship = copy.getRelationship();
    }

    protected void paintTerminations(Graphics2D g2, Point start, Point end, int orientation) {
        Color oldColor = g2.getColor();
        g2.setColor(Color.red);
        g2.fillOval(start.x - 2, start.y - 2, 4, 4);
        g2.fillOval(end.x - 2, end.y - 2, 4, 4);
        g2.setColor(oldColor);
    }

    @Override
    public void bestConnectionPoints() {
        logger.debug((Object)"bestConnectionPoints()");
        Rectangle pktBounds = this.relationship.getPkTable().getBounds();
        Rectangle fktBounds = this.relationship.getFkTable().getBounds();
        ImmutablePoint fkConnectionPoint = this.relationship.createFkConnectionPoint();
        ImmutablePoint pkConnectionPoint = this.relationship.createPkConnectionPoint();
        int orientation = this.relationship.getOrientation();
        if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
            orientation = 36;
            this.relationship.setOrientation(orientation);
            this.relationship.setPkConnection(0.5);
            this.relationship.setFkConnection(0.5);
            logger.debug((Object)("Self-referencing table: set connection points pk=" + pkConnectionPoint + "; fk=" + fkConnectionPoint));
        } else {
            Line2D.Double pkToFkBorderLine = this.calcConnectionPoints(pktBounds, fktBounds);
            orientation = this.getFacingEdges(pktBounds, fktBounds);
            this.relationship.setOrientation(orientation);
            if ((orientation & 4) != 0 || (orientation & 8) != 0) {
                pkToFkBorderLine.x1 = Math.max((double)(pktBounds.x + this.getTerminationWidth()), pkToFkBorderLine.x1);
                pkToFkBorderLine.x1 = Math.min((double)(pktBounds.x + pktBounds.width - this.getTerminationWidth()), pkToFkBorderLine.x1);
            } else if ((orientation & 2) != 0 || (orientation & 1) != 0) {
                pkToFkBorderLine.y1 = Math.max((double)(pktBounds.y + this.getTerminationWidth()), pkToFkBorderLine.y1);
                pkToFkBorderLine.y1 = Math.min((double)(pktBounds.y + pktBounds.height - this.getTerminationWidth()), pkToFkBorderLine.y1);
            }
            if ((orientation & 0x40) != 0 || (orientation & 0x80) != 0) {
                pkToFkBorderLine.x2 = Math.max((double)(fktBounds.x + this.getTerminationWidth()), pkToFkBorderLine.x2);
                pkToFkBorderLine.x2 = Math.min((double)(fktBounds.x + fktBounds.width - this.getTerminationWidth()), pkToFkBorderLine.x2);
            } else if ((orientation & 0x20) != 0 || (orientation & 0x10) != 0) {
                pkToFkBorderLine.y2 = Math.max((double)(fktBounds.y + this.getTerminationWidth()), pkToFkBorderLine.y2);
                pkToFkBorderLine.y2 = Math.min((double)(fktBounds.y + fktBounds.height - this.getTerminationWidth()), pkToFkBorderLine.y2);
            }
            this.relationship.setPkConnectionPoint(new Point((int)(pkToFkBorderLine.x1 - (double)pktBounds.x), (int)(pkToFkBorderLine.y1 - (double)pktBounds.y)));
            this.relationship.setFkConnectionPoint(new Point((int)(pkToFkBorderLine.x2 - (double)fktBounds.x), (int)(pkToFkBorderLine.y2 - (double)fktBounds.y)));
        }
        this.fixConnectionPoints();
    }

    private Line2D.Double calcConnectionPoints(Rectangle pktBounds, Rectangle fktBounds) {
        Line2D.Double centreToCentreLine = new Line2D.Double(pktBounds.getCenterX(), pktBounds.getCenterY(), fktBounds.getCenterX(), fktBounds.getCenterY());
        Line2D.Double retval = new Line2D.Double();
        List<Point2D.Double> pkTableIntersectPoints = ASUtils.getIntersectPoints(pktBounds, centreToCentreLine);
        List<Point2D.Double> fkTableIntersectPoints = ASUtils.getIntersectPoints(fktBounds, centreToCentreLine);
        if (pkTableIntersectPoints.size() == 0) {
            logger.debug((Object)"Could not calculate intersection of pk tablepane bound and center line between pk/fk tablepanes, returning the top left corner");
            retval.x1 = pktBounds.x;
            retval.y1 = pktBounds.y;
        } else {
            retval.x1 = pkTableIntersectPoints.get((int)0).x;
            retval.y1 = pkTableIntersectPoints.get((int)0).y;
        }
        if (fkTableIntersectPoints.size() == 0) {
            logger.debug((Object)"Could not calculate intersection of fk tablepane bound and center line between pk/fk tablepanes, returning the top left corner");
            retval.x2 = fktBounds.x;
            retval.y2 = fktBounds.y;
        } else {
            retval.x2 = fkTableIntersectPoints.get((int)0).x;
            retval.y2 = fkTableIntersectPoints.get((int)0).y;
        }
        return retval;
    }

    @Override
    public Point closestEdgePoint(boolean onPkTable, Point p) {
        Point ep;
        TablePane tp = onPkTable ? this.relationship.getPkTable() : this.relationship.getFkTable();
        Dimension tpsize = tp.getSize();
        if (onPkTable) {
            Point sp = new Point(this.relationship.createFkConnectionPoint().getX(), this.relationship.createFkConnectionPoint().getY());
            ep = this.checkClosestPointOnTable(tpsize, sp, p, 2, 1, 8, 4, 240, true);
        } else {
            Point sp = new Point(this.relationship.createPkConnectionPoint().getX(), this.relationship.createPkConnectionPoint().getY());
            ep = this.checkClosestPointOnTable(tpsize, sp, p, 32, 16, 128, 64, 15, false);
        }
        return ep;
    }

    private Point checkClosestPointOnTable(Dimension tpsize, Point sp, Point p, int left, int right, int top, int bottom, int oppositeMask, boolean pkTable) {
        Point ep = new Point();
        int orientation = this.relationship.getOrientation();
        if ((orientation & left) != 0) {
            ep = new Point(0, Math.max(0, Math.min(tpsize.height, p.y)));
            logger.debug((Object)("ep is : " + ep + " sp is " + sp + " p is " + p));
            if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                ep.y = sp.y;
            }
            if (tpsize.height < p.y) {
                orientation = orientation & oppositeMask | bottom;
            } else if (p.y <= 0) {
                orientation = orientation & oppositeMask | top;
            }
            this.relationship.setOrientation(orientation);
            BasicRelationshipUI newRelation = new BasicRelationshipUI(this);
            if (pkTable) {
                newRelation.getRelationship().setPkConnectionPoint(ep);
            } else {
                newRelation.getRelationship().setFkConnectionPoint(ep);
            }
            if (!newRelation.isOrientationLegal()) {
                orientation = orientation & oppositeMask | left;
                this.relationship.setOrientation(orientation);
            }
        } else if ((orientation & right) != 0) {
            ep = new Point(tpsize.width, Math.max(0, Math.min(tpsize.height, p.y)));
            if (Math.abs(ep.y - sp.y) <= this.getSnapRadius()) {
                ep.y = sp.y;
            }
            if (tpsize.height < p.y) {
                orientation = orientation & oppositeMask | bottom;
            } else if (p.y <= 0) {
                orientation = orientation & oppositeMask | top;
            }
            this.relationship.setOrientation(orientation);
            BasicRelationshipUI newRelation = new BasicRelationshipUI(this);
            if (pkTable) {
                newRelation.getRelationship().setPkConnectionPoint(ep);
            } else {
                newRelation.getRelationship().setFkConnectionPoint(ep);
            }
            if (!newRelation.isOrientationLegal()) {
                orientation = orientation & oppositeMask | right;
            }
            this.relationship.setOrientation(orientation);
        } else if ((orientation & top) != 0) {
            ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), 0);
            if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                ep.x = sp.x;
            }
            if (tpsize.width < p.x) {
                orientation = orientation & oppositeMask | right;
            } else if (p.x <= 0) {
                orientation = orientation & oppositeMask | left;
            }
            this.relationship.setOrientation(orientation);
            BasicRelationshipUI newRelation = new BasicRelationshipUI(this);
            if (pkTable) {
                newRelation.getRelationship().setPkConnectionPoint(ep);
            } else {
                newRelation.getRelationship().setFkConnectionPoint(ep);
            }
            if (!newRelation.isOrientationLegal()) {
                orientation = orientation & oppositeMask | top;
            }
            this.relationship.setOrientation(orientation);
        } else if ((orientation & bottom) != 0) {
            ep = new Point(Math.max(0, Math.min(tpsize.width, p.x)), tpsize.height);
            if (Math.abs(ep.x - sp.x) <= this.getSnapRadius()) {
                ep.x = sp.x;
            }
            if (tpsize.width < p.x) {
                orientation = orientation & oppositeMask | right;
            } else if (p.x <= 0) {
                orientation = orientation & oppositeMask | left;
            }
            this.relationship.setOrientation(orientation);
            BasicRelationshipUI newRelation = new BasicRelationshipUI(this);
            if (pkTable) {
                newRelation.getRelationship().setPkConnectionPoint(ep);
            } else {
                newRelation.getRelationship().setFkConnectionPoint(ep);
            }
            if (!newRelation.isOrientationLegal()) {
                orientation = orientation & oppositeMask | bottom;
            }
            this.relationship.setOrientation(orientation);
        } else {
            ep = new Point(p);
        }
        return ep;
    }

    protected void translatePoint(Point modify, Point noModify) {
        modify.x += noModify.x;
        modify.y += noModify.y;
    }

    protected int getFacingEdges(Rectangle pktBounds, Rectangle fktBounds) {
        Line2D.Double intersectionLine = this.calcConnectionPoints(pktBounds, fktBounds);
        Point2D.Double pkIntersectPt = new Point2D.Double(intersectionLine.x1, intersectionLine.y1);
        Point2D.Double fkIntersectPt = new Point2D.Double(intersectionLine.x2, intersectionLine.y2);
        return this.getFacingEdges(pktBounds, fktBounds, pkIntersectPt, fkIntersectPt);
    }

    protected int getFacingEdges(Rectangle pktBounds, Rectangle fktBounds, Point2D.Double pkIntersectPt, Point2D.Double fkIntersectPt) {
        int retval = 0;
        if (pkIntersectPt.x == (double)pktBounds.x) {
            retval |= 2;
        } else if (pkIntersectPt.y == (double)pktBounds.y) {
            retval |= 8;
        } else if (pkIntersectPt.x == (double)(pktBounds.x + pktBounds.width)) {
            retval |= 1;
        } else if (pkIntersectPt.y == (double)(pktBounds.y + pktBounds.height)) {
            retval |= 4;
        } else {
            logger.error((Object)String.format("Unrecognised pktable orientation. pt=(%f,%f); bounds=(%d,%d %dx%d)", pkIntersectPt.x, pkIntersectPt.y, pktBounds.x, pktBounds.y, pktBounds.width, pktBounds.height));
        }
        if (fkIntersectPt.x == (double)fktBounds.x) {
            retval |= 0x20;
        } else if (fkIntersectPt.y == (double)fktBounds.y) {
            retval |= 0x80;
        } else if (fkIntersectPt.x == (double)(fktBounds.x + fktBounds.width)) {
            retval |= 0x10;
        } else if (fkIntersectPt.y == (double)(fktBounds.y + fktBounds.height)) {
            retval |= 0x40;
        } else {
            logger.error((Object)String.format("Unrecognised fktable orientation. pt=(%f,%f); bounds=(%d,%d %dx%d)", fkIntersectPt.x, fkIntersectPt.y, fktBounds.x, fktBounds.y, fktBounds.width, fktBounds.height));
        }
        return retval;
    }

    public int getTerminationLength() {
        return 5;
    }

    public int getTerminationWidth() {
        return 5;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    protected float getStrokeWidth() {
        if (this.relationship.isSelected()) {
            return this.selectedStrokeWidth;
        }
        return this.nonSelectedStrokeWidth;
    }

    public Stroke getIdentifyingStroke() {
        return new BasicStroke(this.getStrokeWidth());
    }

    public Stroke getNonIdentifyingStroke() {
        return new BasicStroke(this.getStrokeWidth());
    }

    public boolean isOrientationLegal() {
        ImmutablePoint fkConnectionPoint = this.relationship.createFkConnectionPoint();
        ImmutablePoint pkConnectionPoint = this.relationship.createPkConnectionPoint();
        int orientation = this.relationship.getOrientation();
        if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
            return orientation == 36;
        }
        if (orientation == 0) {
            return false;
        }
        Rectangle pkBounds = this.relationship.getPkTable().getBounds();
        Rectangle fkBounds = this.relationship.getFkTable().getBounds();
        Line2D.Double relationshipLine = new Line2D.Double(fkBounds.getX() + (double)fkConnectionPoint.getX(), fkBounds.getY() + (double)fkConnectionPoint.getY(), pkBounds.getX() + (double)pkConnectionPoint.getX(), pkBounds.getY() + (double)pkConnectionPoint.getY());
        List<Point2D.Double> pkTableIntersectPoints = ASUtils.getIntersectPoints(pkBounds, relationshipLine);
        List<Point2D.Double> fkTableIntersectPoints = ASUtils.getIntersectPoints(fkBounds, relationshipLine);
        if (pkTableIntersectPoints.size() <= 1 && fkTableIntersectPoints.size() <= 1) {
            logger.debug((Object)("intersect points to pkTable " + pkTableIntersectPoints.size() + " intersect points to fkTable " + fkTableIntersectPoints.size()));
            return true;
        }
        Point newParent = new Point();
        Point newChild = new Point();
        if (pkTableIntersectPoints.size() == 2 && pkTableIntersectPoints.get(0).equals(pkTableIntersectPoints.get(1))) {
            newParent = this.checkOrientationForCorner(pkConnectionPoint, orientation, 2, 1, 8, 4, 15);
        } else {
            newParent.setLocation(pkConnectionPoint.getX(), pkConnectionPoint.getY());
        }
        if (fkTableIntersectPoints.size() == 2 && fkTableIntersectPoints.get(0).equals(fkTableIntersectPoints.get(1))) {
            newChild = this.checkOrientationForCorner(fkConnectionPoint, orientation, 32, 16, 128, 64, 240);
        } else {
            newChild.setLocation(fkConnectionPoint.getX(), fkConnectionPoint.getY());
        }
        relationshipLine = new Line2D.Double(fkBounds.getX() + newChild.getX(), fkBounds.getY() + newChild.getY(), pkBounds.getX() + newParent.getX(), pkBounds.getY() + newParent.getY());
        pkTableIntersectPoints = ASUtils.getIntersectPoints(pkBounds, relationshipLine);
        fkTableIntersectPoints = ASUtils.getIntersectPoints(fkBounds, relationshipLine);
        if (pkTableIntersectPoints.size() <= 1 && fkTableIntersectPoints.size() <= 1) {
            logger.debug((Object)("intersect points to pkTable " + pkTableIntersectPoints.size() + " intersect points to fkTable " + fkTableIntersectPoints.size()));
            return true;
        }
        logger.debug((Object)"OrientationLegal() returning false");
        return false;
    }

    private Point checkOrientationForCorner(ImmutablePoint relationEndpoint, int orientation, int left, int right, int top, int bottom, int mask) {
        Point newEndpoint = new Point();
        int parentOrientation = orientation & mask;
        if (relationEndpoint.getX() == 0 && relationEndpoint.getY() == 0) {
            if (parentOrientation == left) {
                newEndpoint.setLocation(relationEndpoint.getX(), relationEndpoint.getY() + 1);
            } else if (parentOrientation == top) {
                newEndpoint.setLocation(relationEndpoint.getX() + 1, relationEndpoint.getY());
            }
        } else if (relationEndpoint.getX() == 0) {
            if (parentOrientation == left) {
                newEndpoint.setLocation(relationEndpoint.getX(), relationEndpoint.getY() - 1);
            } else if (parentOrientation == bottom) {
                newEndpoint.setLocation(relationEndpoint.getX() + 1, relationEndpoint.getY());
            }
        } else if (relationEndpoint.getY() == 0) {
            if (parentOrientation == top) {
                newEndpoint.setLocation(relationEndpoint.getX() - 1, relationEndpoint.getY());
            } else if (parentOrientation == right) {
                newEndpoint.setLocation(relationEndpoint.getX(), relationEndpoint.getY() + 1);
            }
        } else if (parentOrientation == right) {
            newEndpoint.setLocation(relationEndpoint.getX(), relationEndpoint.getY() - 1);
        } else if (parentOrientation == bottom) {
            newEndpoint.setLocation(relationEndpoint.getX() - 1, relationEndpoint.getY());
        }
        return newEndpoint;
    }

    public void fixConnectionPoints() {
        logger.debug((Object)"fixConnectionPoints()");
        PlayPen playPen = this.relationship.getPlayPen();
        Rectangle pktBounds = this.relationship.getPkTable().getBounds();
        Rectangle fktBounds = this.relationship.getFkTable().getBounds();
        int orientation = this.getFacingEdges(pktBounds, fktBounds);
        if (this.relationship.getPkTable() == this.relationship.getFkTable()) {
            orientation = 36;
        }
        boolean isPkConnectionPoint = true;
        TablePane table = this.relationship.getPkTable();
        ImmutablePoint lastValidPoint = this.relationship.createPkConnectionPoint();
        for (int i = 0; i < 2; ++i) {
            boolean collided;
            int count = 1;
            boolean[] outOfBounds = new boolean[]{false, false};
            do {
                collided = false;
                if (outOfBounds[count % 2]) {
                    collided = true;
                } else {
                    for (Relationship r : playPen.getContentPane().getChildren(Relationship.class)) {
                        Point connectionPoint;
                        if (r == this.relationship || r.getPkTable() != table && r.getFkTable() != table || !r.createPkConnectionPoint().equals(lastValidPoint) && !r.createFkConnectionPoint().equals(lastValidPoint)) continue;
                        collided = true;
                        int offset = count / 2;
                        if (count % 2 != 0) {
                            offset = (offset + 1) * -1;
                        }
                        if ((connectionPoint = this.adjustConnectionPoint(orientation, isPkConnectionPoint, offset)) == null) {
                            outOfBounds[count % 2] = true;
                            break;
                        }
                        lastValidPoint = new ImmutablePoint(connectionPoint);
                        break;
                    }
                }
                ++count;
            } while (collided && (!outOfBounds[0] || !outOfBounds[1]));
            if (isPkConnectionPoint) {
                this.relationship.setPkConnection((double)lastValidPoint.getX() / (double)this.relationship.getPkTable().getWidth());
            } else {
                this.relationship.setFkConnection((double)lastValidPoint.getX() / (double)this.relationship.getFkTable().getWidth());
            }
            isPkConnectionPoint = false;
            table = this.relationship.getFkTable();
            lastValidPoint = this.relationship.createFkConnectionPoint();
        }
    }

    private Point adjustConnectionPoint(int orientation, boolean isPkConnectionPoint, int offset) {
        ImmutablePoint connectionPoint;
        int[] orientations;
        Rectangle tBounds;
        logger.debug((Object)"adjustConnectionPoint()");
        if (isPkConnectionPoint) {
            tBounds = this.relationship.getPkTable().getBounds();
            orientations = new int[]{8, 1, 4, 2};
            connectionPoint = this.relationship.createPkConnectionPoint();
        } else {
            tBounds = this.relationship.getFkTable().getBounds();
            orientations = new int[]{128, 16, 64, 32};
            connectionPoint = this.relationship.createFkConnectionPoint();
        }
        int x = connectionPoint.getX();
        int y = connectionPoint.getY();
        if ((orientation & orientations[2]) != 0 || (orientation & orientations[0]) != 0 ? (x += offset * this.getTerminationWidth() * 2) < this.getTerminationWidth() || x > tBounds.width - this.getTerminationWidth() : !((orientation & orientations[3]) == 0 && (orientation & orientations[1]) == 0 || (y += offset * this.getTerminationWidth() * 2) >= this.getTerminationWidth() && y <= tBounds.height - this.getTerminationWidth())) {
            return null;
        }
        return new Point(x, y);
    }

    protected Rectangle computeBounds() {
        logger.debug((Object)"computeBounds()");
        TablePane pkTable = this.relationship.getPkTable();
        TablePane fkTable = this.relationship.getFkTable();
        ImmutablePoint fkConnectionPoint = this.relationship.createFkConnectionPoint();
        ImmutablePoint pkConnectionPoint = this.relationship.createPkConnectionPoint();
        if (!this.isOrientationLegal() && this.relationship.isMagicEnabled()) {
            this.bestConnectionPoints();
        }
        if (pkTable == fkTable) {
            Point topLeft = new Point(fkConnectionPoint.getX() - this.getTerminationLength() * 2 - this.radius, fkConnectionPoint.getY() - this.getTerminationWidth());
            Point bottomRight = new Point(pkConnectionPoint.getX() + this.getTerminationWidth(), pkConnectionPoint.getY() + this.radius + this.getTerminationLength() * 2);
            this.computedBounds = new Rectangle(topLeft.x + pkTable.getX(), topLeft.y + pkTable.getY(), bottomRight.x - topLeft.x, bottomRight.y - topLeft.y + this.fm.getHeight());
        } else {
            Point pkLimits = new Point(pkConnectionPoint.getX(), pkConnectionPoint.getY());
            pkLimits.translate(pkTable.getX(), pkTable.getY());
            Point fkLimits = new Point(fkConnectionPoint.getX(), fkConnectionPoint.getY());
            fkLimits.translate(fkTable.getX(), fkTable.getY());
            int orientation = this.relationship.getOrientation();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Absolute connection points: pk=" + pkLimits + "; fk=" + fkLimits));
            }
            Point topLeft = new Point();
            Point bottomRight = new Point();
            topLeft.x = pkTable.getX() > fkTable.getX() ? fkTable.getX() : pkTable.getX();
            int n = topLeft.y = pkTable.getY() > fkTable.getY() ? fkTable.getY() : pkTable.getY();
            bottomRight.x = (orientation & 2) != 0 ? pkLimits.x + this.getTerminationLength() : ((orientation & 0x20) != 0 ? fkLimits.x + this.getTerminationLength() : (pkLimits.x < fkLimits.x ? fkLimits.x + this.getTerminationWidth() : pkLimits.x + this.getTerminationWidth()));
            bottomRight.y = (orientation & 8) != 0 ? pkLimits.y + this.getTerminationLength() : ((orientation & 0x80) != 0 ? fkLimits.y + this.getTerminationLength() : (pkLimits.y < fkLimits.y ? fkLimits.y + this.getTerminationWidth() : pkLimits.y + this.getTerminationWidth()));
            int largestTermination = Math.max(this.getTerminationLength(), this.getTerminationWidth());
            topLeft.x -= largestTermination;
            topLeft.y -= largestTermination;
            this.computedBounds = new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            if (this.relationship.displayRelationshipLabel()) {
                this.computedBounds.width += this.fm.getHeight();
                this.computedBounds.height += this.fm.getHeight();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Updating bounds to " + this.computedBounds + " (topleft=" + topLeft + "; bottomRight=" + bottomRight + ")"));
            }
        }
        return this.computedBounds;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.relationship);
    }

    public Dimension getPreferredSize(PlayPenComponent c) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Computed size is [" + this.computedBounds.width + "," + this.computedBounds.height + "]"));
        }
        return new Dimension(this.computedBounds.width, this.computedBounds.height);
    }

    @Override
    public Point getPreferredLocation() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Computed locn is [" + this.computedBounds.x + "," + this.computedBounds.y + "]"));
        }
        return new Point(this.computedBounds.x, this.computedBounds.y);
    }

    @Override
    public boolean isOverPkDecoration(Point p) {
        ImmutablePoint pkPoint = this.relationship.createPkConnectionPoint();
        Point pkDec = new Point(pkPoint.getX() + this.relationship.getPkTable().getX() - this.relationship.getX(), pkPoint.getY() + this.relationship.getPkTable().getY() - this.relationship.getY());
        int orientation = this.relationship.getOrientation();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p=" + p + "; pkDec = " + pkDec + "; width=" + this.relationship.getWidth() + "; height=" + this.relationship.getHeight() + "; orientation=" + orientation));
        }
        if ((orientation & 0xC) != 0) {
            if (p.x < pkDec.x + 5 && p.x > pkDec.x - 5) {
                if ((orientation & 4) != 0) {
                    if ((orientation & 0x30) != 0) {
                        return p.y >= pkDec.y && p.y < this.relationship.getHeight();
                    }
                    return p.y >= pkDec.y && p.y < pkDec.y + this.relationship.getHeight() / 2;
                }
                if ((orientation & 0x30) != 0) {
                    return p.y <= pkDec.y && p.y > pkDec.y - this.relationship.getHeight();
                }
                return p.y <= pkDec.y && p.y > pkDec.y - this.relationship.getHeight() / 2;
            }
            return false;
        }
        if ((orientation & 2 | 1) != 0) {
            if (p.y < pkDec.y + 5 && p.y > pkDec.y - 5) {
                if ((orientation & 2) != 0) {
                    if ((orientation & 0xC0) != 0) {
                        return p.x <= pkDec.x && p.x >= pkDec.x - this.relationship.getWidth();
                    }
                    return p.x <= pkDec.x && p.x >= pkDec.x - this.relationship.getWidth() / 2;
                }
                if ((orientation & 0xC0) != 0) {
                    return p.x >= pkDec.x && p.x <= pkDec.x + this.relationship.getWidth();
                }
                return p.x >= pkDec.x && p.x <= pkDec.x + this.relationship.getWidth() / 2;
            }
            return false;
        }
        return ASUtils.distance(p, pkDec) < (double)Math.max(this.getTerminationWidth(), this.getTerminationLength());
    }

    @Override
    public boolean isOverFkDecoration(Point p) {
        ImmutablePoint fkPoint = this.relationship.createFkConnectionPoint();
        Point fkDec = new Point(fkPoint.getX() + this.relationship.getFkTable().getX() - this.relationship.getX(), fkPoint.getY() + this.relationship.getFkTable().getY() - this.relationship.getY());
        int orientation = this.relationship.getOrientation();
        if ((orientation & 0xC0) != 0) {
            if (p.x < fkDec.x + 5 && p.x > fkDec.x - 5) {
                if ((orientation & 0x40) != 0) {
                    if ((orientation & 3) != 0) {
                        return p.y >= fkDec.y && p.y < fkDec.y + this.relationship.getHeight();
                    }
                    return p.y >= fkDec.y && p.y < fkDec.y + this.relationship.getHeight() / 2;
                }
                if ((orientation & 3) != 0) {
                    return p.y <= fkDec.y && p.y > fkDec.y - this.relationship.getHeight();
                }
                return p.y <= fkDec.y && p.y > fkDec.y - this.relationship.getHeight() / 2;
            }
            return false;
        }
        if ((orientation & 0x20 | 0x10) != 0) {
            if (p.y < fkDec.y + 5 && p.y > fkDec.y - 5) {
                if ((orientation & 0x20) != 0) {
                    if ((orientation & 0xC) != 0) {
                        return p.x <= fkDec.x && p.x >= fkDec.x - this.relationship.getWidth();
                    }
                    return p.x <= fkDec.x && p.x >= fkDec.x - this.relationship.getWidth() / 2;
                }
                if ((orientation & 0xC) != 0) {
                    return p.x >= fkDec.x && p.x <= fkDec.x + this.relationship.getWidth();
                }
                return p.x >= fkDec.x && p.x <= fkDec.x + this.relationship.getWidth() / 2;
            }
            return false;
        }
        return ASUtils.distance(p, fkDec) < (double)Math.max(this.getTerminationWidth(), this.getTerminationLength());
    }

    @Override
    public boolean intersectsShape(Shape s) {
        List<Point2D.Double> list;
        if (this.path == null) {
            return false;
        }
        Rectangle myBounds = this.path.getBounds();
        Rectangle otherBounds = s.getBounds();
        if (myBounds.width == 0) {
            myBounds.width = 1;
        }
        if (myBounds.height == 0) {
            myBounds.height = 1;
        }
        if (otherBounds.width == 0) {
            otherBounds.width = 1;
        }
        if (otherBounds.height == 0) {
            otherBounds.height = 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("intersectsShape: my rectangle = " + myBounds));
            logger.debug((Object)("              other rectangle = " + otherBounds));
            logger.debug((Object)("intersectsShape: rectangles overlap? " + myBounds.intersects(otherBounds)));
        }
        if (!myBounds.intersects(otherBounds)) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("   myPI = " + this.pathIteratorToString(this.path.getPathIterator(null))));
            logger.debug((Object)("otherPI = " + this.pathIteratorToString(s.getPathIterator(null))));
        }
        return (list = this.getIntersectPoints(s)).size() > 0;
    }

    private List<Point2D.Double> getIntersectPoints(Shape s) {
        return ASUtils.getIntersectPoints(this.getShape(), s);
    }

    private String pathIteratorToString(PathIterator pathIterator) {
        StringBuffer sb = new StringBuffer();
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            sb.append("Type: " + type + "; coords: ");
            for (int i = 0; i < coords.length; ++i) {
                sb.append(coords[i]).append(',');
            }
            sb.append('\n');
            pathIterator.next();
        }
        return sb.toString();
    }

    @Override
    public Shape getShape() {
        return this.path;
    }

    @Override
    public int getShapeLength() {
        Rectangle b = this.path.getBounds();
        return b.width + b.height;
    }

    private float calculateRelationshipLabelStart(float smaller, float bigger, float StringWidth) {
        float x = bigger - smaller - StringWidth >= 0.0f ? smaller + (bigger - smaller - StringWidth) / 2.0f : smaller;
        return x;
    }

    @Override
    public Point getPointForModelObject(Object modelObject) {
        int sidesUsed = this.relationship.getOrientation() / 16 + this.relationship.getOrientation() % 16;
        Dimension preferredSize = this.getPreferredSize();
        if (sidesUsed == 12 || sidesUsed == 3) {
            return new Point(this.relationship.getLocation().x + preferredSize.width / 2 + 8, this.relationship.getLocation().y + preferredSize.height / 2 - 4);
        }
        return new Point(this.relationship.getLocation().x + (sidesUsed % 2 == 1 ? preferredSize.width - 25 : 44), this.relationship.getLocation().y + (sidesUsed >= 8 ? 24 : preferredSize.height - 32));
    }

    public void drawBounds(Rectangle r, Graphics2D g2) {
        Color temp = g2.getColor();
        g2.setColor(Color.blue);
        g2.drawRect(r.x, r.y, r.width, r.height);
        g2.setColor(temp);
    }

    public static class ImmutablePoint {
        Point p;

        public ImmutablePoint(Point p) {
            this.p = p;
        }

        public int getX() {
            return (int)this.p.getX();
        }

        public int getY() {
            return (int)this.p.getY();
        }

        public boolean equals(ImmutablePoint p) {
            return this.getX() == p.getX() && this.getY() == p.getY();
        }

        public boolean equals(Point p) {
            return this.equals(new ImmutablePoint(p));
        }
    }
}

