/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.BalanceStrategy;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.NonRegisteringDriver;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    public static final String BLACKLIST_TIMEOUT_PROPERTY_KEY = "loadBalanceBlacklistTimeout";
    private Connection currentConn;
    private List hostList;
    private Map liveConnections;
    private Map connectionsToHostsMap;
    private long[] responseTimes;
    private Map hostsToListIndexMap;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private Properties localProps;
    private boolean isClosed = false;
    private BalanceStrategy balancer;
    private int retriesAllDown;
    private static Map globalBlacklist;
    private int globalBlacklistTimeout = 0;
    static /* synthetic */ Class class$java$lang$System;

    LoadBalancingConnectionProxy(List hosts, Properties props) throws SQLException {
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap(numHosts);
        this.connectionsToHostsMap = new HashMap(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap(numHosts);
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
        }
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty(BLACKLIST_TIMEOUT_PROPERTY_KEY, "0");
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.RandomBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.mysql.jdbc.BestResponseTimeBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null).get(0));
        this.balancer.init(null, props);
        this.pickNewConnection();
    }

    public synchronized Connection createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        if (hostPortPair[1] == null) {
            hostPortPair[1] = "3306";
        }
        connProps.setProperty("HOST", hostPortSpec);
        connProps.setProperty("PORT", hostPortPair[1]);
        Connection conn = ConnectionImpl.getInstance(hostPortSpec, Integer.parseInt(hostPortPair[1]), connProps, connProps.getProperty("DBNAME"), "jdbc:mysql://" + hostPortPair[0] + ":" + hostPortPair[1] + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            String sqlState;
            if (t instanceof SQLException && (sqlState = ((SQLException)t).getSQLState()) != null && sqlState.startsWith("08")) {
                this.invalidateCurrentConnection();
            }
            throw t;
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void invalidateCurrentConnection() throws SQLException {
        try {
            if (!this.currentConn.isClosed()) {
                this.currentConn.close();
            }
            Object var2_1 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist((String)this.connectionsToHostsMap.get(this.currentConn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist((String)this.connectionsToHostsMap.get(this.currentConn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
            Object mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
            if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) throw throwable;
            int hostIndex = (Integer)this.hostsToListIndexMap.get(mappedHost);
            long[] lArray = this.responseTimes;
            synchronized (this.responseTimes) {
                this.responseTimes[hostIndex] = 0L;
                // ** MonitorExit[var5_8] (shouldn't be in output)
                throw throwable;
            }
        }
        Object mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
        if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = (Integer)this.hostsToListIndexMap.get(mappedHost);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator allConnections = this.liveConnections.values().iterator();
            while (allConnections.hasNext()) {
                try {
                    ((Connection)allConnections.next()).close();
                }
                catch (SQLException sQLException) {}
            }
            if (!this.isClosed) {
                this.balancer.destroy();
            }
            this.liveConnections.clear();
            this.connectionsToHostsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("equals".equals(methodName) && args.length == 1) {
            if (!(args[0] instanceof Proxy)) return this.equals(args[0]);
            return ((Proxy)args[0]).equals(this);
        }
        if ("hashCode".equals(methodName)) {
            return new Integer(this.hashCode());
        }
        if ("close".equals(methodName)) {
            this.closeAllConnections();
            return null;
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003", null);
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
        }
        Object result = null;
        try {
            block21: {
                try {
                    result = method.invoke((Object)this.currentConn, args);
                    if (result == null) break block21;
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                    }
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
                catch (InvocationTargetException e) {
                    this.dealWithInvocationException(e);
                    Object var8_7 = null;
                    if (!"commit".equals(methodName)) {
                        if (!"rollback".equals(methodName)) return result;
                    }
                    this.inTransaction = false;
                    String host = (String)this.connectionsToHostsMap.get(this.currentConn);
                    if (host != null) {
                        int hostIndex = (Integer)this.hostsToListIndexMap.get(host);
                        long[] lArray = this.responseTimes;
                        // MONITORENTER : this.responseTimes
                        this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                        // MONITOREXIT : lArray
                    }
                    this.pickNewConnection();
                    return result;
                }
            }
            Object var8_6 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) return result;
            }
            this.inTransaction = false;
            String host = (String)this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                int hostIndex = (Integer)this.hostsToListIndexMap.get(host);
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            return result;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) throw throwable;
            }
            this.inTransaction = false;
            String host = (String)this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                int hostIndex = (Integer)this.hostsToListIndexMap.get(host);
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            throw throwable;
        }
    }

    private synchronized void pickNewConnection() throws SQLException {
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        Connection newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
        newConn.setTransactionIsolation(this.currentConn.getTransactionIsolation());
        newConn.setAutoCommit(this.currentConn.getAutoCommit());
        this.currentConn = newConn;
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz) {
        int i = 0;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (i < interfaces.length) {
            String packageName = interfaces[i].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName) || "com.mysql.jdbc".equals(packageName)) {
                return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfaces, (InvocationHandler)new ConnectionErrorFiringInvocationHandler(toProxy));
            }
            return this.proxyIfInterfaceIsJdbc(toProxy, interfaces[i]);
        }
        return toProxy;
    }

    private static long getLocalTimeBestResolution() {
        if (getLocalTimeMethod != null) {
            try {
                return (Long)getLocalTimeMethod.invoke(null, null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator i = this.hostList.iterator();
            while (i.hasNext()) {
                String host = (String)i.next();
                Connection conn = (Connection)this.liveConnections.get(host);
                if (conn == null) continue;
                try {
                    conn.ping();
                    foundHost = true;
                }
                catch (SQLException e) {
                    if (host.equals(this.connectionsToHostsMap.get(this.currentConn))) {
                        this.closeAllConnections();
                        this.isClosed = true;
                        throw e;
                    }
                    if (e.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                        if (se == null) {
                            se = e;
                        }
                    } else {
                        se = e;
                        if (this.isGlobalBlacklistEnabled()) {
                            this.addToGlobalBlacklist(host);
                        }
                    }
                    this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                }
            }
        }
        if (!foundHost) {
            this.closeAllConnections();
            this.isClosed = true;
            if (se != null) {
                throw se;
            }
            ((ConnectionImpl)this.currentConn).throwConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host) {
        if (this.isGlobalBlacklistEnabled()) {
            Map map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, new Long(System.currentTimeMillis() + (long)this.globalBlacklistTimeout));
            }
        }
    }

    public boolean isGlobalBlacklistEnabled() {
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGlobalBlacklist() {
        if (!this.isGlobalBlacklistEnabled()) {
            return new HashMap(1);
        }
        HashMap blacklistClone = new HashMap(globalBlacklist.size());
        Map map = globalBlacklist;
        synchronized (map) {
            blacklistClone.putAll(globalBlacklist);
        }
        Set keys = blacklistClone.keySet();
        keys.retainAll(this.hostList);
        if (keys.size() == this.hostList.size()) {
            return new HashMap(1);
        }
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String host = (String)i.next();
            Long timeout = (Long)globalBlacklist.get(host);
            if (timeout == null || timeout >= System.currentTimeMillis()) continue;
            Map map2 = globalBlacklist;
            synchronized (map2) {
                globalBlacklist.remove(host);
            }
            i.remove();
        }
        return blacklistClone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            getLocalTimeMethod = (class$java$lang$System == null ? (class$java$lang$System = LoadBalancingConnectionProxy.class$("java.lang.System")) : class$java$lang$System).getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        globalBlacklist = new HashMap();
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            return result;
        }
    }
}

