untrusted comment: signature from openbsd 5.7 base secret key
RWSvUZXnw9gUb8vNDYBGp1TsHUcH29QGc6aLBaXKj2RqkDSjc6JefFn6l8hkUtxK/TUZesvTgIR8mqjr2saXQALAHG5Rbq7TMAQ=

OpenBSD 5.7 errata 11, Jul 26, 2015:

A kernel memory leak could be triggered by an unprivileged user in
a failure case when using execve under systrace.

Apply by doing:
    signify -Vep /etc/signify/openbsd-57-base.pub -x 011_execve.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/kern/kern_exec.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_exec.c,v
retrieving revision 1.160
diff -u -p -r1.160 kern_exec.c
--- sys/kern/kern_exec.c	9 Feb 2015 11:52:47 -0000	1.160
+++ sys/kern/kern_exec.c	27 Jul 2015 00:23:35 -0000
@@ -785,12 +785,12 @@ exec_abort:
 
 free_pack_abort:
 	free(pack.ep_hdr, M_EXEC, 0);
+	if (pathbuf != NULL)
+		pool_put(&namei_pool, pathbuf);
 	exit1(p, W_EXITCODE(0, SIGABRT), EXIT_NORMAL);
 
 	/* NOTREACHED */
 	atomic_clearbits_int(&pr->ps_flags, PS_INEXEC);
-	if (pathbuf != NULL)
-		pool_put(&namei_pool, pathbuf);
 
 	return (0);
 }
