/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.ColonyTradeItem;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.util.Utils;

public class GoodsTradeItem
extends TradeItem {
    public static final String TAG = "goodsTradeItem";
    protected Goods goods;

    public GoodsTradeItem(Game game, Player source, Player destination, Goods goods) {
        super(game, Messages.nameKey("model.tradeItem.goods"), source, destination);
        this.goods = goods;
    }

    public GoodsTradeItem(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(game, xr);
    }

    @Override
    public boolean isValid() {
        return this.goods != null && this.goods.getType() != null && this.goods.getAmount() > 0 && this.goods.getLocation() instanceof Ownable && this.getSource().owns((Ownable)((Object)this.goods.getLocation()));
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public StringTemplate getLabel() {
        return this.goods.getLabel(true);
    }

    @Override
    public Goods getGoods() {
        return this.goods;
    }

    @Override
    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    @Override
    public int evaluateFor(Player player) {
        Market market = player.getMarket();
        Goods goods = this.getGoods();
        return !this.isValid() ? Integer.MIN_VALUE : (this.getSource() == player ? (market == null ? -2 * goods.getAmount() : market.getBidPrice(goods.getType(), goods.getAmount())) : (market == null ? 2 * goods.getAmount() : (int)Math.round((double)market.getSalePrice(goods.getType(), goods.getAmount()) * (1.0 - (double)player.getTax() / 100.0))));
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.goods.toXML(xw);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.goods = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if ("goods".equals(tag)) {
            this.goods = new Goods(game, xr);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ColonyTradeItem o = this.copyInCast(other, ColonyTradeItem.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Goods g = o.getGoods();
        if (g == null) {
            this.goods = null;
        } else if (this.goods == null) {
            this.goods = g;
        } else {
            return this.goods.copyIn(g);
        }
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof GoodsTradeItem) {
            return Utils.equals(this.goods, ((GoodsTradeItem)other).goods) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + Utils.hashCode(this.goods);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.goods.getAmount()).append(' ').append(Messages.getName(this.goods)).append(']');
        return sb.toString();
    }
}

