/*
 * chewing.h
 *
 * Copyright (c) 2004, 2005, 2006, 2008
 *      libchewing Core Team. See ChangeLog for details.
 *
 * See the file "COPYING" for information on usage and redistribution
 * of this file.
 */

/* *INDENT-OFF* */
#ifndef _CHEWING_CORE_
#define _CHEWING_CORE_
/* *INDENT-ON* */

#ifdef __cplusplus
extern "C" {
#endif

/*! \file chewing.h
 *  \brief Chewing Headers
 *  \author libchewing Core Team
 *  \mainpage Chewing API
 *
 * <center>API Collection of Chewing intelligent Chinese
 *         phonetic IM (Input Method).</center>
 *
 * <h1>Overview</h1>
 *
 * As far as we expect, input method (in fact, the way for text input and
 * output, especially in multi-lingual environments) implementations are
 * becoming more and more complex in system integrations.  The emerging
 * standard for practical and flexible development cycles is required, so that
 * we are facing the impacts from various Chinese input method implementations
 * and the integration into existing framework or system designs.  At the
 * result, Chewing Input Method (abbreviated as "Chewing") attempts to be one
 * of the approaches to solve and ease the problems with the inclusion of base
 * classes, on the basis of cross-platform, and cross-operating-environment
 * derivative classes, which are built as the abstract backbone of intelligent
 * Chinese phonetic input method implementations.  From the perspectives,
 * Chewing defines the abstract behavior how an intelligent phonetic IM should
 * works via the common interface, and Chewing permits the extra parameters
 * and properties for the input method implementations to extend their
 * specific functionality.
 */

#ifdef WITH_RUST
#   include "chewing_rs.h"
#else
#   include "global.h"
#endif
#include "chewingio.h"
#include "mod_aux.h"

/* backward compatibility */
#include "chewing-compat.h"

#ifdef __cplusplus
}
#endif
/* *INDENT-OFF* */
#endif                          /* _CHEWING_CORE_ */
/* *INDENT-ON* */
