/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.math.ec.rfc7748.X25519;
import org.bouncycastle.util.Arrays;

public class ForgivingX25519Curve {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int ELEMENT_SIZE = 32;

    public static byte[] computePublicKey(BigInteger privateKey) {
        return ForgivingX25519Curve.computePublicKey(privateKey.toByteArray());
    }

    public static byte[] computePublicKey(byte[] privateKey) {
        X25519.precompute();
        if (privateKey.length > 32) {
            LOGGER.debug("privatekey has is longer than 32 bytes. Using only first 32 bytes.");
            privateKey = Arrays.copyOfRange((byte[])privateKey, (int)0, (int)32);
        } else if (privateKey.length < 32) {
            LOGGER.debug("privatekey has is shorter than 32 bytes. Padding with 0x00...");
            privateKey = Arrays.copyOf((byte[])privateKey, (int)32);
        }
        byte[] publicKey = new byte[32];
        X25519.scalarMultBase((byte[])privateKey, (int)0, (byte[])publicKey, (int)0);
        return publicKey;
    }

    public static byte[] computeSharedSecret(BigInteger privateKey, byte[] publicKey) {
        return ForgivingX25519Curve.computeSharedSecret(privateKey.toByteArray(), publicKey);
    }

    public static byte[] computeSharedSecret(byte[] privateKey, byte[] publicKey) {
        if (privateKey.length > 32) {
            LOGGER.debug("privatekey is longer than 32 bytes. Using only first 32 bytes.");
            privateKey = Arrays.copyOfRange((byte[])privateKey, (int)0, (int)32);
        } else if (privateKey.length < 32) {
            LOGGER.debug("privatekey is shorter than 32 bytes. Padding with 0x00...");
            privateKey = Arrays.copyOf((byte[])privateKey, (int)32);
        }
        if (publicKey.length > 32) {
            LOGGER.debug("publicKey is longer than 32 bytes. Using only first 32 bytes.");
            publicKey = Arrays.copyOfRange((byte[])publicKey, (int)0, (int)32);
        } else if (publicKey.length < 32) {
            LOGGER.debug("publicKey is shorter than 32 bytes. Padding with 0x00...");
            publicKey = Arrays.copyOf((byte[])publicKey, (int)32);
        }
        byte[] sharedSecret = new byte[32];
        X25519.scalarMult((byte[])privateKey, (int)0, (byte[])publicKey, (int)0, (byte[])sharedSecret, (int)0);
        return sharedSecret;
    }

    private ForgivingX25519Curve() {
    }
}

