/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;

public final class BevelBorder
implements Border {
    private boolean raised;
    private Color color;
    private ResourceTableListener listener = null;

    public BevelBorder(boolean bl, Color color) {
        this.raised = bl;
        this.color = color;
    }

    public BevelBorder(boolean bl, String string, Widget widget) {
        this(bl, string, widget.getResourceTable());
    }

    public BevelBorder(boolean bl, String string, ResourceTable resourceTable) {
        this.raised = bl;
        Object object = resourceTable.getProperty(string);
        if (object instanceof Color) {
            this.color = (Color)object;
        }
        this.listener = new ResourceTableListener();
        resourceTable.addPropertyChangeListener(string, this.listener);
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setColor(this.color);
        int n = rectangle.height;
        int n2 = rectangle.width;
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.setColor(this.raised ? this.color.brighter().brighter() : this.color.darker().darker());
        graphics2D.drawLine(0, 0, 0, n - 2);
        graphics2D.drawLine(1, 0, n2 - 2, 0);
        graphics2D.setColor(this.raised ? this.color.brighter() : this.color.darker());
        graphics2D.drawLine(1, 1, 1, n - 3);
        graphics2D.drawLine(2, 1, n2 - 3, 1);
        graphics2D.setColor(this.raised ? this.color.darker().darker() : this.color.brighter().brighter());
        graphics2D.drawLine(0, n - 1, n2 - 1, n - 1);
        graphics2D.drawLine(n2 - 1, 0, n2 - 1, n - 2);
        graphics2D.setColor(this.raised ? this.color.darker() : this.color.brighter());
        graphics2D.drawLine(1, n - 2, n2 - 2, n - 2);
        graphics2D.drawLine(n2 - 2, 1, n2 - 2, n - 3);
        graphics2D.translate(-rectangle.x, -rectangle.y);
    }

    public boolean isOpaque() {
        return true;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BevelBorder.this.color = (Color)propertyChangeEvent.getNewValue();
        }
    }
}

