/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * clamp(vec2(-2.0, -2.0), vec2(-1.5, -1.5), vec2(-1.5, 0.0)) => vec2(-1.5, -1.5)
 * clamp(vec2(-2.0, -2.0), vec2(-1.5, 0.0), vec2(1.5, 0.0)) => vec2(-1.5, 0.0)
 * clamp(vec2(-2.0, -2.0), vec2(0.0, 1.5), vec2(1.5, 1.5)) => vec2(0.0, 1.5)
 * clamp(vec2(-0.6666667, -0.6666667), vec2(-1.5, -1.5), vec2(-1.5, 0.0)) => vec2(-1.5, -0.6666667)
 * clamp(vec2(-0.6666667, -0.6666667), vec2(-1.5, 0.0), vec2(1.5, 0.0)) => vec2(-0.6666667, 0.0)
 * clamp(vec2(-0.6666667, -0.6666667), vec2(0.0, 1.5), vec2(1.5, 1.5)) => vec2(0.0, 1.5)
 * clamp(vec2(0.6666667, 0.6666667), vec2(-1.5, -1.5), vec2(-1.5, 0.0)) => vec2(-1.5, 0.0)
 * clamp(vec2(0.6666667, 0.6666667), vec2(-1.5, 0.0), vec2(1.5, 0.0)) => vec2(0.6666667, 0.0)
 * clamp(vec2(0.6666667, 0.6666667), vec2(0.0, 1.5), vec2(1.5, 1.5)) => vec2(0.6666667, 1.5)
 * clamp(vec2(2.0, 2.0), vec2(-1.5, -1.5), vec2(-1.5, 0.0)) => vec2(-1.5, 0.0)
 * clamp(vec2(2.0, 2.0), vec2(-1.5, 0.0), vec2(1.5, 0.0)) => vec2(1.5, 0.0)
 * clamp(vec2(2.0, 2.0), vec2(0.0, 1.5), vec2(1.5, 1.5)) => vec2(1.5, 1.5)
 */
#version 120

void main()
{
  float[distance(clamp(vec2(-2.0, -2.0), vec2(-1.5, -1.5), vec2(-1.5, 0.0)), vec2(-1.5, -1.5)) <= 2.1213204e-05 ? 1 : -1] array0;
  float[distance(clamp(vec2(-2.0, -2.0), vec2(-1.5, 0.0), vec2(1.5, 0.0)), vec2(-1.5, 0.0)) <= 1.5e-05 ? 1 : -1] array1;
  float[distance(clamp(vec2(-2.0, -2.0), vec2(0.0, 1.5), vec2(1.5, 1.5)), vec2(0.0, 1.5)) <= 1.5e-05 ? 1 : -1] array2;
  float[distance(clamp(vec2(-0.6666667, -0.6666667), vec2(-1.5, -1.5), vec2(-1.5, 0.0)), vec2(-1.5, -0.6666667)) <= 1.6414762e-05 ? 1 : -1] array3;
  float[distance(clamp(vec2(-0.6666667, -0.6666667), vec2(-1.5, 0.0), vec2(1.5, 0.0)), vec2(-0.6666667, 0.0)) <= 6.6666666e-06 ? 1 : -1] array4;
  float[distance(clamp(vec2(-0.6666667, -0.6666667), vec2(0.0, 1.5), vec2(1.5, 1.5)), vec2(0.0, 1.5)) <= 1.5e-05 ? 1 : -1] array5;
  float[distance(clamp(vec2(0.6666667, 0.6666667), vec2(-1.5, -1.5), vec2(-1.5, 0.0)), vec2(-1.5, 0.0)) <= 1.5e-05 ? 1 : -1] array6;
  float[distance(clamp(vec2(0.6666667, 0.6666667), vec2(-1.5, 0.0), vec2(1.5, 0.0)), vec2(0.6666667, 0.0)) <= 6.6666666e-06 ? 1 : -1] array7;
  float[distance(clamp(vec2(0.6666667, 0.6666667), vec2(0.0, 1.5), vec2(1.5, 1.5)), vec2(0.6666667, 1.5)) <= 1.6414762e-05 ? 1 : -1] array8;
  float[distance(clamp(vec2(2.0, 2.0), vec2(-1.5, -1.5), vec2(-1.5, 0.0)), vec2(-1.5, 0.0)) <= 1.5e-05 ? 1 : -1] array9;
  float[distance(clamp(vec2(2.0, 2.0), vec2(-1.5, 0.0), vec2(1.5, 0.0)), vec2(1.5, 0.0)) <= 1.5e-05 ? 1 : -1] array10;
  float[distance(clamp(vec2(2.0, 2.0), vec2(0.0, 1.5), vec2(1.5, 1.5)), vec2(1.5, 1.5)) <= 2.1213204e-05 ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
