/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.starter;

import java.io.File;
import org.jivesoftware.openfire.starter.JiveClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStarter {
    private static final Logger Log = LoggerFactory.getLogger(ServerStarter.class);
    private static final String DEFAULT_LIB_DIR = "../lib";

    public static void main(String[] args) {
        new ServerStarter().start();
    }

    private void start() {
        try {
            File libDir;
            ClassLoader parent = this.findParentClassLoader();
            String libDirString = System.getProperty("openfire.lib.dir");
            if (libDirString != null) {
                libDir = new File(libDirString);
                if (!libDir.exists()) {
                    Log.warn("Lib directory " + libDirString + " does not exist. Using default " + DEFAULT_LIB_DIR);
                    libDir = new File(DEFAULT_LIB_DIR);
                }
            } else {
                libDir = new File(DEFAULT_LIB_DIR);
            }
            JiveClassLoader loader = new JiveClassLoader(parent, libDir);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> containerClass = loader.loadClass("org.jivesoftware.openfire.XMPPServer");
            containerClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ClassLoader findParentClassLoader() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null && (parent = this.getClass().getClassLoader()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return parent;
    }
}

