/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.metadata.AttributeAuthorityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAssertinIDRequestServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAttributeParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAttributeServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLRoleDecriptorTypeParser;

public class SAMLAttributeAuthorityDescriptorParser
extends SAMLRoleDecriptorTypeParser<AttributeAuthorityDescriptorType> {
    private static final SAMLAttributeAuthorityDescriptorParser INSTANCE = new SAMLAttributeAuthorityDescriptorParser();

    public SAMLAttributeAuthorityDescriptorParser() {
        super(SAMLMetadataQNames.ATTRIBUTE_AUTHORITY_DESCRIPTOR);
    }

    public static SAMLAttributeAuthorityDescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected AttributeAuthorityDescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        List<String> protocolEnum = StaxParserUtil.getRequiredStringListAttributeValue(element, SAMLMetadataQNames.ATTR_PROTOCOL_SUPPORT_ENUMERATION);
        AttributeAuthorityDescriptorType descriptor = new AttributeAuthorityDescriptorType(protocolEnum);
        this.parseOptionalArguments(element, (RoleDescriptorType)descriptor);
        return descriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, AttributeAuthorityDescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ATTRIBUTE_SERVICE: {
                target.addAttributeService((EndpointType)SAMLAttributeServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ASSERTION_ID_REQUEST_SERVICE: {
                target.addAssertionIDRequestService((EndpointType)SAMLAssertinIDRequestServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case NAMEID_FORMAT: {
                StaxParserUtil.advance(xmlEventReader);
                target.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            case ATTRIBUTE_PROFILE: {
                StaxParserUtil.advance(xmlEventReader);
                target.addAttributeProfile(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            case ATTRIBUTE: {
                target.addAttribute((AttributeType)SAMLAttributeParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                super.processSubElement(xmlEventReader, target, element, elementDetail);
            }
        }
    }
}

