/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.immutable.artifact;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.model.ComponentArtifactMetadata;

public class ImmutableArtifactTypeRegistry {
    private final AttributesFactory attributesFactory;
    private final ImmutableMap<String, ImmutableAttributes> mappings;
    private final ImmutableAttributes defaultArtifactAttributes;
    private final int hashCode;

    public ImmutableArtifactTypeRegistry(AttributesFactory attributesFactory, ImmutableMap<String, ImmutableAttributes> mappings, ImmutableAttributes defaultArtifactAttributes) {
        this.attributesFactory = attributesFactory;
        this.mappings = mappings;
        this.defaultArtifactAttributes = defaultArtifactAttributes;
        this.hashCode = ImmutableArtifactTypeRegistry.computeHashCode(mappings, defaultArtifactAttributes);
    }

    public ImmutableMap<String, ImmutableAttributes> getMappings() {
        return this.mappings;
    }

    public ImmutableAttributes getDefaultArtifactAttributes() {
        return this.defaultArtifactAttributes;
    }

    public void visitArtifactTypeAttributes(Collection<TransformRegistration> transformRegistrations, Consumer<? super ImmutableAttributes> action) {
        Consumer<ImmutableAttributes> visitor = attributes -> {
            ImmutableAttributes attributesPlusDefaults = this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), attributes);
            action.accept(attributesPlusDefaults);
        };
        HashSet<String> seen = new HashSet<String>();
        for (Map.Entry artifactTypeDefinition : this.mappings.entrySet()) {
            if (!seen.add((String)artifactTypeDefinition.getKey())) continue;
            ImmutableAttributes attributes2 = (ImmutableAttributes)artifactTypeDefinition.getValue();
            attributes2 = this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)((String)artifactTypeDefinition.getKey())), attributes2);
            visitor.accept(attributes2);
        }
        for (TransformRegistration registration : transformRegistrations) {
            ImmutableAttributes sourceAttributes = registration.getFrom();
            String format = (String)sourceAttributes.getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            if (format == null || !seen.add(format)) continue;
            ImmutableAttributes attributes3 = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)format);
            visitor.accept(attributes3);
        }
        if (seen.add("directory")) {
            ImmutableAttributes directory = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
            visitor.accept(directory);
        }
    }

    public ImmutableAttributes mapAttributesFor(File file) {
        ImmutableAttributes withoutDefaultAttributes = this.mapWithoutDefaultAttributesFor(file);
        return this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), withoutDefaultAttributes);
    }

    private ImmutableAttributes mapWithoutDefaultAttributesFor(File file) {
        if (file.isDirectory()) {
            return this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        }
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        String extension = Files.getFileExtension((String)file.getName());
        attributes = this.applyForExtension(attributes, extension);
        return this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)extension), attributes);
    }

    public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        ImmutableAttributes withoutDefaultAttributes = this.mapWithoutDefaultAttributesFor(attributes, artifacts);
        return this.attributesFactory.concat(this.defaultArtifactAttributes.asImmutable(), withoutDefaultAttributes);
    }

    private ImmutableAttributes mapWithoutDefaultAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        if (!this.mappings.isEmpty()) {
            String extension = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateExtension = componentArtifactMetadata.getName().getExtension();
                if (extension == null) {
                    extension = candidateExtension;
                    continue;
                }
                if (extension.equals(candidateExtension)) continue;
                extension = null;
                break;
            }
            if (extension != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
        }
        if (!attributes.contains(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE)) {
            String format = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateFormat = componentArtifactMetadata.getName().getType();
                if (format == null) {
                    format = candidateFormat;
                    continue;
                }
                if (format.equals(candidateFormat)) continue;
                format = null;
                break;
            }
            if (format != null) {
                attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, format);
            }
        }
        return attributes;
    }

    private ImmutableAttributes applyForExtension(ImmutableAttributes attributes, String extension) {
        ImmutableAttributes definition = (ImmutableAttributes)this.mappings.get((Object)extension);
        if (definition != null) {
            attributes = this.attributesFactory.concat(definition, attributes);
        }
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableArtifactTypeRegistry that = (ImmutableArtifactTypeRegistry)o;
        return this.mappings.equals(that.mappings) && this.defaultArtifactAttributes.equals(that.defaultArtifactAttributes);
    }

    private static int computeHashCode(ImmutableMap<String, ImmutableAttributes> mappings, ImmutableAttributes defaultArtifactAttributes) {
        int result = mappings.hashCode();
        result = 31 * result + defaultArtifactAttributes.hashCode();
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

