/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.transformation.ReportTransformer;
import ca.sqlpower.architect.transformation.TransformerFactory;
import ca.sqlpower.architect.transformation.UnknowTemplateTypeException;
import ca.sqlpower.swingui.JDefaultButton;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.BrowserUtil;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportHTMLPanel {
    private static final Logger logger = Logger.getLogger(ExportHTMLPanel.class);
    private static String builtinTransform = "/xsltStylesheets/architect2html.xslt";
    private static BuiltinOptionPanelFactory builtinOptions;
    private JRadioButton builtin;
    private JRadioButton external;
    private JComboBox templateFile;
    private JButton selectTemplate;
    private JButton selectOutput;
    private JButton startButton;
    private JButton closeButton;
    private JTextField outputFile;
    private JLabel statusBar;
    private final ArchitectSwingSession session;
    private JDialog dialog;
    private final JPanel panel;
    private final BuiltinOptionPanel builtinOptionPanel;
    private static final String PREF_KEY_BUILTIN = "htmlgen.builtin";
    private static final String PREF_KEY_LAST_XSLT = "htmlgen.lastxslt";
    private static final String PREF_KEY_XSLT_HISTORY = "htmlgen.xslt.recent";
    private static final String PREF_KEY_OUTPUT = "htmlgen.lastoutput";
    private static final int MAX_HISTORY_ENTRIES = 15;
    private final ActionListener componentStateHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ExportHTMLPanel.this.selectTemplate) {
                ExportHTMLPanel.this.selectTemplate();
            } else if (e.getSource() == ExportHTMLPanel.this.selectOutput) {
                ExportHTMLPanel.this.selectOutput();
            } else if (e.getSource() == ExportHTMLPanel.this.startButton) {
                ExportHTMLPanel.this.transformFile();
            } else if (e.getSource() == ExportHTMLPanel.this.closeButton) {
                ExportHTMLPanel.this.closeDialog();
            } else if (e.getSource() == ExportHTMLPanel.this.templateFile) {
                ExportHTMLPanel.this.updateDropDownToolTip();
            } else if (e.getSource() == ExportHTMLPanel.this.builtin) {
                ExportHTMLPanel.this.templateFile.setEnabled(ExportHTMLPanel.this.external.isSelected());
            } else if (e.getSource() == ExportHTMLPanel.this.external) {
                ExportHTMLPanel.this.templateFile.setEnabled(ExportHTMLPanel.this.external.isSelected());
            }
        }
    };

    public static void setBuiltinTransform(String builtinTransform) {
        ExportHTMLPanel.builtinTransform = builtinTransform;
    }

    public static void setBuiltinOptionPanelFactory(BuiltinOptionPanelFactory builtinOptions) {
        ExportHTMLPanel.builtinOptions = builtinOptions;
    }

    public ExportHTMLPanel(ArchitectSwingSession architect) {
        this.session = architect;
        FormLayout layout = new FormLayout("10dlu, 3dlu, pref:grow, 3dlu, pref");
        DefaultFormBuilder builder = logger.isDebugEnabled() ? new DefaultFormBuilder(layout, (JPanel)new FormDebugPanel()) : new DefaultFormBuilder(layout);
        ButtonGroup group = new ButtonGroup();
        this.builtin = new JRadioButton(Messages.getString("XSLTSelectionPanel.labelBuiltIn"));
        this.external = new JRadioButton(Messages.getString("XSLTSelectionPanel.labelExternal"));
        group.add(this.builtin);
        group.add(this.external);
        builder.append((Component)this.builtin, 5);
        builder.appendRelatedComponentsGapColumn();
        if (builtinOptions != null) {
            this.builtinOptionPanel = builtinOptions.createPanel(this.session);
            builder.append("");
            builder.append((Component)this.builtinOptionPanel, 4);
        } else {
            this.builtinOptionPanel = null;
        }
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.external, 5);
        this.templateFile = new JComboBox();
        this.templateFile.setRenderer(new ComboTooltipRenderer());
        this.templateFile.setEditable(true);
        builder.append("");
        builder.append((Component)this.templateFile);
        this.selectTemplate = new JButton("...");
        builder.append((Component)this.selectTemplate);
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)new JLabel(Messages.getString("XSLTSelectionPanel.labelOutput")), 5);
        builder.nextLine();
        this.outputFile = new JTextField(30);
        builder.append("", (Component)this.outputFile);
        this.selectOutput = new JButton("...");
        builder.append((Component)this.selectOutput);
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.nextLine();
        this.statusBar = new JLabel(" ");
        builder.append((Component)this.statusBar, 5);
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        this.selectTemplate.addActionListener(this.componentStateHandler);
        this.selectOutput.addActionListener(this.componentStateHandler);
        this.builtin.addActionListener(this.componentStateHandler);
        this.external.addActionListener(this.componentStateHandler);
        this.builtin.setSelected(true);
        this.startButton = new JDefaultButton(Messages.getString("XSLTSelectionPanel.startOption"));
        this.startButton.addActionListener(this.componentStateHandler);
        this.closeButton = new JButton(Messages.getString("XSLTSelectionPanel.closeOption"));
        this.closeButton.addActionListener(this.componentStateHandler);
        builder.nextLine();
        JPanel bp = ButtonBarFactory.buildRightAlignedBar((JButton)this.startButton, (JButton)this.closeButton);
        builder.append((Component)bp, 5);
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
        this.restoreSettings();
    }

    public void showDialog() {
        if (this.dialog == null) {
            ArchitectFrame frame = this.session.getArchitectFrame();
            this.dialog = new JDialog((Frame)frame, Messages.getString("XSLTSelectionPanel.dialogTitle"));
            this.dialog.setDefaultCloseOperation(2);
            SPSUtils.makeJDialogCancellable((Window)this.dialog, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportHTMLPanel.this.closeDialog();
                }
            });
            this.dialog.setContentPane(this.panel);
            this.dialog.getRootPane().setDefaultButton(this.startButton);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(frame);
        }
        this.dialog.setVisible(true);
    }

    public File getTemplateFile() {
        if (this.builtin.isSelected()) {
            return null;
        }
        Object o = this.templateFile.getSelectedItem();
        if (o instanceof File) {
            return (File)o;
        }
        if (o instanceof String) {
            return new File((String)o);
        }
        return null;
    }

    public String getOutputFilename() {
        return this.outputFile.getText();
    }

    public File getOutputFile() {
        return new File(this.outputFile.getText());
    }

    private void updateDropDownToolTip() {
        File f = this.getTemplateFile();
        if (f != null) {
            this.templateFile.setToolTipText(ExportHTMLPanel.getFullName(f));
        }
    }

    private void setTemplateFile(File template) {
        ComboBoxFile cf = new ComboBoxFile(template);
        this.external.setSelected(true);
        this.templateFile.setEnabled(true);
        this.templateFile.addItem(cf);
        this.templateFile.setSelectedItem(cf);
        this.templateFile.setToolTipText(ExportHTMLPanel.getFullName(template));
    }

    private void syncDropDown() {
        File current = this.getTemplateFile();
        if (current == null) {
            return;
        }
        boolean found = false;
        int numEntries = this.templateFile.getItemCount();
        for (int index = 0; index < numEntries; ++index) {
            if (!this.templateFile.getItemAt(index).equals(current)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.templateFile.addItem(new ComboBoxFile(current));
        }
    }

    private void saveSettings() {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.putBoolean(PREF_KEY_BUILTIN, this.builtin.isSelected());
        prefs.put(PREF_KEY_OUTPUT, this.outputFile.getText());
        this.syncDropDown();
        File f = this.getTemplateFile();
        if (f != null) {
            prefs.put(PREF_KEY_LAST_XSLT, ExportHTMLPanel.getFullName(f));
        } else {
            prefs.remove(PREF_KEY_LAST_XSLT);
        }
        int numEntries = this.templateFile.getItemCount() > 15 ? 15 : this.templateFile.getItemCount();
        for (int i = 0; i < numEntries; ++i) {
            Object o = this.templateFile.getItemAt(i);
            String key = "htmlgen.xslt.recent." + i;
            if (o instanceof File) {
                prefs.put(key, ExportHTMLPanel.getFullName((File)o));
                continue;
            }
            if (o instanceof String) {
                prefs.put(key, (String)o);
                continue;
            }
            prefs.remove(key);
        }
    }

    private void restoreSettings() {
        String fname;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        final boolean useBuiltin = prefs.getBoolean(PREF_KEY_BUILTIN, true);
        this.builtin.setSelected(useBuiltin);
        this.external.setSelected(!useBuiltin);
        this.templateFile.setEnabled(!useBuiltin);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (useBuiltin) {
                    ExportHTMLPanel.this.builtin.requestFocusInWindow();
                } else {
                    ExportHTMLPanel.this.external.requestFocusInWindow();
                }
            }
        });
        for (int i = 0; i < 15 && (fname = prefs.get("htmlgen.xslt.recent." + i, null)) != null; ++i) {
            ComboBoxFile f = new ComboBoxFile(fname);
            this.templateFile.addItem(f);
        }
        String file = prefs.get(PREF_KEY_LAST_XSLT, null);
        if (file != null) {
            ComboBoxFile f = new ComboBoxFile(file);
            this.templateFile.setSelectedItem(f);
        }
        this.outputFile.setText(prefs.get(PREF_KEY_OUTPUT, ""));
    }

    public static String getFullName(File fo) {
        if (fo == null) {
            return null;
        }
        try {
            return fo.getCanonicalPath();
        }
        catch (IOException io) {
            return fo.getAbsolutePath();
        }
    }

    private void selectTemplate() {
        JFileChooser chooser = new JFileChooser(this.session.getProjectLoader().getFile());
        File tmpl = this.getTemplateFile();
        boolean xslt = true;
        String fname = "";
        if (tmpl != null) {
            fname = tmpl.getAbsolutePath().toLowerCase();
            xslt = fname.endsWith("xslt") || fname.endsWith("xsl");
        }
        chooser.addChoosableFileFilter(SPSUtils.XSLT_FILE_FILTER);
        chooser.addChoosableFileFilter(SPSUtils.VELOCITY_FILE_FILTER);
        if (xslt) {
            chooser.setFileFilter(SPSUtils.XSLT_FILE_FILTER);
        } else if (fname.endsWith("vm")) {
            chooser.setFileFilter(SPSUtils.VELOCITY_FILE_FILTER);
        } else {
            FileFilter[] filters = chooser.getChoosableFileFilters();
            chooser.setFileFilter(filters[0]);
        }
        chooser.setDialogTitle(Messages.getString("XSLTSelectionPanel.selectXsltTitle"));
        int response = chooser.showOpenDialog(this.dialog);
        if (response != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        this.dialog.requestFocus();
        this.setTemplateFile(file);
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.saveSettings();
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void selectOutput() {
        JFileChooser chooser = new JFileChooser(this.session.getProjectLoader().getFile());
        chooser.addChoosableFileFilter(SPSUtils.HTML_FILE_FILTER);
        chooser.setDialogTitle(Messages.getString("XSLTSelectionPanel.saveAsTitle"));
        int response = chooser.showSaveDialog(this.session.getArchitectFrame());
        if (response != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (chooser.getFileFilter() == SPSUtils.HTML_FILE_FILTER && !file.getPath().endsWith(".html")) {
            file = new File(file.getPath() + ".html");
        }
        try {
            this.outputFile.setText(file.getCanonicalPath());
        }
        catch (IOException io) {
            this.outputFile.setText(file.getAbsolutePath());
        }
        this.dialog.requestFocus();
    }

    protected void transformFile() {
        int response;
        File file = new File(this.outputFile.getText());
        if (file.exists() && (response = JOptionPane.showConfirmDialog(this.session.getArchitectFrame(), Messages.getString("XSLTSelectionPanel.fileAlreadyExists", file.getPath()), Messages.getString("XSLTSelectionPanel.fileAlreadyExistsDialogTitle"), 0)) == 1) {
            return;
        }
        this.setStatusBarText(Messages.getString("XSLTSelectionPanel.msgGenerating"));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ExportHTMLPanel.this._transformFile();
            }
        });
        t.setName("HTML Generation Thread");
        t.setDaemon(true);
        t.start();
    }

    protected void _transformFile() {
        ReportTransformer transformer;
        File file = new File(this.getOutputFilename());
        try {
            transformer = TransformerFactory.getTransformer(this.getTemplateFile());
        }
        catch (UnknowTemplateTypeException e) {
            SPSUtils.showExceptionDialogNoReport((Component)this.panel, (String)"Error", (Throwable)e);
            this.setStatusBarText("");
            return;
        }
        if (this.builtinOptionPanel != null) {
            this.builtinOptionPanel.applyChanges(transformer, this.getOutputFile(), this.session);
        }
        try {
            File xslt = this.getTemplateFile();
            if (xslt == null) {
                transformer.transform(builtinTransform, this.getOutputFile(), this.session);
            } else {
                transformer.transform(xslt, this.getOutputFile(), this.session);
            }
            String fname = this.getOutputFilename().toLowerCase();
            if (fname.endsWith("html") || fname.endsWith("htm")) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExportHTMLPanel.this.statusBar.setText(Messages.getString("XSLTSelectionPanel.msgStartingBrowser"));
                    }
                });
                BrowserUtil.launch((String)file.toURI().toString());
            }
        }
        catch (Exception e1) {
            SPSUtils.showExceptionDialogNoReport((Component)this.session.getArchitectFrame(), (String)"Transformation error", (Throwable)e1);
        }
        this.setStatusBarText("");
    }

    protected void setStatusBarText(final String text) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportHTMLPanel.this.statusBar.setText(text);
            }
        });
    }

    public static interface BuiltinOptionPanelFactory {
        public BuiltinOptionPanel createPanel(ArchitectSession var1);
    }

    public static abstract class BuiltinOptionPanel
    extends JPanel {
        public abstract void applyChanges(ReportTransformer var1, File var2, ArchitectSession var3);
    }

    private static class ComboTooltipRenderer
    extends DefaultListCellRenderer {
        private ComboTooltipRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent comp = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof File) {
                comp.setToolTipText(ExportHTMLPanel.getFullName((File)value));
            } else {
                comp.setToolTipText(null);
            }
            return comp;
        }
    }

    private static class ComboBoxFile
    extends File {
        public ComboBoxFile(File f) {
            super(f.getAbsolutePath());
        }

        public ComboBoxFile(String pathname) {
            super(pathname);
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

