/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class MtxProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("#MTX,").number("(d+),").number("(dddd)(dd)(dd),").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+),").number("(d+.?d*),").groupBegin().number("d+").or().text("X").groupEnd().text(",").expression("(?:[01]|X),").expression("([01]+),").expression("([01]+),").number("(d+),").number("(d+)").any().compile();

    public MtxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("#ACK", remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, (String)msg)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setValid(true);
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.set("odometer", parser.nextDouble(0.0) * 1000.0);
        position.set("input", parser.next());
        position.set("output", parser.next());
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        return position;
    }
}

