/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * round(dvec4(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf, -0.2857142857142858lf)) => dvec4(-2.0lf, -1.0lf, -1.0lf, -0.0lf)
 * round(dvec4(0.2857142857142856lf, 0.8571428571428568lf, 1.4285714285714284lf, 2.0lf)) => dvec4(0.0lf, 1.0lf, 1.0lf, 2.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(round(dvec4(-2.0lf, -1.4285714285714286lf, -0.8571428571428572lf, -0.2857142857142858lf)), dvec4(-2.0lf, -1.0lf, -1.0lf, -0.0lf)) <= 2.4494897427831785e-05lf ? 1 : -1] array0;
  double[distance(round(dvec4(0.2857142857142856lf, 0.8571428571428568lf, 1.4285714285714284lf, 2.0lf)), dvec4(0.0lf, 1.0lf, 1.0lf, 2.0lf)) <= 2.4494897427831785e-05lf ? 1 : -1] array1;
  gl_Position = vec4(array0.length() + array1.length());
}
