/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.http.auth.internal;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationProvider;
import org.openhab.core.auth.ManagedUser;
import org.openhab.core.auth.PendingToken;
import org.openhab.core.auth.User;
import org.openhab.core.auth.UserRegistry;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.io.http.auth.internal.AbstractAuthPageServlet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={Servlet.class})
@HttpWhiteboardServletName(value="/auth")
@HttpWhiteboardServletPattern(value={"/auth/*"})
public class AuthorizePageServlet
extends AbstractAuthPageServlet {
    public static final String SERVLET_PATH = "/auth";
    private static final long serialVersionUID = 5340598701104679843L;
    private final Logger logger = LoggerFactory.getLogger(AuthorizePageServlet.class);

    @Activate
    public AuthorizePageServlet(BundleContext bundleContext, @Reference UserRegistry userRegistry, @Reference AuthenticationProvider authProvider, @Reference LocaleProvider localeProvider) {
        super(bundleContext, userRegistry, authProvider, localeProvider);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map params = req.getParameterMap();
        try {
            String clientId;
            String scope = params.containsKey("scope") ? ((String[])params.get("scope"))[0] : "";
            String string = clientId = params.containsKey("client_id") ? ((String[])params.get("client_id"))[0] : "";
            if (scope.contains("<") || clientId.contains("<")) {
                throw new IllegalArgumentException("invalid_request");
            }
            String message = this.isSignupMode() ? this.getLocalizedMessage("auth.createaccount.prompt") : String.format(this.getLocalizedMessage("auth.login.prompt"), scope, clientId);
            resp.setContentType("text/html;charset=UTF-8");
            resp.getWriter().append(this.getPageBody(params, message, false));
            resp.getWriter().close();
        }
        catch (Exception e) {
            resp.setContentType("text/plain;charset=UTF-8");
            resp.getWriter().append(e.getMessage());
            resp.getWriter().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map params = req.getParameterMap();
        try {
            User user;
            if (!params.containsKey("username")) {
                throw new AuthenticationException("no username");
            }
            if (!params.containsKey("password")) {
                throw new AuthenticationException("no password");
            }
            if (!params.containsKey("csrf_token") || !this.csrfTokens.containsKey(((String[])params.get("csrf_token"))[0])) {
                throw new AuthenticationException("CSRF check failed");
            }
            if (!params.containsKey("redirect_uri")) {
                throw new IllegalArgumentException("invalid_request");
            }
            if (!params.containsKey("response_type")) {
                throw new IllegalArgumentException("unsupported_response_type");
            }
            if (!params.containsKey("client_id")) {
                throw new IllegalArgumentException("unauthorized_client");
            }
            if (!params.containsKey("scope")) {
                throw new IllegalArgumentException("invalid_scope");
            }
            this.removeCsrfToken(((String[])params.get("csrf_token"))[0]);
            String baseRedirectUri = ((String[])params.get("redirect_uri"))[0];
            String responseType = ((String[])params.get("response_type"))[0];
            String clientId = ((String[])params.get("client_id"))[0];
            String scope = ((String[])params.get("scope"))[0];
            if (!"code".equals(responseType)) {
                throw new AuthenticationException("unsupported_response_type");
            }
            if (!clientId.equals(baseRedirectUri)) {
                throw new IllegalArgumentException("unauthorized_client");
            }
            String username = ((String[])params.get("username"))[0];
            String password = ((String[])params.get("password"))[0];
            if (this.isSignupMode()) {
                if (!params.containsKey("password_repeat") || !password.equals(((String[])params.get("password_repeat"))[0])) {
                    resp.setContentType("text/html;charset=UTF-8");
                    resp.getWriter().append(this.getPageBody(params, this.getLocalizedMessage("auth.password.confirm.fail"), false));
                    resp.getWriter().close();
                    return;
                }
                user = this.userRegistry.register(username, password, Set.of("administrator"));
                this.logger.info("First user account created: {}", (Object)username);
            } else {
                user = this.login(username, password);
            }
            String authorizationCode = UUID.randomUUID().toString().replace("-", "");
            User user2 = user;
            if (user2 instanceof ManagedUser) {
                void managedUser;
                ManagedUser managedUser2 = (ManagedUser)user2;
                ManagedUser cfr_ignored_0 = (ManagedUser)user2;
                String codeChallenge = params.containsKey("code_challenge") ? ((String[])params.get("code_challenge"))[0] : null;
                String codeChallengeMethod = params.containsKey("code_challenge_method") ? ((String[])params.get("code_challenge_method"))[0] : null;
                PendingToken pendingToken = new PendingToken(authorizationCode, clientId, baseRedirectUri, scope, codeChallenge, codeChallengeMethod);
                managedUser.setPendingToken(pendingToken);
                this.userRegistry.update((Identifiable)managedUser);
            }
            String state = params.containsKey("state") ? ((String[])params.get("state"))[0] : null;
            resp.addHeader("Location", this.getRedirectUri(baseRedirectUri, authorizationCode, null, state));
            resp.setStatus(302);
        }
        catch (AuthenticationException e) {
            this.processFailedLogin(resp, req.getRemoteAddr(), params, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            String state;
            String baseRedirectUri = params.containsKey("redirect_uri") ? ((String[])params.get("redirect_uri"))[0] : null;
            String string = state = params.containsKey("state") ? ((String[])params.get("state"))[0] : null;
            if (baseRedirectUri != null) {
                resp.addHeader("Location", this.getRedirectUri(baseRedirectUri, null, e.getMessage(), state));
                resp.setStatus(302);
            }
            resp.setContentType("text/plain;charset=UTF-8");
            resp.getWriter().append(e.getMessage());
            resp.getWriter().close();
        }
    }

    @Override
    protected String getPageBody(Map<String, String[]> params, String message, boolean hideForm) {
        String responseBody = this.getPageTemplate().replace("{form_fields}", this.getFormFields(params));
        String repeatPasswordFieldType = this.isSignupMode() ? "password" : "hidden";
        String buttonLabel = this.getLocalizedMessage(this.isSignupMode() ? "auth.button.createaccount" : "auth.button.signin");
        responseBody = responseBody.replace("{message}", message);
        responseBody = responseBody.replace("{formAction}", SERVLET_PATH);
        responseBody = responseBody.replace("{formClass}", "show");
        responseBody = responseBody.replace("{repeatPasswordFieldType}", repeatPasswordFieldType);
        responseBody = responseBody.replace("{newPasswordFieldType}", "hidden");
        responseBody = responseBody.replace("{tokenNameFieldType}", "hidden");
        responseBody = responseBody.replace("{tokenScopeFieldType}", "hidden");
        responseBody = responseBody.replace("{buttonLabel}", buttonLabel);
        responseBody = responseBody.replace("{resultClass}", "");
        return responseBody;
    }

    @Override
    protected String getFormFields(Map<String, String[]> params) {
        Object hiddenFormFields = "";
        if (!params.containsKey("redirect_uri")) {
            throw new IllegalArgumentException("invalid_request");
        }
        if (!params.containsKey("response_type")) {
            throw new IllegalArgumentException("unsupported_response_type");
        }
        if (!params.containsKey("client_id")) {
            throw new IllegalArgumentException("unauthorized_client");
        }
        if (!params.containsKey("scope")) {
            throw new IllegalArgumentException("invalid_scope");
        }
        String csrfToken = this.addCsrfToken();
        String redirectUri = params.get("redirect_uri")[0];
        String responseType = params.get("response_type")[0];
        String clientId = params.get("client_id")[0];
        String scope = params.get("scope")[0];
        String state = params.containsKey("state") ? params.get("state")[0] : null;
        String codeChallenge = params.containsKey("code_challenge") ? params.get("code_challenge")[0] : null;
        String codeChallengeMethod = params.containsKey("code_challenge_method") ? params.get("code_challenge_method")[0] : null;
        hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"csrf_token\" value=\"" + csrfToken + "\">";
        hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"redirect_uri\" value=\"" + redirectUri + "\">";
        hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"response_type\" value=\"" + responseType + "\">";
        hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"client_id\" value=\"" + clientId + "\">";
        hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"scope\" value=\"" + scope + "\">";
        if (state != null) {
            hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"state\" value=\"" + state + "\">";
        }
        if (codeChallenge != null && codeChallengeMethod != null) {
            hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"code_challenge\" value=\"" + codeChallenge + "\">";
            hiddenFormFields = (String)hiddenFormFields + "<input type=\"hidden\" name=\"code_challenge_method\" value=\"" + codeChallengeMethod + "\">";
        }
        return hiddenFormFields;
    }

    private String getRedirectUri(String baseRedirectUri, @Nullable String authorizationCode, @Nullable String error, @Nullable String state) {
        Object redirectUri = baseRedirectUri;
        if (authorizationCode != null) {
            redirectUri = (String)redirectUri + "?code=" + authorizationCode;
        } else if (error != null) {
            redirectUri = (String)redirectUri + "?error=" + error;
        }
        if (state != null) {
            redirectUri = (String)redirectUri + "&state=" + state;
        }
        return redirectUri;
    }

    private boolean isSignupMode() {
        return this.userRegistry.getAll().isEmpty();
    }
}

