/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CurrentOfResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private boolean next;
    private RowLocation rowLocation;
    private CursorResultSet cursor;
    private CursorResultSet target;
    private ExecRow sparseRow;
    private final String cursorName;

    CurrentOfResultSet(String cursorName, Activation activation, int resultSetNumber) {
        super(activation, resultSetNumber, 0.0, 0.0);
        SanityManager.ASSERT((cursorName != null ? 1 : 0) != 0, (String)"current of scan must get cursor name");
        this.cursorName = cursorName;
    }

    @Override
    public void openCore() throws StandardException {
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"CurrentOfResultSet already open");
        this.getCursor();
        this.next = false;
        this.isOpen = true;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                SanityManager.ASSERT((!this.cursor.isClosed() ? 1 : 0) != 0, (String)"cursor closed");
                ExecRow cursorRow = this.cursor.getCurrentRow();
                if (cursorRow == null) {
                    throw StandardException.newException((String)"24000", (Object[])new Object[0]);
                }
                this.rowLocation = this.cursor.getRowLocation();
                this.currentRow = this.target.getCurrentRow();
                if (this.rowLocation == null || cursorRow != null && this.currentRow == null) {
                    this.activation.addWarning(StandardException.newWarning((String)"01001", (Object[])new Object[0]));
                    return null;
                }
                if (this.target instanceof TableScanResultSet) {
                    TableScanResultSet scan = (TableScanResultSet)this.target;
                    if (scan.indexCols != null && this.currentRow != null) {
                        this.currentRow = this.getSparseRow(this.currentRow, scan.indexCols);
                    }
                }
            } else {
                this.currentRow = null;
                this.rowLocation = null;
            }
        } else {
            this.currentRow = null;
            this.rowLocation = null;
        }
        this.setCurrentRow(this.currentRow);
        return this.currentRow;
    }

    private ExecRow getSparseRow(ExecRow row, int[] indexCols) throws StandardException {
        int colPos;
        if (this.sparseRow == null) {
            int numCols = 1;
            for (int i = 0; i < indexCols.length; ++i) {
                int n = colPos = indexCols[i] > 0 ? indexCols[i] : -indexCols[i];
                if (colPos <= numCols) continue;
                numCols = colPos;
            }
            this.sparseRow = new ValueRow(numCols);
        }
        for (int i = 1; i <= indexCols.length; ++i) {
            colPos = indexCols[i - 1] > 0 ? indexCols[i - 1] : -indexCols[i - 1];
            this.sparseRow.setColumn(colPos, row.getColumn(i));
        }
        return this.sparseRow;
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of CurrentOfResultSet repeated");
        }
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int type) {
        return 0L;
    }

    @Override
    public RowLocation getRowLocation() {
        return this.rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private void getCursor() throws StandardException {
        LanguageConnectionContext lcc;
        CursorActivation cursorActivation;
        if (this.cursor != null && this.cursor.isClosed()) {
            this.cursor = null;
            this.target = null;
        }
        if (this.cursor == null && (cursorActivation = (lcc = this.getLanguageConnectionContext()).lookupCursorActivation(this.cursorName)) != null) {
            this.cursor = cursorActivation.getCursorResultSet();
            this.target = cursorActivation.getTargetResultSet();
            this.activation.setForUpdateIndexScan(cursorActivation.getForUpdateIndexScan());
            if (cursorActivation.getHeapConglomerateController() != null) {
                cursorActivation.getHeapConglomerateController().close();
            }
            cursorActivation.setHeapConglomerateController(this.activation.getHeapConglomerateController());
        }
        if (this.cursor == null || this.cursor.isClosed()) {
            throw StandardException.newException((String)"42X30", (Object[])new Object[]{this.cursorName});
        }
    }

    @Override
    public void updateRow(ExecRow row, RowChanger rowChanger) throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).updateRow(row, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).markRowAsDeleted();
    }
}

