/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.logstash.ConvertedList;
import org.logstash.ConvertedMap;
import org.logstash.MissingConverterException;
import org.logstash.Timestamp;
import org.logstash.Valuefier;
import org.logstash.ext.JrubyTimestampExtLibrary;

public final class Javafier {
    private static final Map<Class<?>, Valuefier.Converter> CONVERTER_MAP = Javafier.initConverters();

    private Javafier() {
    }

    public static Object deep(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        Valuefier.Converter converter = CONVERTER_MAP.get(cls);
        if (converter != null) {
            return converter.convert(o);
        }
        return Javafier.fallbackConvert(o, cls);
    }

    private static Object fallbackConvert(Object o, Class<?> cls) {
        for (Map.Entry<Class<?>, Valuefier.Converter> entry : CONVERTER_MAP.entrySet()) {
            if (!entry.getKey().isAssignableFrom(cls)) continue;
            Valuefier.Converter found = entry.getValue();
            CONVERTER_MAP.put(cls, found);
            return found.convert(o);
        }
        throw new MissingConverterException(cls);
    }

    private static Map<Class<?>, Valuefier.Converter> initConverters() {
        ConcurrentHashMap converters = new ConcurrentHashMap(50, 0.2f, 1);
        converters.put(String.class, Valuefier.IDENTITY);
        converters.put(Float.class, Valuefier.IDENTITY);
        converters.put(RubyNil.class, value -> null);
        converters.put(Double.class, Valuefier.IDENTITY);
        converters.put(Long.class, Valuefier.IDENTITY);
        converters.put(Integer.class, Valuefier.IDENTITY);
        converters.put(Boolean.class, Valuefier.IDENTITY);
        converters.put(BigInteger.class, Valuefier.IDENTITY);
        converters.put(BigDecimal.class, Valuefier.IDENTITY);
        converters.put(Timestamp.class, Valuefier.IDENTITY);
        converters.put(RubyString.class, value -> ((RubyString)value).toString());
        converters.put(RubySymbol.class, value -> ((RubySymbol)value).toString());
        converters.put(RubyBignum.class, value -> ((RubyBignum)value).getBigIntegerValue());
        converters.put(RubyBigDecimal.class, value -> ((RubyBigDecimal)value).getBigDecimalValue());
        converters.put(RubyBoolean.class, value -> ((RubyBoolean)value).isTrue());
        converters.put(RubyFixnum.class, value -> ((RubyFixnum)value).getLongValue());
        converters.put(RubyFloat.class, value -> ((RubyFloat)value).getDoubleValue());
        converters.put(ConvertedMap.class, value -> ((ConvertedMap)value).unconvert());
        converters.put(ConvertedList.class, value -> ((ConvertedList)value).unconvert());
        converters.put(JrubyTimestampExtLibrary.RubyTimestamp.class, value -> ((JrubyTimestampExtLibrary.RubyTimestamp)((Object)((Object)value))).getTimestamp());
        return converters;
    }
}

