/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.enterprise.client.Grant;
import ca.sqlpower.enterprise.client.Group;
import ca.sqlpower.enterprise.client.GroupMember;
import ca.sqlpower.enterprise.client.User;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class PrivilegesEditorPanel
implements DataEntryPanel {
    private Grant grant;
    private final SPObject groupOrUser;
    private final JPanel panel;
    private final Action checkAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PrivilegesEditorPanel.this.hasUnsavedChanges = true;
        }
    };
    private final JCheckBox viewPrivilege = new JCheckBox(this.checkAction);
    private final JCheckBox createPrivilege = new JCheckBox(this.checkAction);
    private final JCheckBox modifyPrivilege = new JCheckBox(this.checkAction);
    private final JCheckBox deletePrivilege = new JCheckBox(this.checkAction);
    private final JCheckBox grantPrivilege = new JCheckBox(this.checkAction);
    private final String subject;
    private final String type;
    private final String username;
    private final ArchitectSwingProject securityWorkspace;
    private boolean hasUnsavedChanges = false;

    public PrivilegesEditorPanel(Grant baseGrant, SPObject baseGroupOrUser, String subject, String type, String username, ArchitectSwingProject securityWorkspace) {
        this.securityWorkspace = securityWorkspace;
        this.grant = baseGrant;
        this.groupOrUser = baseGroupOrUser;
        this.subject = subject;
        this.type = type;
        this.username = username;
        this.createPrivilege.setText("Create");
        this.modifyPrivilege.setText("Modify");
        this.deletePrivilege.setText("Delete");
        this.viewPrivilege.setText("View");
        this.grantPrivilege.setText("Grant");
        if (this.grant != null) {
            if (this.grant.isCreatePrivilege()) {
                this.createPrivilege.setSelected(true);
            }
            if (this.grant.isModifyPrivilege()) {
                this.modifyPrivilege.setSelected(true);
            }
            if (this.grant.isExecutePrivilege()) {
                this.viewPrivilege.setSelected(true);
            }
            if (this.grant.isDeletePrivilege()) {
                this.deletePrivilege.setSelected(true);
            }
            if (this.grant.isGrantPrivilege()) {
                this.grantPrivilege.setSelected(true);
            }
        }
        CellConstraints cc = new CellConstraints();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref, 5dlu, pref, 5dlu, pref,", "pref:grow, 3dlu, pref:grow"));
        builder.add((Component)this.viewPrivilege, cc.xy(1, 1));
        builder.add((Component)this.createPrivilege, cc.xy(3, 1));
        builder.add((Component)this.modifyPrivilege, cc.xy(5, 1));
        builder.add((Component)this.deletePrivilege, cc.xy(1, 3));
        builder.add((Component)this.grantPrivilege, cc.xy(3, 3));
        this.panel = builder.getPanel();
        this.disableIfNecessary();
    }

    public JCheckBox getCreatePrivilege() {
        return this.createPrivilege;
    }

    public JCheckBox getModifyPrivilege() {
        return this.modifyPrivilege;
    }

    public JCheckBox getDeletePrivilege() {
        return this.deletePrivilege;
    }

    public JCheckBox getViewPrivilege() {
        return this.viewPrivilege;
    }

    public JCheckBox getGrantPrivilege() {
        return this.grantPrivilege;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean applyChanges() {
        try {
            if (this.hasUnsavedChanges()) {
                boolean doesNotRequireSave = false;
                if (this.grant != null) {
                    if (this.getCreatePrivilege().isSelected() == this.grant.isCreatePrivilege() && this.getModifyPrivilege().isSelected() == this.grant.isModifyPrivilege() && this.getViewPrivilege().isSelected() == this.grant.isExecutePrivilege() && this.getDeletePrivilege().isSelected() == this.grant.isDeletePrivilege() && this.getGrantPrivilege().isSelected() == this.grant.isGrantPrivilege()) {
                        doesNotRequireSave = true;
                    }
                } else if (!(this.getCreatePrivilege().isSelected() || this.getModifyPrivilege().isSelected() || this.getViewPrivilege().isSelected() || this.getDeletePrivilege().isSelected() || this.getGrantPrivilege().isSelected())) {
                    ((User)this.groupOrUser).removeGrant(this.grant);
                    doesNotRequireSave = true;
                }
                if (!doesNotRequireSave) {
                    Grant newGrant = new Grant(this.subject, this.type, this.createPrivilege.isSelected(), this.modifyPrivilege.isSelected(), this.deletePrivilege.isSelected(), this.viewPrivilege.isSelected(), this.grantPrivilege.isSelected());
                    this.securityWorkspace.begin("");
                    if (this.groupOrUser instanceof User) {
                        if (this.grant != null) {
                            ((User)this.groupOrUser).removeGrant(this.grant);
                        }
                        ((User)this.groupOrUser).addGrant(newGrant);
                    }
                    if (this.groupOrUser instanceof Group) {
                        if (this.grant != null) {
                            ((Group)this.groupOrUser).removeGrant(this.grant);
                        }
                        ((Group)this.groupOrUser).addGrant(newGrant);
                    }
                    this.securityWorkspace.commit();
                    this.grant = newGrant;
                }
            }
            this.hasUnsavedChanges = false;
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to apply changes.", e);
        }
    }

    public void disableIfNecessary() {
        User user = null;
        ArrayList<Grant> grantsForUser = new ArrayList<Grant>();
        for (User aUser : this.securityWorkspace.getChildren(User.class)) {
            if (!aUser.getUsername().equals(this.username)) continue;
            user = aUser;
            break;
        }
        if (user == null) {
            throw new IllegalStateException("User cannot possibly be null");
        }
        for (Grant g : user.getChildren(Grant.class)) {
            grantsForUser.add(g);
        }
        for (Grant g : this.securityWorkspace.getChildren(Group.class)) {
            for (GroupMember gm : g.getChildren(GroupMember.class)) {
                if (!gm.getUser().getUUID().equals(user.getUUID())) continue;
                for (Grant gr : g.getChildren(Grant.class)) {
                    grantsForUser.add(gr);
                }
            }
        }
        boolean disable = true;
        for (Grant g : grantsForUser) {
            if ((g.isSystemLevel() || !g.getSubject().equals(this.subject)) && (!g.isSystemLevel() || !g.getType().equals(this.type)) || !g.isGrantPrivilege()) continue;
            disable = false;
        }
        if (disable) {
            this.getCreatePrivilege().setEnabled(false);
            this.getModifyPrivilege().setEnabled(false);
            this.getDeletePrivilege().setEnabled(false);
            this.getViewPrivilege().setEnabled(false);
            this.getGrantPrivilege().setEnabled(false);
        }
    }

    public Grant getGrant() {
        return this.grant;
    }

    public void discardChanges() {
        this.hasUnsavedChanges = false;
    }

    public boolean hasUnsavedChanges() {
        return this.hasUnsavedChanges;
    }
}

