/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Dimension;

public class IntersectionMatrix
implements Cloneable {
    private int[][] matrix = new int[3][3];

    public IntersectionMatrix() {
        this.setAll(-1);
    }

    public IntersectionMatrix(String elements) {
        this();
        this.set(elements);
    }

    public IntersectionMatrix(IntersectionMatrix other) {
        this();
        this.matrix[0][0] = other.matrix[0][0];
        this.matrix[0][1] = other.matrix[0][1];
        this.matrix[0][2] = other.matrix[0][2];
        this.matrix[1][0] = other.matrix[1][0];
        this.matrix[1][1] = other.matrix[1][1];
        this.matrix[1][2] = other.matrix[1][2];
        this.matrix[2][0] = other.matrix[2][0];
        this.matrix[2][1] = other.matrix[2][1];
        this.matrix[2][2] = other.matrix[2][2];
    }

    public void add(IntersectionMatrix im) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.setAtLeast(i, j, im.get(i, j));
            }
        }
    }

    public static boolean isTrue(int actualDimensionValue) {
        return actualDimensionValue >= 0 || actualDimensionValue == -2;
    }

    public static boolean matches(int actualDimensionValue, char requiredDimensionSymbol) {
        if (requiredDimensionSymbol == '*') {
            return true;
        }
        if (requiredDimensionSymbol == 'T' && (actualDimensionValue >= 0 || actualDimensionValue == -2)) {
            return true;
        }
        if (requiredDimensionSymbol == 'F' && actualDimensionValue == -1) {
            return true;
        }
        if (requiredDimensionSymbol == '0' && actualDimensionValue == 0) {
            return true;
        }
        if (requiredDimensionSymbol == '1' && actualDimensionValue == 1) {
            return true;
        }
        return requiredDimensionSymbol == '2' && actualDimensionValue == 2;
    }

    public static boolean matches(String actualDimensionSymbols, String requiredDimensionSymbols) {
        IntersectionMatrix m = new IntersectionMatrix(actualDimensionSymbols);
        return m.matches(requiredDimensionSymbols);
    }

    public void set(int row, int column, int dimensionValue) {
        this.matrix[row][column] = dimensionValue;
    }

    public void set(String dimensionSymbols) {
        for (int i = 0; i < dimensionSymbols.length(); ++i) {
            int row = i / 3;
            int col = i % 3;
            this.matrix[row][col] = Dimension.toDimensionValue(dimensionSymbols.charAt(i));
        }
    }

    public void setAtLeast(int row, int column, int minimumDimensionValue) {
        if (this.matrix[row][column] < minimumDimensionValue) {
            this.matrix[row][column] = minimumDimensionValue;
        }
    }

    public void setAtLeastIfValid(int row, int column, int minimumDimensionValue) {
        if (row >= 0 && column >= 0) {
            this.setAtLeast(row, column, minimumDimensionValue);
        }
    }

    public void setAtLeast(String minimumDimensionSymbols) {
        for (int i = 0; i < minimumDimensionSymbols.length(); ++i) {
            int row = i / 3;
            int col = i % 3;
            this.setAtLeast(row, col, Dimension.toDimensionValue(minimumDimensionSymbols.charAt(i)));
        }
    }

    public void setAll(int dimensionValue) {
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                this.matrix[ai][bi] = dimensionValue;
            }
        }
    }

    public int get(int row, int column) {
        return this.matrix[row][column];
    }

    public boolean isDisjoint() {
        return this.matrix[0][0] == -1 && this.matrix[0][1] == -1 && this.matrix[1][0] == -1 && this.matrix[1][1] == -1;
    }

    public boolean isIntersects() {
        return !this.isDisjoint();
    }

    public boolean isTouches(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA > dimensionOfGeometryB) {
            return this.isTouches(dimensionOfGeometryB, dimensionOfGeometryA);
        }
        if (dimensionOfGeometryA == 2 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 1) {
            return this.matrix[0][0] == -1 && (IntersectionMatrix.isTrue(this.matrix[0][1]) || IntersectionMatrix.isTrue(this.matrix[1][0]) || IntersectionMatrix.isTrue(this.matrix[1][1]));
        }
        return false;
    }

    public boolean isCrosses(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA == 0 && dimensionOfGeometryB == 1 || dimensionOfGeometryA == 0 && dimensionOfGeometryB == 2 || dimensionOfGeometryA == 1 && dimensionOfGeometryB == 2) {
            return IntersectionMatrix.isTrue(this.matrix[0][0]) && IntersectionMatrix.isTrue(this.matrix[0][2]);
        }
        if (dimensionOfGeometryA == 1 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 1) {
            return IntersectionMatrix.isTrue(this.matrix[0][0]) && IntersectionMatrix.isTrue(this.matrix[2][0]);
        }
        if (dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1) {
            return this.matrix[0][0] == 0;
        }
        return false;
    }

    public boolean isWithin() {
        return IntersectionMatrix.isTrue(this.matrix[0][0]) && this.matrix[0][2] == -1 && this.matrix[1][2] == -1;
    }

    public boolean isContains() {
        return IntersectionMatrix.isTrue(this.matrix[0][0]) && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public boolean isCovers() {
        boolean hasPointInCommon = IntersectionMatrix.isTrue(this.matrix[0][0]) || IntersectionMatrix.isTrue(this.matrix[0][1]) || IntersectionMatrix.isTrue(this.matrix[1][0]) || IntersectionMatrix.isTrue(this.matrix[1][1]);
        return hasPointInCommon && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public boolean isCoveredBy() {
        boolean hasPointInCommon = IntersectionMatrix.isTrue(this.matrix[0][0]) || IntersectionMatrix.isTrue(this.matrix[0][1]) || IntersectionMatrix.isTrue(this.matrix[1][0]) || IntersectionMatrix.isTrue(this.matrix[1][1]);
        return hasPointInCommon && this.matrix[0][2] == -1 && this.matrix[1][2] == -1;
    }

    public boolean isEquals(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA != dimensionOfGeometryB) {
            return false;
        }
        return IntersectionMatrix.isTrue(this.matrix[0][0]) && this.matrix[0][2] == -1 && this.matrix[1][2] == -1 && this.matrix[2][0] == -1 && this.matrix[2][1] == -1;
    }

    public boolean isOverlaps(int dimensionOfGeometryA, int dimensionOfGeometryB) {
        if (dimensionOfGeometryA == 0 && dimensionOfGeometryB == 0 || dimensionOfGeometryA == 2 && dimensionOfGeometryB == 2) {
            return IntersectionMatrix.isTrue(this.matrix[0][0]) && IntersectionMatrix.isTrue(this.matrix[0][2]) && IntersectionMatrix.isTrue(this.matrix[2][0]);
        }
        if (dimensionOfGeometryA == 1 && dimensionOfGeometryB == 1) {
            return this.matrix[0][0] == 1 && IntersectionMatrix.isTrue(this.matrix[0][2]) && IntersectionMatrix.isTrue(this.matrix[2][0]);
        }
        return false;
    }

    public boolean matches(String pattern) {
        if (pattern.length() != 9) {
            throw new IllegalArgumentException("Should be length 9: " + pattern);
        }
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                if (IntersectionMatrix.matches(this.matrix[ai][bi], pattern.charAt(3 * ai + bi))) continue;
                return false;
            }
        }
        return true;
    }

    public IntersectionMatrix transpose() {
        int temp = this.matrix[1][0];
        this.matrix[1][0] = this.matrix[0][1];
        this.matrix[0][1] = temp;
        temp = this.matrix[2][0];
        this.matrix[2][0] = this.matrix[0][2];
        this.matrix[0][2] = temp;
        temp = this.matrix[2][1];
        this.matrix[2][1] = this.matrix[1][2];
        this.matrix[1][2] = temp;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("123456789");
        for (int ai = 0; ai < 3; ++ai) {
            for (int bi = 0; bi < 3; ++bi) {
                builder.setCharAt(3 * ai + bi, Dimension.toDimensionSymbol(this.matrix[ai][bi]));
            }
        }
        return builder.toString();
    }
}

