/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.datatypes;

import org.jivesoftware.smack.datatypes.Scalar;
import org.jivesoftware.smack.util.NumberUtil;

public final class UInt16
extends Scalar
implements Comparable<UInt16> {
    private static final long serialVersionUID = 1L;
    private final int number;
    public static final int MIN_VALUE_INT = 0;
    public static final int MAX_VALUE_INT = 65535;
    public static final UInt16 MIN_VALUE = UInt16.from(0);
    public static final UInt16 MAX_VALUE = UInt16.from(65535);

    private UInt16(int number) {
        super(NumberUtil.requireUShort16(number));
        this.number = number;
    }

    public int nativeRepresentation() {
        return this.number;
    }

    public static UInt16 from(int number) {
        return new UInt16(number);
    }

    @Override
    public int hashCode() {
        return this.number;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UInt16) {
            UInt16 otherUint16 = (UInt16)other;
            return this.number == otherUint16.number;
        }
        return super.equals(other);
    }

    @Override
    public int compareTo(UInt16 o) {
        return Integer.compare(this.number, o.number);
    }

    @Override
    public UInt16 getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public UInt16 getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public UInt16 incrementedByOne() {
        int incrementedValue = this.number < 65535 ? this.number + 1 : 0;
        return UInt16.from(incrementedValue);
    }
}

