/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.datachannel;

import java.nio.ByteBuffer;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelBinaryMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelStringMessage;
import org.jitsi.videobridge.datachannel.protocol.OpenChannelAckMessage;
import org.jitsi.videobridge.datachannel.protocol.OpenChannelMessage;

public class DataChannel {
    private final DataChannelStack.DataChannelDataSender dataChannelDataSender;
    protected final int channelType;
    protected final int priority;
    protected final long reliability;
    protected final int sid;
    protected final String label;
    protected boolean ready = false;
    protected final Logger logger;
    private DataChannelStack.DataChannelEventListener eventListener;
    private DataChannelStack.DataChannelMessageListener messageListener;

    public DataChannel(DataChannelStack.DataChannelDataSender dataChannelDataSender, Logger parentLogger, int channelType, int priority, long reliability, int sid, String label) {
        this.dataChannelDataSender = dataChannelDataSender;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.channelType = channelType;
        this.priority = priority;
        this.reliability = reliability;
        this.sid = sid;
        this.label = label;
    }

    public void open() {
        OpenChannelMessage openMessage = new OpenChannelMessage(this.channelType, this.priority, this.reliability, this.label, "http://jitsi.org/protocols/colibri");
        ByteBuffer msg = openMessage.getBuffer();
        if (this.dataChannelDataSender.send(msg, this.sid, 50) < 0) {
            this.logger.error("Error sending data channel open message");
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    public void onDataChannelEvents(DataChannelStack.DataChannelEventListener listener) {
        this.eventListener = listener;
    }

    public void onDataChannelMessage(DataChannelStack.DataChannelMessageListener dataChannelMessageListener) {
        this.messageListener = dataChannelMessageListener;
    }

    public void onIncomingMsg(DataChannelMessage message) {
        if (message instanceof OpenChannelAckMessage) {
            this.ready = true;
            this.eventListener.onDataChannelOpened();
        } else if (message instanceof DataChannelStringMessage) {
            DataChannelStringMessage dataChannelStringMessage = (DataChannelStringMessage)message;
            this.logger.debug(() -> "Received data channel string message: " + dataChannelStringMessage.data);
        } else if (message instanceof DataChannelBinaryMessage) {
            DataChannelBinaryMessage dataChannelBinaryMessage = (DataChannelBinaryMessage)message;
            this.logger.debug(() -> "Received data channel binary message: " + ByteBufferKt.toHex(ByteBuffer.wrap(dataChannelBinaryMessage.data)));
        }
        this.messageListener.onDataChannelMessage(message);
    }

    protected int sendData(ByteBuffer data, int sid, int ppid) {
        return this.dataChannelDataSender.send(data, sid, ppid);
    }

    public void sendString(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending string data channel message: '" + message + "'");
        }
        DataChannelStringMessage stringMessage = new DataChannelStringMessage(message);
        this.dataChannelDataSender.send(stringMessage.getBuffer(), this.sid, 51);
    }
}

