/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdk.jfr.AnnotationElement;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.consumer.RecordingInput;

final class MetadataReader {
    private final DataInput input;
    private final List<String> pool;
    private final MetadataDescriptor descriptor;
    private final Map<Long, Type> types = new HashMap<Long, Type>();

    public MetadataReader(DataInput dataInput) throws IOException {
        this.input = dataInput;
        int n = dataInput.readInt();
        ((RecordingInput)dataInput).require(n, "Metadata string pool size %d exceeds available data");
        this.pool = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.pool.add(dataInput.readUTF());
        }
        this.descriptor = new MetadataDescriptor();
        MetadataDescriptor.Element element = this.createElement();
        MetadataDescriptor.Element element2 = element.elements("metadata").get(0);
        this.declareTypes(element2);
        this.defineTypes(element2);
        this.annotateTypes(element2);
        this.buildEvenTypes();
        MetadataDescriptor.Element element3 = element.elements("region").get(0);
        this.descriptor.gmtOffset = element3.attribute("gmtOffset", 1L);
        this.descriptor.locale = element3.attribute("locale", "");
        this.descriptor.root = element;
        if (Logger.shouldLog(LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE)) {
            ArrayList<Type> arrayList = new ArrayList<Type>(this.types.values());
            Collections.sort(arrayList, (type, type2) -> type.getName().compareTo(type2.getName()));
            for (Type type3 : arrayList) {
                type3.log("Found", LogTag.JFR_SYSTEM_PARSER, LogLevel.TRACE);
            }
        }
    }

    private String readString() throws IOException {
        return this.pool.get(this.readInt());
    }

    private int readInt() throws IOException {
        return this.input.readInt();
    }

    private MetadataDescriptor.Element createElement() throws IOException {
        int n;
        String string = this.readString();
        MetadataDescriptor.Element element = new MetadataDescriptor.Element(string);
        int n2 = this.readInt();
        for (n = 0; n < n2; ++n) {
            element.addAttribute(this.readString(), this.readString());
        }
        n = this.readInt();
        for (int i = 0; i < n; ++i) {
            element.add(this.createElement());
        }
        return element;
    }

    private void annotateTypes(MetadataDescriptor.Element element) throws IOException {
        for (MetadataDescriptor.Element element2 : element.elements("class")) {
            ArrayList<AnnotationElement> arrayList;
            Type type = this.getType("id", element2);
            ArrayList<AnnotationElement> arrayList2 = new ArrayList<AnnotationElement>();
            for (MetadataDescriptor.Element element3 : element2.elements("annotation")) {
                arrayList2.add(this.makeAnnotation(element3));
            }
            arrayList2.trimToSize();
            type.setAnnotations(arrayList2);
            int n = 0;
            if (type instanceof PlatformEventType) {
                List<SettingDescriptor> list = ((PlatformEventType)type).getAllSettings();
                for (MetadataDescriptor.Element element4 : element2.elements("setting")) {
                    arrayList = new ArrayList<AnnotationElement>();
                    for (MetadataDescriptor.Element element5 : element4.elements("annotation")) {
                        arrayList.add(this.makeAnnotation(element5));
                    }
                    arrayList.trimToSize();
                    PrivateAccess.getInstance().setAnnotations(list.get(n), arrayList);
                    ++n;
                }
            }
            n = 0;
            List<ValueDescriptor> list2 = type.getFields();
            for (MetadataDescriptor.Element element4 : element2.elements("field")) {
                arrayList = new ArrayList();
                for (MetadataDescriptor.Element element5 : element4.elements("annotation")) {
                    arrayList.add(this.makeAnnotation(element5));
                }
                arrayList.trimToSize();
                PrivateAccess.getInstance().setAnnotations(list2.get(n), arrayList);
                ++n;
            }
        }
    }

    private AnnotationElement makeAnnotation(MetadataDescriptor.Element element) throws IOException {
        Type type = this.getType("class", element);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            Object object;
            if (valueDescriptor.isArray()) {
                Object object2;
                object = new ArrayList();
                int n = 0;
                while ((object2 = element.attribute(valueDescriptor.getName() + "-" + n)) != null) {
                    object.add(this.objectify(valueDescriptor.getTypeName(), (String)object2));
                    ++n;
                }
                object2 = Utils.makePrimitiveArray(valueDescriptor.getTypeName(), (List<Object>)object);
                if (object2 == null) {
                    throw new IOException("Unsupported type " + object + " in array");
                }
                arrayList.add(object2);
                continue;
            }
            object = element.attribute(valueDescriptor.getName());
            arrayList.add(this.objectify(valueDescriptor.getTypeName(), (String)object));
        }
        return PrivateAccess.getInstance().newAnnotation(type, arrayList, false);
    }

    private Object objectify(String string, String string2) throws IOException {
        try {
            switch (string) {
                case "int": {
                    return Integer.valueOf(string2);
                }
                case "long": {
                    return Long.valueOf(string2);
                }
                case "double": {
                    return Double.valueOf(string2);
                }
                case "float": {
                    return Float.valueOf(string2);
                }
                case "short": {
                    return Short.valueOf(string2);
                }
                case "char": {
                    if (string2.length() != 1) {
                        throw new IOException("Unexpected size of char");
                    }
                    return Character.valueOf(string2.charAt(0));
                }
                case "byte": {
                    return Byte.valueOf(string2);
                }
                case "boolean": {
                    return Boolean.valueOf(string2);
                }
                case "java.lang.String": {
                    return string2;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Could not parse text representation of " + string);
        }
        throw new IOException("Unsupported type for annotation " + string);
    }

    private Type getType(String string, MetadataDescriptor.Element element) {
        long l = element.longValue(string);
        Type type = this.types.get(l);
        if (type == null) {
            String string2 = element.attribute("type");
            throw new IllegalStateException("Type '" + l + "' is not defined for " + string2);
        }
        return type;
    }

    private void buildEvenTypes() {
        for (Type type : this.descriptor.types) {
            if (!(type instanceof PlatformEventType)) continue;
            this.descriptor.eventTypes.add(PrivateAccess.getInstance().newEventType((PlatformEventType)type));
        }
    }

    private void defineTypes(MetadataDescriptor.Element element) {
        for (MetadataDescriptor.Element element2 : element.elements("class")) {
            Object object;
            String string;
            long l = element2.attribute("id", -1L);
            Type type = this.types.get(l);
            for (MetadataDescriptor.Element element3 : element2.elements("setting")) {
                string = element3.attribute("name");
                object = element3.attribute("name");
                Type type2 = this.getType("class", element3);
                PlatformEventType platformEventType = (PlatformEventType)type;
                platformEventType.add(PrivateAccess.getInstance().newSettingDescriptor(type2, string, (String)object, new ArrayList<AnnotationElement>(2)));
            }
            for (MetadataDescriptor.Element element3 : element2.elements("field")) {
                string = element3.attribute("name");
                object = this.getType("class", element3);
                long l2 = element3.attribute("dimension", 0L);
                boolean bl = element3.attribute("constantPool") != null;
                type.add(PrivateAccess.getInstance().newValueDescriptor(string, (Type)object, new ArrayList<AnnotationElement>(), (int)l2, bl, null));
            }
            type.trimFields();
        }
    }

    private void declareTypes(MetadataDescriptor.Element element) {
        for (MetadataDescriptor.Element element2 : element.elements("class")) {
            String string = element2.attribute("name");
            String string2 = element2.attribute("superType");
            boolean bl = element2.attribute("simpleType") != null;
            long l = element2.attribute("id", -1L);
            Type type = Type.SUPER_TYPE_EVENT.equals(string2) ? new PlatformEventType(string, l, false, false) : new Type(string, string2, l, false, bl);
            this.types.put(l, type);
            this.descriptor.types.add(type);
        }
    }

    public MetadataDescriptor getDescriptor() {
        return this.descriptor;
    }
}

